<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."io/FileUtil.php");
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.1.2
 */
class ProjectModel{
	var $rhacopath					= "";
	var $url							= "";

	var $defineLogHtml				= "";
	var $defineLogSysLevel			= "";
	var $defineLogDispLevel			= "";	
	var $defineLogFileLevel			= "";
	var $defineLogFilePath			= "";

	var $defineCachePath				= "";
	var $defineTemplateCache			= false;
	var $defineTemplateCacheRefresh	= true;
	var $defineTemplateCacheTime		= 0;
	var $defineCachePathDot			= true;
	var $defineFeedCache				= false;
	var	$defineFeedCacheTime			= 0;
	
	var $isScaffold					= "";
	var $rhacovar					= 0;
	
	var $sessionExpire				= 0;
	var $sessionCache				= "nocache";
	var $cookieExpire				= 0;
		
	var $inputList = array();	
	var $selectList = array();	
	var $defineList = array();
	var $directoryList = array();
	var $databaseList = array();
	var $applicationList = array();
	var $dbconnectionTypeList = array();
	
	function ProjectModel(){
		$this->url = "http://localhost";

		if(defined("CONTEXT_URL")){
			$this->url = constant("CONTEXT_URL");
		}else{
			if(!empty($_SERVER["SCRIPT_URI"])){
				$this->url = $_SERVER["SCRIPT_URI"];
			}else if(!empty($_SERVER["SERVER_NAME"])){
				$this->url = sprintf("http://%s%s",$_SERVER["SERVER_NAME"],$_SERVER["REQUEST_URI"]);
			}
			if(preg_match("/^(.+)\/.+$/",$this->url,$url)){
				$this->url = $url[1];
			}
		}
		$this->defineCachePath			= Rhaco::define("CACHE_PATH",FileUtil::getFilePath(Rhaco::path(),"work"));
		$this->defineCachePathDot			= Rhaco::define("CACHE_PATH_DOT",true);

		$this->defineTemplateCache		= Rhaco::define("TEMPLATE_CACHE",false);
		$this->defineTemplateCacheRefresh	= Rhaco::define("TEMPLATE_CACHE_REFRESH",true);
		$this->defineTemplateCacheTime	= Rhaco::define("TEMPLATE_CACHE_TIME",86400);
		
		$this->defineFeedCache			= Rhaco::define("FEED_CACHE",false);		
		$this->defineFeedCacheTime		= Rhaco::define("FEED_CACHE_TIME",10800);

		$this->defineLogHtml				= Rhaco::define("LOG_DISP_HTML",true);
		$this->defineLogSysLevel			= Rhaco::define("LOG_SYS_LEVEL","none");
		$this->defineLogDispLevel			= Rhaco::define("LOG_DISP_LEVEL","none");
		$this->defineLogFileLevel			= Rhaco::define("LOG_FILE_LEVEL","none");
		$this->defineLogFilePath			= Rhaco::define("LOG_FILE_PATH",FileUtil::getFilePath(Rhaco::path(),"work/log"));
		
		$this->isScaffold				= "false";

		if(extension_loaded("mysql"))	$this->dbconnectionTypeList["MySQL"]		= "MySQL";
		if(extension_loaded("pgsql"))	$this->dbconnectionTypeList["PostgreSQL"]	= "PostgreSQL";
		if(extension_loaded("SQLite"))	$this->dbconnectionTypeList["SQLite"]	= "SQLite";
	}
	function setUrl($value){
		$this->url	= $value;
	}
	function setRhacopath($value){
		$this->rhacopath	= str_replace("\\","/",$value);
	}
	
	function setDefineLogHtml($value){
		$this->defineLogHtml	= $value;
	}
	function setDefineLogSysLevel($value){
		$this->defineLogSysLevel	= $value;
	}
	function setDefineLogDispLevel($value){
		$this->defineLogDispLevel	= $value;
	}
	function setDefineLogFileLevel($value){
		$this->defineLogFileLevel	= $value;
	}
	function setDefineLogFilePath($value){
		$this->defineLogFilePath	= $value;
	}
	function setDefineTemplateCache($value){
		$this->defineTemplateCache	= $value;
	}
	function setDefineTemplateCacheRefresh($value){
		$this->defineTemplateCacheRefresh	= $value;
	}	
	function setDefineCachePath($value){
		$this->defineCachePath	= $value;
	}
	function setIsScaffold($value){
		$this->isScaffold	= $value;
	}
	function setDefineCachePathDot($value){
		$this->defineCachePathDot	= $value;
	}
	function setDefineTemplateCacheTime($value){
		$this->defineTemplateCacheTime	= $value;
	}
	function setDefineFeedCache($value){
		$this->defineFeedCache	= $value;
	}
	function setDefineFeedCacheTime($value){
		$this->defineFeedCacheTime	= $value;
	}
}
?>