<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."network/http/Request.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."network/http/data/RequestLoginConditionFile.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/TagUtil.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/SimpleTag.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/HtmlParser.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/TagParser.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/Variable.php");
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.2.4
 */
class RequestLogin extends Request{
	function login($requestLoginCondition=null,$request=null){
		if(!RequestLogin::isLogin()){
			if(!Variable::isClassType(RequestLoginCondition,$requestLoginCondition)){
				$requestLoginCondition = new RequestLoginConditionFile();
			}
			if(!Variable::isClassType(Request,$request)){
				$request = new RequestLogin();
			}
			if(!$requestLoginCondition->condition($request)){
				$requestLoginCondition->invalid($request);
				return false;
			}
			$_SESSION[RequestLogin::getSessionLoginIdName()] = session_id();
			
			$requestLoginCondition->after($request);			
		}
		return true;
	}
	function logout(){
		unset($_SESSION[RequestLogin::getSessionLoginIdName()]);
		unset($_SESSION[RequestLogin::getSessionLoginName()]);
		setcookie(RequestLogin::getSessionLoginName(),"",time() - 3600);
	}
	function getSessionLoginIdName(){
		return Rhaco::define("REQUEST_SESSION_LOGIN_ID","SESSION_LOGIN_ID");
	}
	function getSessionLoginName(){
		return Rhaco::define("REQUEST_SESSION_LOGIN","SESSION_LOGIN");
	}
	function loginRequired($requestLoginCondition=null,$request=null){
		Rhaco::usesession();

		if(!RequestLogin::isLogin()){
			RequestLogin::login($requestLoginCondition,$request);
		}
	}
	function isLogin(){
		return isset($_SESSION[RequestLogin::getSessionLoginIdName()]);
	}
	function isLoginSession(){
		return isset($_SESSION[RequestLogin::getSessionLoginName()]);
	}
	function getLoginSession(){
		return $_SESSION[RequestLogin::getSessionLoginName()];		
	}
	function setLoginSession($value){
		$_SESSION[RequestLogin::getSessionLoginName()] = $value;
	}
	function isLoginCookie(){
		return isset($_COOKIE[RequestLogin::getSessionLoginName()]);
	}	
	function getLoginCookie(){
		return $_COOKIE[RequestLogin::getSessionLoginName()];		
	}
	function setLoginCookie($value){
		setcookie(RequestLogin::getSessionLoginName(),$value,time() + Rhaco::define("COOKIE_EXPIRE_TIME",0));		
	}
}
?>