<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/HtmlParser.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/TemplateFormatter.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."network/http/Request.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."network/http/Header.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/DbUtil.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/data/Criteria.php");
/**
 * @author makoto tsuyuki
 * @author kazutaka tokushima
 * @license New BSD License
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.1.1
 */
class GenericView{
	var $dbUtil;
	var $request;

	function GenericView($dbConnection,$new=true){
		$this->dbUtil	= new DbUtil($dbConnection,$new);
		$this->request	= new Request();
	}
	function read($tableObject,$criteria=null,$page=null,$pagenateBy=null) {
		$htmlParser	= new HtmlParser();
		$pager		= new Pager();
		$htmlParser->setVariable($this->request->getVariable());
		
		if(Variable::isClassType(TableObjectBase,$tableObject)){
			$criteria	= (Variable::isClassType(Criteria,$criteria)) ? $criteria : new Criteria();
			$page		= ($page === null) ? intval($this->request->getVariable("page",1)) : $page;
			$pagenateBy	= ($pagenateBy === null) ? intval($this->request->getVariable("pagenateBy",20)) : $pagenateBy;
	
			if($page > 0){
				$pager	= new Pager($this->dbUtil->count($tableObject, $criteria),$pagenateBy,$pagenateBy * round(abs($page - 1)));

				$criteria->setPager($pager);
				$htmlParser->setVariable("pager",$pager);
				$htmlParser->setVariable($pager->pages($page,$this->request->getVariable("pages",10)));
				$htmlParser->setVariable("paging_query",TemplateFormatter::httpBuildQuery($this->request->getVariable()));
			}
			$htmlParser->setVariable("object_list",$this->dbUtil->select($tableObject,$criteria));
		}
		$htmlParser->setFileName(sprintf("generic/%s_list.html", strtolower(get_class($tableObject))));
		return $htmlParser;
	}
	function detail($tableObject,$criteria=null){
		$htmlParser	= new HtmlParser();
		$object		= null;
		$count		= 0;

		$htmlParser->setVariable($this->request->getVariable());

		if(Variable::isClassType(TableObjectBase,$tableObject)){
			$object	= $this->dbUtil->get($tableObject,$this->_primaryCriteria($tableObject,$criteria));
		}
		if(!Variable::isClassType(TableObjectBase,$object)){
			Http::status(404);
			$htmlParser->setFileName("generic/404.html");
		}else{
			$htmlParser->setVariable("object",$object);
			$htmlParser->setFileName(sprintf("generic/%s_detail.html",strtolower(get_class($tableObject))));
		}
		return $htmlParser;
	}
	function create($redirectHref,$tableObject){
		$htmlParser	= new HtmlParser();
		$object		= null;
				
		if($this->isPost()){
			$object = $this->dbUtil->insert($this->request->toObject($tableObject));
			
			if(Variable::isClassType(TableObjectBase,$object)){
				$this->_redirect($redirectHref,$object);
			}
		}
		$htmlParser->setVariable($this->request->getVariable());
		$htmlParser->setFileName(sprintf("generic/%s_form.html", strtolower(get_class($tableObject))));
		return $htmlParser;
	}
	function update($redirectHref,$tableObject,$criteria=null){
		$htmlParser		= new HtmlParser();
		$tableObject	= $this->dbUtil->get($tableObject,$this->_primaryCriteria($tableObject,$criteria));

		if($this->isPost()){
			if(Variable::isClassType(TableObjectBase,$tableObject)){
				if($this->dbUtil->update($this->request->toObject($tableObject))){
					$this->_redirect($redirectHref,$tableObject);
				}
			}
		}
		$htmlParser->setVariable($this->request->getVariable());
		$htmlParser->setVariable(Variable::objectConvHash($tableObject));
		$htmlParser->setVariable("object",$tableObject);
		$htmlParser->setFileName(sprintf("generic/%s_form.html", strtolower(get_class($tableObject))));
		return $htmlParser;
	}
	function drop($redirectHref,$tableObject,$criteria=null){
		$htmlParser		= new HtmlParser();
		$tableObject	= $this->dbUtil->get($tableObject,$this->_primaryCriteria($tableObject,$criteria));

		if($this->isPost()){
			if($this->dbUtil->delete($this->request->toObject($tableObject,$this->_primaryCriteria($tableObject,$criteria)))){
				$this->_redirect($redirectHref);
			}
		}
		$htmlParser->setVariable($this->request->getVariable());
		$htmlParser->setVariable(Variable::objectConvHash($tableObject));
		$htmlParser->setVariable("object",$tableObject);
		$htmlParser->setFileName(sprintf("generic/%s_detail.html", strtolower(get_class($tableObject))));
		return $htmlParser;
	}
	function _primaryCriteria($tableObject,$criteria){
		if(!Variable::isClassType(Criteria,$criteria)){
			$criteria	= new Criteria();
			$bool		= false;
			$count		= 0;

			foreach($tableObject->__primaryKey() as $column){
				$value = call_user_func_array(array(&$tableObject,sprintf("get%s",$column->variable)),array());

				if(!empty($value)){
					$bool = true;
					break;
				}
			}
			if(!$bool){
				foreach($tableObject->__primaryKey() as $column){
					$value = $this->request->getUrlMap($count);

					if(empty($value)){
						ExceptionTrigger::raise(new IllegalArgumentException($column->variable));
						return null;
					}else{
						$criteria->add($column,$value);
						$count++;
					}
				}
			}
		}
		return $criteria;
	}
	function _redirect($redirectHref,$tableObject=null){
		if($tableObject != null){
			$redirectHref	= Variable::toArray($redirectHref);
			$href			= $redirectHref[0];
			$href			= (substr($href,-1) == "/") ? substr($href,0,-1) : $href;
	
			foreach($tableObject->__primaryKey() as $column){
				$href .= "/".call_user_func_array(array(&$tableObject,sprintf("get%s",$column->variable)),array());
			}
			$redirectHref[0] = $href;
		}
		Header::redirect($redirectHref);
	}
	function isPost(){
		return $this->request->isPost();
	}
	function toObject($object){
		return $this->request->toObject($object);
	}
	function getUrlMap($id){
		return $this->request->getUrlMap($id);
	}
	function getVariable($name=""){
		return $this->request->getVariable($name);
	}
	function isVariable($name){
		return $this->request->isVariable($name);
	}
}
?>