<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/SimpleTag.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/data/RssChannel09.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/data/RssImage09.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/data/RssItem20.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/data/RssCloud.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2006- The Rhacophorus Project. All rights reserved.
 * @version 0.1.1
 */
class RssChannel20 extends RssChannel09{
	var $cloud = "";

	function _set($tag){
		parent::_set($tag);

		foreach($tag->getIn("cloud") as $intag){
			$data = new RssCloud();
			$data->set($intag->get());
			$this->setCloud($data);
		}
		$this->itemList = array();
		foreach($tag->getIn("item") as $intag){
			$data = new RssItem20();
			$data->set($intag->get());
			$this->itemList[] = $data;
		}
	}
	function _get($outTag){
		$tag = new SimpleTag("cloud");
		$tag->setValue($this->getCloud());
		$outTag->addValue($tag->get());

		return parent::_get($outTag);
	}
	function setCloud($value){
		$this->cloud = $value;
	}
	function getCloud(){
		return $this->cloud;
	}
	function setItem($titleOrObject,$description="",$link="",$about=""){
		if(Variable::isClassType(RssItem,$titleOrObject)){
			$this->itemList[] = $titleOrObject;
		}else{
			$this->itemList[] = new RssItem20($titleOrObject,$description,$link,$about);
		}
	}
	function setImage($titleOrObject,$url="",$link="",$about=""){
		if(Variable::isClassType(RssImage09,$titleOrObject)){
			$this->imageList[] = $titleOrObject;
		}else{
			$this->imageList[] = new RssImage09($titleOrObject,$url,$link,$about);
		}
	}
	function setTextinput($titleOrObject,$name="",$description="",$link="",$about=""){
		if(Variable::isClassType(RssTextinput,$titleOrObject)){
			$this->textinputList[] = $titleOrObject;
		}else{
			$this->textinputList[] = new RssTextinput($titleOrObject,$name,$description,$link,$about);
		}
	}
}