<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/Rss.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/data/RssChannel09.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/SimpleTag.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.1.4
 */
class Rss09 extends Rss{
	var $version;

	function Rss09(){
		$this->channel = new RssChannel09();
	}
	function set($src){
		$tag		= new SimpleTag();

		if(!$tag->set($src,"rss")){
			return false;
		}
		$this->setVersion($tag->getParameter("version"));

		foreach($tag->getIn("channel") as $intag){
			$data = new RssChannel09();
			$data->set($intag->get());
			$this->channel = $data;
		}
		return true;
	}
	function get(){
		$outTag	= new SimpleTag("rss");
		$outTag->setParameter("version","0.91");
		
		if(Variable::isClassType(RssChannel09,$this->getChannel())){
			$channel = $this->getChannel();
			$outTag->addValue($channel->get());
		}
		return sprintf("%s\n%s",
				"<!DOCTYPE rss PUBLIC \"-//Netscape Communications//DTD RSS 0.91//EN\" \"http://my.netscape.com/publish/formats/rss-0.91.dtd\">",
				$outTag->get()
				);
	}
	function setVersion($value){
		$this->version = $value;
	}
	function getVersion(){
		return $this->version;
	}
	function setChannel($title,$description="",$link="",$language=""){
		$this->channel = new RssChannel09($title,$description,$link,$language);
	}
	function getItem(){
		if(Variable::isClassType(RssChannel09,$this->channel)){
			return $this->channel->getItem();
		}
		return array();
	}
	function setItem($title,$description="",$link="",$about=""){
		if(!Variable::isClassType(RssChannel09,$this->channel)){
			$this->channel = new RssChannel09($title,$description,$link);
		}
		if(Variable::isClassType(RssItem09,func_get_arg(0))){
			$this->channel->setItem(func_get_arg(0));
		}else{
			$this->channel->setItem($title,$description,$link,$about);
		}		
	}
}
?>