<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/data/TableObjectBase.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.2.5
 */
class TemplateFormatter{
	function text2Html($value){
		return TemplateFormatter::nl2br(TemplateFormatter::escape($value));
	}
	function escape($value){
		if(!empty($value) && is_string($value)){
			$value = str_replace(array("<",">","'","\""),array("&lt;","&gt;","&#039;","&quot;"),$value);		
		}
		return $value;
	}
	function htmlencode($value){
		if(!empty($value) && is_string($value)){
			$value = htmlentities($value,ENT_QUOTES);
		}
		return $value;
	}
	function htmldecode($value){
		if(!empty($value) && is_string($value)){
			$value = html_entity_decode($value);
		}
		return $value;
	}
	function nl2br($value){
		if(!empty($value) && is_string($value)){
			$value = nl2br($value);
		}
		return $value;
	}
	function urlencode($value){
		if(!empty($value) && is_string($value)){
			$value = rawurlencode($value);
		}
		return $value;
	}
	function getJsDocument($value){
		if(!empty($value) && is_string($value)){
			$value = preg_replace("/([\"\'])/","\\\\\\1",$value);
			$value = str_replace("\n","\\\\n",$value);
			$value = str_replace("\r","\\\\r",$value);
		}
		return $value;
	}	
	function httpBuildQuery(){
		$argList = func_get_args();		
		
		if(is_array($argList[0])){
			$list = $argList[0];
			
			if(sizeof($argList) > 1){
				$list = array();
				
				for($i=1;$i<sizeof($argList);$i++){
					$list[$argList[$i]] = $argList[0][$argList[$i]];
				}
			}
			foreach($list as $key => $request){
				if(!is_object($request) && !is_array($request)){
					$requestString .= sprintf("&%s=%s",$key,urlencode($request));
				}
			}
			$requestString = substr($requestString,1);
		}
		return $requestString;
	}
	function substring($value,$limit,$offset=0){
		$sep = "";
		
		if(StringUtil::strlen($value) > ($limit - $offset)){
			$sep = "...";
		}
		return StringUtil::substring($value,$offset,$limit).$sep;
	}
}
?>