<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."resources/Message.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."network/Url.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."network/http/Http.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/SimpleTag.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."io/FileUtil.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/StringUtil.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."util/Logger.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 1.2.3
 */
class TagParser{
	var $expiryTime		= 86400;
	var $variables		= array();
	var $fileUtil		= null;
	var $fileName		= "";

	function TagParser($filename=null){
		$this->fileUtil = new FileUtil();
		$this->fileName = $filename;
	}
	function write($templateFileName="",$remotePath="",$variables=array()){
		print(StringUtil::encoding($this->read($templateFileName,$remotePath,$variables)));
	}
	function read($templateFileName="",$remotePath="",$variables=array()){
		if(empty($templateFileName)){
			$templateFileName = $this->fileName;
		}
		$src					= "";
		$remotePath			= $this->_getTemplateUrl($remotePath,$templateFileName);
		$templateFileName	= $this->_getTemplatePath($templateFileName);
		$cashFilename		= "";
		$expiryFilename		= "";
		$cashFlag			= false;

		if(defined("TEMPLATE_CASH")){
			$cashFlag = Variable::getBoolean(constant("TEMPLATE_CASH"));
		}
		if(!is_array($variables)){
			$variables = array($variables);
		}
		$variables = $this->_setSpecialVariables(array_merge($variables,$this->variables));

		foreach($variables as $key => $variable){
			global ${$key};
			${$key} = $variable;
		}
		if($cashFlag && $this->_cash($templateFileName,$remotePath)){
			list($cashFilename,$expiryFilename) = $this->_getCashUrl($templateFileName);

			Logger::debug(Message::_("read cash file [{1}]",$cashFilename));
			ob_start();
				include($cashFilename);
				$src = ob_get_contents();
			ob_end_clean();
		}else{
			$readsrc = $this->parse($templateFileName,$remotePath);

			if($readsrc == false){
				Logger::warning(Message::_("read template file [{1}]",$templateFileName));
				return false;
			}else{
				Logger::debug(Message::_("read template file [{1}]",$templateFileName));
				ob_start();
					eval("?>".stripslashes($readsrc));
					$src = ob_get_contents();
				ob_end_clean();
			}
		}
		return $this->_doRead($this->_unescapeSource($src));
	}
	function parse($templateFileName,$remotePath=""){		
		$src = $this->_getTemplateSource($templateFileName);
		$src = $this->_toTag($src);
		$src = $this->_system($src);
		$src = $this->_exec($src);
		$src = $this->_parsePrintVariable($src);
		$src = $this->_parseMessage($src);
		$src = Url::parse($src,$remotePath);

		return $this->_escapeSource($src);
	}
	function _parseMessage($src){
		if(preg_match_all("/.{0,2}(_\((([\"\']).+?\\3)\))/",$src,$matches)){
			$stringList		= array();

			foreach($matches[0] as $key => $value){
				$chkstring = substr($value,0,2);
				if($chkstring != "::" && $chkstring != "->"){
					$stringList[$matches[1][$key]] = sprintf("<?php print(\$message->_(%s)); ?>",$matches[2][$key]);
				}
			}
			foreach($stringList as $baseString => $string){
				$src = str_replace($baseString,$string,$src);
			}
			unset($stringList);
		}
		return $src;
	}
	function _escapeSource($src){
		$repList = array();
		
		if(preg_match_all("/<\?([\w\d]+)/",$src,$null)){
			foreach($null[1] as $key => $value){
				$repList[$value] = 1;
			}
			foreach($repList as $key => $value){
				if(strtolower($key) != "php"){
					$src = str_replace(sprintf("<?%s",$key),sprintf("__PHP_TAG_ESCAPE__%s",$key),$src);
				}
			}
		}
		return $src;
	}
	function _unescapeSource($src){
		$src = str_replace("__PHP_TAG_ESCAPE__","<?",$src);
		
		return $src;
	}
	function clearCash($templateFileName){
		if(defined("TEMPLATE_CASH")){
			if(Variable::getBoolean(constant("TEMPLATE_CASH"))){
				list($cashFilename,$expiryFilename) = $this->_getCashUrl($this->_getTemplatePath($templateFileName));

				if($this->fileUtil->rm($expiryFilename)){
					if($this->fileUtil->rm($cashFilename)){
						Logger::debug(Message::_("cash file deleted [{1}]",$cashFilename));
					}
					Logger::debug(Message::_("cash file deleted [{1}]",$expiryFilename));
				}else{
					Logger::debug(Message::_("fails in deletion [{1}]",$expiryFilename));
				}
			}
		}
	}	
	function setExpiryTime($time){
		$this->expiryTime = $time;
	}
	function setVariable($arrayOrKey,$value=""){
		if(!is_array($arrayOrKey)){
			$arrayOrKey = array($arrayOrKey=>$value);
		}
		foreach($arrayOrKey as $key => $value){
			$this->variables[$key] = $value;
		}
	}
	function clearVariable(){
		if(func_num_args() == 0){
			$this->variables = array();
		}else{
			foreach(func_get_args() as $name){
				unset($this->variables[$name]);
			}
		}
	}	
	function setFileName($value){
		$this->fileName = $value;
	}
	function _getPhpTagStart(){
		return sprintf("<?php ");
	}
	function _getPhpTagEnd(){
		return sprintf(" ?>");
	}
	function _toTag($src){
		$tagName		= array();
		$methodList	= array();

		foreach(get_class_methods($this) as $methodName){
			if(preg_match("/^_toTag(.+)$/i",$methodName)){
				$methodList[] = $methodName;
			}
		}
		sort($methodList);
		foreach($methodList as $methodName){
			$src = call_user_func_array(array($this, $methodName),array($src));		
		}
		return $src;
	}
	function _doRead($src){
		$tagName		= array();
		$methodList	= array();		
		
		foreach(get_class_methods($this) as $methodName){
			if(preg_match("/^_doRead(.+)$/i",$methodName)){
				$methodList[] = $methodName;
			}
		}
		sort($methodList);
		foreach($methodList as $methodName){
			$src = call_user_func_array(array($this, $methodName),array($src));		
		}
		return $src;
	}		
	function _exec($src){
		$tagName		= array();
		$methodList	= array();		

		foreach(get_class_methods($this) as $methodName){
			if(preg_match("/^_exec(.+)$/i",$methodName)){		
				$methodList[] = $methodName;
			}
		}
		sort($methodList);
		foreach($methodList as $methodName){
			$src = call_user_func_array(array($this, $methodName),array($src));		
		}
		return $src;
	}
	function _system($src){
		$tagName		= array();
		$methodList	= array();		

		foreach(get_class_methods($this) as $methodName){
			if(preg_match("/^_system(.+)$/i",$methodName)){
				$methodList[] = $methodName;
			}
		}
		sort($methodList);
		foreach($methodList as $methodName){
			$src = call_user_func_array(array($this, $methodName),array($src));		
		}
		return $src;
	}
	function _parsePrintVariable($src){
		$array = $this->_matchVariable($src);

		foreach($array as $variable){
			$variableName	= $this->_parsePlainVariable($variable);
			$src				= str_replace($variable,sprintf("%sprint(%s);%s",
											$this->_getPhpTagStart(),
											$variableName,
											$this->_getPhpTagEnd()
										),
										$src
									);
		}
		unset($array);
		return $src;
	}
	function _toVariable($src){
		if(!preg_match("/^\{\$.+\}$/",$src)){
			return sprintf("{\$%s}",$src);
		}
		return $src;
	}
	function _parsePlainVariable($src){
		while(true){
			$array = $this->_matchVariable($src);
			
			if(sizeof($array) <= 0){
				break;
			}
			foreach($array as $variable){
				$src = str_replace($variable,substr(str_replace(".","->",$variable),1,-1),$src);
			}
			unset($array,$variable);
		}
		return $src;
	}
	function _matchVariable($src){
		$value			= "";
		$position		= 0;
		$length			= 0;
		$variableHash	= array();
		$variables		= array();
		$src				= preg_replace("/[\r\n\s]/","\t",$src);

		while(preg_match("/({(\\$\w[^\t]+)})/",$src,$variables,PREG_OFFSET_CAPTURE)){
			$value		= $variables[1][0];
			$position	= $variables[1][1];

			if($value == ""){	break;	}
			if(substr_count($value,"}") > 1){
				for($i=0,$start=0,$end=0;$i<strlen($value);$i++){			
					if($value[$i] == "{"){
						$start++;
					}else if($value[$i] == "}"){
						if($start == ++$end){							
							$value = substr($value,0,$i+1);
							break;
						}
					}
				}
			}
			$length	= strlen($value);			
			$src		= substr($src,$position + $length);
			$variableHash[sprintf("%03d_%s",$length,$value)] = $value;
		}
		krsort($variableHash);
		unset($src,$variables,$value,$position,$length);
		return $variableHash;
	}
	function _variableQuote($src){
		return preg_replace("/[^\w\d]/","",$src);
	}
	function _getVariableString($src){
		if(substr($src,0,1) == "$"){
			return $src;
		}
		return "\$".$src;
	}
	function _getCashUrl($templateFileName){
		if(!empty($templateFileName)){
			$null = null;
			$templateFileName	= preg_replace("/[¥¥¥:]/","/",$templateFileName);
			$templateFileName	= preg_replace("/[¥~¥&]/","",$templateFileName);
			$base				= str_replace("\\","/",Rhaco::define("TEMPLATE_CASH_PATH",Rhaco::path("work")));

			if(!empty($base) && (!(substr($base,-1) == "/" || substr($base,-1) == "\\"))){
				$base = $base."/";
			}
			if(preg_match("/:\/\/([^\/]+)$/",$templateFileName,$null)){
				$templateFileName = sprintf("%s/index",$templateFileName);
			}else if(preg_match("/[\/\\\\]$/",$templateFileName,$null)){
				$templateFileName = sprintf("%sindex",$templateFileName);
			}
			$templateFileName = preg_replace("/[\/]+/","/",$templateFileName);
			if(substr($templateFileName,0,1) == "/"){
				$templateFileName = substr($templateFileName,1);
			}
			return array(sprintf("%scash/%s",$base,$templateFileName),sprintf("%sexpiry/%s",$base,$templateFileName));
		}
		return array(sprintf("%scash/null",$base),sprintf("%sexpiry/null",$base));
	}
	function _getTemplatePath($value){
		return $this->_getDefinePathNormalize("TEMPLATE_PATH",$value);
	}
	function _getTemplateUrl($value="",$templateFileName=""){
		if(empty($value)){
			$value = $templateFileName;
		}
		$url = $this->_getDefinePathNormalize("TEMPLATE_URL",$value);

		if(empty($url)){
			return $this->_getTemplatePath("");
		}
		return $url;
	}
	function _getDefinePathNormalize($defineName,$value){
		$url		= "";
		$null	= null;
		$value	= str_replace("\\","/",$value);

		if(is_string($value) && preg_match("/^[a-z]\:\//i",$value,$null)){
			$value = str_replace("\\","/",$value);
		}else if(is_string($value) &&  substr($value,0,1) != "/" && !preg_match("/\:\/\//",$value,$null)){
			$url = Rhaco::define($defineName);
			if(!empty($url) && substr($url,-1) != "/"){
				$url .= "/";
			}
			$url = str_replace("\\","/",$url);
		}
		return sprintf("%s%s",$url,$value);
	}
	function _cash($templateFileName,$remotePath){	
		list($cashFilename,$expiryFilename)	= $this->_getCashUrl($templateFileName);

		if(!Rhaco::define("TEMPLATE_CASH_REFRESH",true)){
			if($this->fileUtil->isFile($cashFilename)){
				return true;
			}
		}
		if(
			!$this->fileUtil->isFile($expiryFilename) ||
			!$this->fileUtil->isFile($cashFilename) ||
			($this->fileUtil->read($expiryFilename) < mktime()) ||
			preg_match("/\:\/\//",$templateFileName) ||
			$this->fileUtil->getUpdateTime($templateFileName) >= $this->fileUtil->getUpdateTime($expiryFilename)
		){
			$src = $this->parse($templateFileName,$remotePath);

			if($src == false){
				return false;
			}
			if($this->fileUtil->write($cashFilename,$src)){
				if($this->fileUtil->write($expiryFilename,mktime()+$this->expiryTime)){
					Logger::debug(Message::_("made cash file [{1}]",$cashFilename));
					return true;
				}
			}
			Logger::warning(Message::_("made cash file [{1}]",$expiryFilename));
			return false;
		}
		return true;
	}
	function _getTemplateSource($templateFileName){
		$src = "";
		
		if(preg_match("/[\w]+:\/\/[\w]+/",$templateFileName)){
			$src = Http::body($templateFileName);
		}else{
			$src = $this->fileUtil->read($templateFileName);
		}
		return StringUtil::encoding($src);
	}
	
	function _setSpecialVariables($variables){
		$variables["variables"]	= $variables;
		$variables["message"]		= new Message();
		$variables["rhaco"]		= new Rhaco();
		$variables["exceptions"]	= ExceptionTrigger::get();
		
		return $variables;
	}
}
?>