<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/SimpleTag.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/TemplateFormatter.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/TemplateParser.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/Variable.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."io/FileUtil.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 1.0.7
 */
class HtmlParser extends TemplateParser{
	var $encodeType	= "UTF-8";
	var $baseFile	= "";

	function parse($templateFileName="",$remotePath=""){
		$this->baseFile = $templateFileName;

		$src = $this->_getTemplateSource($templateFileName);
		$src = $this->_normalizationParameter($src);
		$src = $this->_normalizationTag($src);

		$src = $this->_toTag($src);
		$src = $this->_system($src);
		$src = $this->_exec($src);
		$src = $this->_parsePrintVariable($src);
		$src = $this->_parseMessage($src);
		$src = Url::parse($src,$remotePath);

		return $this->_escapeSource($src);
	}
	function setEncodeType($value){
		return $this->encodeType = $value;
	}
	function _normalizationTag($src){
		$startTagList	= array();
		$endTagList		= array();

		if(preg_match_all("/((<([\\w\\d:_-]+)([\s\t]*[^\>]*)?>))/",$src,$startTagList)){
			$value		= "";
			$key			= "";
			$keyCounts	= array();
			$tagList	= array();

			foreach($startTagList[1] as $key => $value){
				$tagList[$startTagList[3][$key]][$keyCounts[$startTagList[3][$key]]++] = $value;
			}
			foreach($tagList as $name => $value){
				$tagName = strtolower($name);

				if(!($tagName == "option" || $tagName == "li")){
					$null = array();
					
					if(!preg_match_all("/(\/".$name."[\s\t]*?>)/i",$src,$null)){
						foreach($tagList[$name] as $tag){
							if(!preg_match("/\/>$/",$tag,$null)){
								$src = str_replace($tag,substr($tag,0,-1)." />",$src);
							}
						}
					}
				}
			}
		}
		return $src;
	}
	function _normalizationParameter($src){
		$rep	= "";
		$tag	= "";						
		
		if(preg_match_all("/(<[\s]*[a-z]+[\s]+[^>]+?>)/i",$src,$rep)){
			foreach($rep[1] as $tag){
				$replaceTag = $tag;
				$parse		= "";

				if(preg_match_all("/(([\w]+)[\s]*=[\s]*([^\s\"\']+))[\s\>]/i",$tag,$parse)){
					$key		= "";
					$value		= "";
					foreach($parse[1] as $key => $value){
						$replaceTag = str_replace($value,sprintf("%s=\"%s\"",$parse[2][$key],$parse[3][$key]),$replaceTag);
					}
				}
				$src = str_replace($tag,$replaceTag,$src);
			}
		}
		return $src;
	}
	function _doRead1100_Meta($src){
		if($this->encodeType != ""){
			$tag = new SimpleTag();

			if($tag->set($src,"head")){
				foreach($tag->getIn("meta") as $obj){
					$equiv = $obj->getParameter("http-equiv");

					if(!empty($equiv)){
						if(preg_match("/Content-Type/i",$equiv)){
							$obj->setParameter("content",sprintf("text/html; charset=%s",$this->encodeType));
							$src = str_replace($obj->getPlain(),$obj->get(),$src);
						}
					}
				}
				unset($obj,$equiv);
			}
		}
		return $src;
	}
	function _system1100_Iframe($src){
		$tag = new SimpleTag();

		if($tag->set($src,"body")){
			while(true){
				$list = $tag->getIn("iframe");
				
				if(sizeof($list) <= 0){
					break;
				}
				foreach($list as $obj){
					if(Variable::getBoolean($obj->getParameter("reference",false))){
						$url = Url::parseAbsolute($this->baseFile,$obj->getParameter("src"));
						$src = str_replace($obj->getPlain(),$this->parse($url,""),$src);
					}
				}
				$tag->set($src,"body");
			}
		}
		return $src;
	}
	function _exec1101_Input($src){
		$tag = new SimpleTag();

		if($tag->set($src,"body")){
			foreach($tag->getIn("input") as $obj){
				if(Variable::getBoolean($obj->getParameter("reference",false))){
					$obj->removeParameter("reference");
					$originalName	= $obj->getParameter("name");
					$name			= $this->_parsePlainVariable($this->_toVariable($originalName));
					$type			= strtolower($obj->getParameter("type"));

					if(!empty($name)){
						$value = $this->_parsePlainVariable($obj->getParameter("value"));
						
						if($type == "radio" || $type == "checkbox"){
							$selected = sprintf("if(Variable::isArrayValue(%s,%s) || strval(%s) == '%s'){print('checked');}",$name,$value,$name,$value);

							$obj->removeAttribute("checked");
							$obj->setAttribute(sprintf("%s%s%s",$this->_getPhpTagStart(),$selected,$this->_getPhpTagEnd()));							
						}else{
							$obj->setParameter("value",$this->_toVariable($originalName));
						}
						$obj->setParameter("name",$this->_toFormElementName($originalName));
						$src = str_replace($obj->getPlain(),$obj->get(),$src);	
					}
				}
			}
		}
		return $src;
	}	
	function _exec1102_Textarea($src){
		$tag = new SimpleTag();

		if($tag->set($src,"body")){
			foreach($tag->getIn("textarea") as $obj){
				if(Variable::getBoolean($obj->getParameter("reference",false))){				
					$obj->removeParameter("reference");
					$originalName	= $obj->getParameter("name");
					$name			= $this->_parsePlainVariable($this->_toVariable($originalName));
					
					if(!empty($name)){
						$obj->setParameter("name",$this->_toFormElementName($originalName));
						$obj->setValue(sprintf("%sprint(%s);%s",$this->_getPhpTagStart(),$name,$this->_getPhpTagEnd()));
						$src = str_replace($obj->getPlain(),$obj->get(),$src);
					}
				}
			}
		}
		return $src;
	}
	function _exec1103_Select($src){
		$tag = new SimpleTag();

		if($tag->set($src,"body")){
			foreach($tag->getIn("select") as $obj){
				if(Variable::getBoolean($obj->getParameter("reference",false))){				
					$obj->removeParameter("reference");		
					$originalName	= $obj->getParameter("name");
					$name			= $this->_parsePlainVariable($this->_toVariable($originalName));

					if(!empty($name)){
						$obj->setParameter("name",$this->_toFormElementName($originalName));
						$select = $obj->get();

						foreach($obj->getIn("option") as $option){
							$value = $this->_parsePlainVariable($option->getParameter("value"));

							if(substr($value,0,1) != "\$"){
								$boolvalue = strtolower($value);
								
								if($boolvalue == "true" || $boolvalue == "false"){
									$value = sprintf("%s",$value);
								}else{
									$value = sprintf("'%s'",$value);
								}
							}
							$selected = sprintf("if(Variable::isArrayValue(%s,%s) || strval(%s) == strval(%s)){print('selected');}",$name,$value,$name,$value);
							$option->removeAttribute("selected");
							$option->setAttribute(sprintf("%s%s%s",$this->_getPhpTagStart(),$selected,$this->_getPhpTagEnd()));

							$select = str_replace($option->getPlain(),$option->get(),$select);							
						}		
						$src = str_replace($obj->getPlain(),$select,$src);					
					}
				}
			}
		}
		return $src;
	}
	function _toFormElementName($name){
		if(preg_match("/(.+)\.(.+)?$/",$name,$variableName)){
			return sprintf("%s[%s]",$variableName[1],$variableName[2]);
		}
		return $name;
	}
	function _setSpecialVariables($variables){
		$variables = parent::_setSpecialVariables($variables);
		$variables["formatter"]	= new TemplateFormatter();

		return $variables;
	}
}
?>