<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."io/FileUtil.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.1.2
 */
class ProjectModel{
	var $rhacopath					= "";
	var $url							= "";

	var $defineLogHtml				= "";
	var $defineLogSysLevel			= "";
	var $defineLogDispLevel			= "";	
	var $defineLogFileLevel			= "";
	var $defineLogFilePath			= "";
	var $defineTemplateCashPath		= "";
	var $defineTemplateCash			= "";
	var $defineTemplateCashRefresh	= "";
	var $isScaffold					= "";
	var $rhacovar					= 0;
	
	var $sessionExpire				= 0;
	var $sessionCache				= "nocache";
	var $cookieExpire				= 0;
		
	var $inputList = array();	
	var $selectList = array();	
	var $defineList = array();
	var $directoryList = array();
	var $databaseList = array();
	var $applicationList = array();
	
	function ProjectModel(){
		$this->url = "http://localhost";

		if(defined("CONTEXT_URL")){
			$this->url = constant("CONTEXT_URL");
		}else{
			if(!empty($_SERVER["SCRIPT_URI"])){
				$this->url = $_SERVER["SCRIPT_URI"];
			}else if(!empty($_SERVER["SERVER_NAME"])){
				$this->url = sprintf("http://%s%s",$_SERVER["SERVER_NAME"],$_SERVER["REQUEST_URI"]);
			}
			if(preg_match("/^(.+)\/.+$/",$this->url,$url)){
				$this->url = $url[1];
			}
		}
		$this->defineTemplateCashPath		= Rhaco::define("TEMPLATE_CASH_PATH",FileUtil::getFilePath(Rhaco::path(),"work"));
		$this->defineTemplateCash			= Rhaco::define("TEMPLATE_CASH",false);
		$this->defineTemplateCashRefresh	= Rhaco::define("TEMPLATE_CASH_REFRESH",true);

		$this->defineLogHtml				= Rhaco::define("LOG_DISP_HTML",true);
		$this->defineLogSysLevel			= Rhaco::define("LOG_SYS_LEVEL","none");
		$this->defineLogDispLevel			= Rhaco::define("LOG_DISP_LEVEL","none");
		$this->defineLogFileLevel			= Rhaco::define("LOG_FILE_LEVEL","none");
		$this->defineLogFilePath			= Rhaco::define("LOG_FILE_PATH",FileUtil::getFilePath(Rhaco::path(),"work/log"));
		
		$this->isScaffold				= "false";
	}
	function setUrl($value){
		$this->url	= $value;
	}
	function setRhacopath($value){
		$this->rhacopath	= str_replace("\\","/",$value);
	}
	
	function setDefineLogHtml($value){
		$this->defineLogHtml	= $value;
	}
	function setDefineLogSysLevel($value){
		$this->defineLogSysLevel	= $value;
	}
	function setDefineLogDispLevel($value){
		$this->defineLogDispLevel	= $value;
	}
	function setDefineLogFileLevel($value){
		$this->defineLogFileLevel	= $value;
	}
	function setDefineLogFilePath($value){
		$this->defineLogFilePath	= $value;
	}
	function setDefineTemplateCash($value){
		$this->defineTemplateCash	= $value;
	}
	function setDefineTemplateCashRefresh($value){
		$this->defineTemplateCashRefresh	= $value;
	}	
	function setDefineTemplateCashPath($value){
		$this->defineTemplateCashPath	= $value;
	}
	function setIsScaffold($value){
		$this->isScaffold	= $value;
	}
}
?>