<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/DbUtilBase.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.2.8
 */
class DbUtilPostgreSQL extends DbUtilBase{
	function open($dbConnection,$new=true){
		if(extension_loaded("pgsql")){
			$con = sprintf("dbname=%s",$dbConnection->name);
	
			if($dbConnection->host != ""){		$con .= sprintf(" host=%s",$dbConnection->host);			}
			if($dbConnection->port != ""){		$con .= sprintf(" port=%s",$dbConnection->port);			}
			if($dbConnection->user != ""){		$con .= sprintf(" user=%s",$dbConnection->user);			}
			if($dbConnection->password != ""){	$con .= sprintf(" password=%s",$dbConnection->password);	}

			if($new){
				$this->connection = @pg_connect($con,PGSQL_CONNECT_FORCE_NEW);
			}else{
				$this->connection = @pg_connect($con);				
			}
			if($this->connection != false){
				if($dbConnection->encode != ""){
					if(!@pg_set_client_encoding($this->connection,$this->encode)){
						$this->connection = false;
						return false;
					}
				}
				$this->dbConnection = $dbConnection;
				$this->_begin();
				return true;
			}
		}
		return false;
	}
	function close(){
		$this->_commit();
		if($this->connection){
			pg_close($this->connection);
		}
		$this->connection = false;
	}
	function query($sql){
		if($this->connection){
			Logger::debug(Message::_("[{1}] {2}",$this->connection,$sql));
	
			$this->resourceId	= @pg_query($this->connection,$sql);
			$error				= @pg_last_error($this->connection);
	
			if(!empty($error)){
				Logger::error($error);
				return false;	
			}
			return true;
		}
		return false;
	}
	function resultset(){
		if($this->resourceId != false){
			return pg_fetch_array($this->resourceId);
		}
		return array();
	}
	function free(){
		if($this->resourceId != false){
			pg_free_result($this->resourceId);
		}
	}
	function _getLimitString($criteria){
		if($criteria->isLimit()){
			return sprintf(" OFFSET %d LIMIT %d ",$criteria->offset,$criteria->limit);
		}
		return;
	}
	function _getSelectString($columnList){
		$columnString = "";
		
		foreach($columnList as $column){
			$columnAlias	= sprintf("%s",$column->column);
			$columnName	= sprintf("%s.%s",$column->table->alias,$column->column);
						
			if($column->type == "TIMESTAMP"){
				$columnName = sprintf("to_char(%s.%s,'YYYY/MM/DD HH24:MI:SS')",$column->table->alias,$column->column);
			}else if($column->type == "DATE"){
				$columnName = sprintf("to_char(%s.%s,'YYYY/MM/DD')",$column->table->alias,$column->column);
			}
			$columnString .= sprintf("%s as %s__%s,",$columnName,$column->table->alias,$columnAlias);
		}
		return substr($columnString,0,-1);
	}
	function _getValueStringFormatDate($value){
		return sprintf("to_timestamp('%s','YYYY/MM/DD HH24:MI:SS')",DateUtil::format($value));
	}
	
	function _insertId($tableObject){
		foreach($tableObject->__primaryKey() as $pkeyColumn){
			if($this->query(sprintf("select last_value from %s_%s_seq",$pkeyColumn->table->name,$pkeyColumn->column))){
				$resultset = $this->resultset();	
				$this->free();
				return $resultset["last_value"];
			}
		}
		return 0;
	}
	function _escape($value){
		if(extension_loaded("pgsql")){
			return pg_escape_string($value);
		}
		return addslashes($value);
	}
}
?>