<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."io/data/File.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/Variable.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.2.0
 */
class Request{
	var $variables	= array();
	var $session		= array();	
	var $files		= array();
	var $urlmaps		= array();	
	var $post		= false;
	
	var $sessionExpire	= 2592000;	
	var $cacheLimiter	= "nocache";	/** @note (none/nocache/private/private_no_expire/public) */

	function Request($variables=array()){
		session_cache_limiter(Rhaco::define("SESSION_CACHE_LIMITER",$this->cacheLimiter));
		session_cache_expire(Rhaco::define("SESSION_EXPIRE_TIME",$this->sessionExpire));
		session_start();
		
		$this->reset();
		
		if(is_array($_FILES)){
			foreach($_FILES as $key => $files){
				$this->files[$key] = $this->_parseFileElement($files);
			}
		}
		if(is_array($_SESSION)){
			foreach($_SESSION as $key => $session){
				$this->session[$key] = Variable::getMagicQuotesOffValue($session);
			}
		}
		if(is_array($_COOKIE)){
			foreach($_COOKIE as $key => $cookie){
				$this->session[$key] = Variable::getMagicQuotesOffValue($cookie);
			}
		}
		if(is_array($_POST) && sizeof($_POST) > 0){
			$this->post = true;
			
			foreach($_POST as $key => $post){
				$this->variables[$key] = Variable::getMagicQuotesOffValue($post);
			}
		}
		if(is_array($_GET)){
			foreach($_GET as $key => $get){
				$this->variables[$key] = Variable::getMagicQuotesOffValue($get);
			}
		}
		if(is_array($variables)){
			foreach($variables as $key => $value){
				$this->variables[$key] = Variable::getMagicQuotesOffValue($value);
			}
		}
		$this->variables["args"] = preg_replace("/(.*?)\?.+/","\\1",substr($_SERVER["REQUEST_URI"],strlen($_SERVER["SCRIPT_NAME"])));
		$this->setUrlMapList();
		$this->validate();
	}
	function reset(){
	}
	function validate(){
	}
	function isPost(){
		return $this->post;
	}
	function getFiles(){
		return $this->files;
	}
	function getFile($name){
		if(!isset($this->files[$name])){
			$requestFiles			= array();
			$requestFiles['name']		= $name;
			$requestFiles['error']	= UPLOAD_ERR_NO_FILE;

			return $this->_parseFileElement($requestFiles);
		}
		return $this->files[$name];
	}
	function isFile($name){
		return Variable::isClassType(File,$this->files[$name]);
	}
	function setSession($name,$variable){
		$this->session[$name]	= $variable;
		$_SESSION[$name]		= $variable;
	}
	function getSession($name,$defaultData=""){
		if($this->session[$name] == null){
			return $defaultData;
		}
		return $this->session[$name];
	}
	function isSession($name){
		return array_key_exists($name,$this->session);
	}
	function clearSession($name){
		unset($this->session[$name]);
		unset($_SESSION[$name]);
	}
	function setVariable($name,$variable){
		$this->variables[$name] = $variable;
	}
	function getVariable($name,$defaultData=""){
		if($this->variables[$name] == null){
			return $defaultData;
		}
		return $this->variables[$name];
	}
	function isVariable($name){
		return array_key_exists($name,$this->variables);
	}
	function mergeVariables($hash){
		if(is_array($hash)){
			$this->variables = array_merge($this->variables,$hash);
		}
	}
	function clearVariable($name){
		if(is_array($name)){
			foreach($name as $n){
				unset($this->variables[$n]);
			}
		}else{
			unset($this->variables[$name]);
		}
	}	
	function getVariables(){
		return $this->variables;
	}
	function clearVariables(){
		$this->variables = array();
	}
	function toObject(&$object){
		return Variable::hashConvObject($this->getVariables(),$object);
	}
	function parseObject($object){
		foreach(Variable::objectConvHash($object) as $key => $value){
			$this->setVariable($key,$value);
		}
	}
	function setUrlMapList($hash=array()){
		if(!empty($this->variables["args"])){
			$list			= explode("/",substr($this->variables["args"],1));
			$hashList		= array();
			$this->urlmaps	= array();
			$hash			= Variable::toArray($hash);
	
			if(sizeof($hash) == 0){
				for($i=0;$i<sizeof($list);$i++){
					$hash[] = $i;
				}
			}
			foreach($hash as $arg){
				$hashList[] = $arg;
			}
			foreach($list as $key => $arg){
				if(isset($hashList[$key])){
					$key = $hashList[$key];
				}
				$this->urlmaps[$key] = $arg;
			}
		}
	}
	function getUrlMapList(){
		return Variable::toArray($this->urlmaps);
	}
	function getUrlMap($key){
		if(isset($this->urlmaps[$key])){
			return $this->urlmaps[$key];
		}
		return null;
	}
	function _parseFileElement($requestFiles){
		$fileElement			= new File($requestFiles['name']);
		$fileElement->tmp	= $requestFiles['tmp_name'];
		$fileElement->size	= $requestFiles['size'];
		$fileElement->error	= $requestFiles['error'];

		return $fileElement;
	}
}
?>