<?php
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 1.0.8
 */
class StringUtil{
	function getEncodeTypeUTF8(){
		return "UTF-8";
	}
	function getEncodeTypeSJIS(){
		return "SJIS";
	}
	function getEncodeTypeEUC(){
		return "EUC-JP";
	}
	function getEncodeTypeJIS(){
		return "JIS";
	}
	function encoding($value,$encodeType="",$lang="Japanese"){
		if(extension_loaded("mbstring")){
			if(!empty($value)){
				if(empty($encodeType)){
					$encodeType = StringUtil::getEncodeTypeUTF8();
				}
				if(empty($lang) || "neutral" == mb_language()){
					$lang = "Japanese";
				}
				@mb_language("Japanese");
				return @mb_convert_encoding($value,$encodeType,StringUtil::encodeString());
			}
		}
		return $value;
	}
	function detectEncoding($value){
		if(extension_loaded("mbstring")){
			return mb_detect_encoding($value,StringUtil::encodeString());
		}
		return StringUtil::getEncodeTypeUTF8();
	}
	function convertKana($value){
		if(extension_loaded("mbstring")){
			return mb_convert_kana($value,"KV",StringUtil::detectEncoding($value));
		}
		return $value;
	}
	function convertZenhan($value){
		if(extension_loaded("mbstring")){
			$value = mb_convert_kana($value,"askV",StringUtil::detectEncoding($value));
		}
		return $value;
	}
	function convertHanzen($value){
		if(extension_loaded("mbstring")){
			$value = mb_convert_kana($value,"ASKV",StringUtil::detectEncoding($value));
		}
		return $value;		
	}
	function replace($src,$preg,$replace="",$option=""){
		if(!empty($preg)){
			if(substr($preg,0,1) == "/"){
				if(extension_loaded("mbstring")){
					if(strpos($option,"i") === false){
						return mb_ereg_replace(substr($preg,1,-1),$replace,$src);						
					}
					return mb_eregi_replace(substr($preg,1,-1),$replace,$src);
				}
				return preg_replace(sprintf("%s%s",$preg,$option),$replace="",$src);
			}
			return str_replace($preg,$replace,$src);
		}
		return $src;
	}

	function strlen($value){
		if(extension_loaded("mbstring")){
			return mb_strlen($value,StringUtil::detectEncoding($value));
		}
		return strlen($value);
	}

	function substring($value,$start,$length=""){
		if(extension_loaded("mbstring")){
			if($length == ""){
				$length = StringUtil::strlen($value);
			}
			return mb_substr($value,$start,$length,StringUtil::detectEncoding($value));
		}
		return substr($str,$start,$length);
	}

	function getIncludeSeparate(){
		if(!empty($_SERVER["WINDIR"]) || !empty($_SERVER["PROGRAMFILES"])){		
			return ";";
		}
		return ":";	
	}
	function sprintf(){
		$argList		= func_get_args();
		$argsize		= sizeof($argList);

		if($argsize > 0){
			$paramList		= array();
			$paramsize		= substr_count($argList[0],"%");
			$propertiesize	= $argsize - 1;

			for($i=1;$i<$argsize;$i++){
				$paramList[] = $argList[$i];
			}			
			if($paramsize > $propertiesize){
				for($i=0;$i<$paramsize-$propertiesize;$i++){
					$paramList[] = "";
				}
			}
			return vsprintf($argList[0],$paramList);
		}
		return "";
	}
	function encodeString(){
		return 	"UTF-8".
				",eucJP-win,EUC-JP,SJIS-win,SJIS";
	}
}	
?>