<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/DbUtilMySQL.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/data/Column.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/Variable.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.1.3
 */
class ExtDbUtilMySQL extends DbUtilMySQL{	
	function forward($tagDataProjectDatabase){
		$sql			= "";
		$defaultSql	= "";
		
		if(Variable::isClassType(DatabaseModel,$tagDataProjectDatabase)){
			foreach($tagDataProjectDatabase->tableList as $table){
				if(Variable::isClassType(TableModel,$table)){
					$sql			.= sprintf("CREATE TABLE IF NOT EXISTS %s (\n",$table->getTableName());
					$columnSql	= "";
					$primarySql	= "";
					
					foreach($table->columnList as $column){
						if(Variable::isClassType(ColumnModel,$column)){
							if(!empty($columnSql)){
								$columnSql .= "\t,";
							}
							$columnSql .= sprintf("`%s`",$column->name);
							
							if(preg_match("/(serial)/i",$column->type)){
								$columnSql .= sprintf(" INTEGER AUTO_INCREMENT ");
							}else if(preg_match("/(float)/i",$column->type)){
								$columnSql .= sprintf(" FLOAT");								
							}else if(preg_match("/(int)|(time)/i",$column->type)){
								$columnSql .= sprintf(" INTEGER");

								if($column->size > 0){
									$columnSql .= sprintf("(%d)",$column->size);
								}
							}else if(preg_match("/(timestamp)|(date)/i",$column->type)){
								$columnSql .= sprintf(" TIMESTAMP(14)");
							}else if(preg_match("/(string)|(text)|(email)|(tel)|(zip)/i",$column->type)){
								if($column->size > 0 && $column->size < 255){
									$columnSql .= sprintf(" VARCHAR");
									$columnSql .= sprintf("(%d)",$column->size);
								}else{
									$columnSql .= sprintf(" LONGBLOB");
								}
							}else if(preg_match("/(bool)/i",$column->type)){
								$columnSql .= sprintf(" TINYINT(1)");
							}
							if($column->require){
								$columnSql .= sprintf(" NOT NULL");
							}
							if($column->default != ""){
								$default = "";

								if(preg_match("/(string)|(text)|(email)|(time)|(tel)|(zip)/i",$column->type) && $column->size < 255){
									$default = sprintf("'%s'",$column->default);
								}else if(preg_match("/(timestamp)|(date)/i",$column->type)){
									if(!preg_match("/sysdate/i",$column->default)){
										$default = sprintf("'%s'",$column->default);
									}
								}else if(preg_match("/(bool)/i",$column->type)){
									$default = sprintf("%d",intval(Variable::getBoolean($column->default)));									
								}else{
									$default = sprintf("%s",$column->default);
								}
								if($default != ""){
									$columnSql .= sprintf(" DEFAULT %s",$default);
								}
							}
							$columnSql .= "\n";
						}
					}
					foreach($table->primaryList as $column){
						if(!empty($primarySql)){
							$primarySql .= ",";
						}
						$primarySql .= sprintf("`%s`",$column->name);
					}
					$sql	 .= sprintf("\t %s",$columnSql);
					if(!empty($primarySql)){
						$sql .= sprintf("\t,PRIMARY KEY(%s)\n",$primarySql);
					}
					$sql .= sprintf(") TYPE = innodb;\n\n");

					foreach($table->defaultList as $defaults){
						$columnString	= "";
						$valueString		= "";		
						
						foreach($table->columnList as $column){
							if($column->type != "SERIAL"){
								$value = $column->default;
	
								foreach($defaults as $default){
									if($default->column == $column->name){
										$value = $default->value;
										break;
									}
								}
								$value = $this->_getValueString($column,$value);

								$columnString	.= sprintf(",%s",$column->name);
								$valueString		.= sprintf(",%s",$value);
							}
						}
						$defaultSql .= sprintf("insert into %s(%s) values(%s);\n",$table->getTableName(),substr($columnString,1),substr($valueString,1));
					}
				}
			}
			$sql = sprintf("%s\n\n%s",$sql,$defaultSql);
		}
		return $sql;
	}
}
?>