<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."resources/Message.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.2.0
 */
class Pager{
	var $offset		= 0;
	var $limit		= 1;
	var $total		= 0;
	var $nextOffset	= 0;
	var $prevOffset	= 0;
	var $pageStart	= 0;	
	var $pageLast	= 0;
	
	function Pager(){
	}

	function setOffset($value){
		$this->offset = intval($value);
	}
	function setLimit($value){
		if(empty($value)){
			$value = 1;
		}		
		$this->limit = intval($value);
	}
	function setTotal($total){
		$this->total = intval($total);

		if($this->total <= 0){
			$this->offset			= 0;
			$this->nextOffset		= 0;
			$this->prevOffset		= 0;
			$this->pageStart			= 0;
			$this->pageLast			= 0;
		}else{
			$this->nextOffset	= $this->offset + $this->limit;
			$this->prevOffset	= $this->offset - $this->limit;
			$this->pageStart		= $this->offset + 1;
			
			if(($this->offset + $this->limit) > $this->total){
				$this->pageLast	= $this->total;
			}else{
				$this->pageLast	= $this->nextOffset;
			}
		}
	}

	function isNext(){
		if($this->nextOffset <= $this->total){
			return true;
		}
		return false;
	}

	function isPrev(){
		if($this->prevOffset >= 0){
			return true;
		}
		return false;
	}
	function output(){
		return Message::_("Results {1} - {2} of about {3}",$this->pageStart,$this->pageLast,$this->total);
	}
}