<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/Tag.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/data/AtomContent.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/data/AtomSummary.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2006- The Rhacophorus Project. All rights reserved.
 * @version 0.1.4
 */
class AtomEntry{
	var $link = array();
	var $title = "";
	var $summary = "";
	var $content = "";

	function AtomEntry($title="",$summary="",$content=""){
		$this->setTitle($title);
		$this->setSummary(new AtomSummary($summary));
		$this->setContent(new AtomContent($content));
	}
	
	function set($src){
		$tag = new Tag();
		$tag->set($src,"entry");
		$this->_set($tag);
	}
	function _set($tag){
		foreach($tag->getIn("title") as $intag){
			$this->setTitle($intag->getValue());
		}
		foreach($tag->getIn("summary") as $intag){
			$data = new AtomSummary();
			$data->set($intag->get());
			$this->setSummary($data);
		}
		foreach($tag->getIn("content") as $intag){
			$data = new AtomContent();
			$data->set($intag->get());
			$this->setContent($data);
		}
		foreach($tag->getIn("link") as $intag){
			$data = new AtomLink();
			$data->set($intag->get());
			$this->link[] = $data;
		}
	}
	function get(){
		$outTag	= new Tag("entry");
		$outTag 	= $this->_get($outTag);
		return $outTag->get();
	}
	function _get($outTag){	
		$tag		= new Tag("title",$this->getTitle());
		$outTag->addValue($tag->get());

		if(Variable::isClassType(AtomSummary,$this->getSummary())){
			$data = $this->getSummary();
			$outTag->addValue($data->get());
		}		
		if(Variable::isClassType(AtomContent,$this->getContent())){
			$data = $this->getContent();
			$outTag->addValue($data->get());
		}		
		foreach($this->link as $data){
			if(Variable::isClassType(AtomLink,$data)){
				$outTag->addValue($data->get());
			}
		}
		return $outTag;
	}
	
	function setTitle($value){
		$this->title = $value;
	}
	function getTitle(){
		return $this->title;
	}
	function setSummary($value){
		$this->summary = $value;
	}
	function getSummary(){
		return $this->summary;
	}
	function setContent($value){
		$this->content = $value;
	}
	function getContent(){
		return $this->content;
	}
	function addLink($href,$rel="",$type=""){
		$this->link[] = new AtomLink($href,$rel,$type);
	}
	function getLink(){
		return $this->link;
	}
}