<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/data/TableObjectBase.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/data/Column.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.2.3
 */
class TagFormatter{
	function text2Html($value){
		return TagFormatter::nl2br(TagFormatter::escape($value));
	}
	function escape($value){
		return str_replace(array("<",">","'","\""),array("&lt;","&gt;","&#039;","&quot;"),$value);		
	}
	function nl2br($value){
		return nl2br($value);
	}
	function urlencode($value){
		return rawurlencode($value);
	}
	function getJsDocument($src){
		$src = preg_replace("/([\"\'])/","\\\\\\1",$src);
		$src = str_replace("\n","\\\\n",$src);
		$src = str_replace("\r","\\\\r",$src);

		return $src;
	}	
	function httpBuildQuery(){
		$argList = func_get_args();		
		
		if(is_array($argList[0])){
			$list = $argList[0];
			
			if(sizeof($argList) > 1){
				$list = array();
				
				for($i=1;$i<sizeof($argList);$i++){
					$list[$argList[$i]] = $argList[0][$argList[$i]];
				}
			}
			foreach($list as $key => $request){
				if(!is_object($request) && !is_array($request)){
					$requestString .= sprintf("&%s=%s",$key,urlencode($request));
				}
			}
			$requestString = substr($requestString,1);
		}
		return $requestString;
	}
}
?>