<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."util/System.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/StringUtil.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 1.0.5
 */
class Variable{	
	function getBoolean($value){
		if(is_string($value) && preg_match("/^true$/i",$value)){
			return true;
		}else if(intval(intval($value) > 0)){
			return true;
		}
		return false;
	}
	function getInt($value){
		return intval(StringUtil::convertZenhan($value));
	}
	function copy($variable){
		if(substr(phpversion(),0,1) >= 5){
			if(is_object($variable)){
				eval("\$object = clone \$variable;");				
				return $object;
			}
		}
		return $variable;
	}
	function getMagicQuotesOffValue($value){
		if(is_string($value) && get_magic_quotes_gpc()){
			return stripslashes($value);
		}
		return $value;
	}
	function getMagicQuotesOnValue($value){
		if(!get_magic_quotes_gpc()){
			return addslashes($value);
		}
		return $value;
	}
	function isClassType($className,$object){
		if(!is_object($object)){
			return false;
		}		
		if(is_object($className)){
			$className = get_class($className);
		}
		return (preg_match("/^".$className."$/i",get_class($object)) || 
					is_subclass_of($object,$className)
				);
	}

	function hashConvObject($hash,&$object){
		if(is_object($object) && is_array($hash)){
			$methodList = array();

			foreach(get_class_methods($object) as $methodName){
				if(preg_match("/^set(.+)$/i",$methodName,$setter)){
					$methodList[strtolower($setter[1])] = $methodName;
				}
			}
			foreach($hash as $key => $request){
				if(!empty($methodList[strtolower($key)])){
					call_user_func_array(array(&$object,$methodList[strtolower($key)]),array($request));
				}
			}
			return $object;
		}
		return false;
	}
	function objectConvHash($object,$hash=array()){
		if(!is_array($hash)){
			$hash = array();
		}
		if(is_object($object)){
			$methodList	= array();
			$vars		= get_object_vars($object);

			foreach(get_class_methods($object) as $methodName){
				if(preg_match("/^get(.+)$/i",$methodName,$setter)){
					$methodList[strtolower($setter[1])] = $methodName;
				}
			}
			foreach($vars as $key => $value){
				if(isset($methodList[strtolower($key)])){
					$value = call_user_func_array(array(&$object,$methodList[strtolower($key)]),array());
				}
				$hash[$key] = $value;
			}
		}
		return $hash;
	}
	function copyProperties($fromobject,&$toobject){
		if(is_object($fromobject) && is_object($toobject)){
			$methodList	= array();
			$setterLisr	= array();

			foreach(get_class_methods($fromobject) as $methodName){
				if(preg_match("/^get(.+)$/i",$methodName,$getter) ||
					preg_match("/^is(.+)$/i",$methodName,$getter)
				){
					$methodList[strtolower($getter[1])] = $methodName;
				}
			}
			foreach(get_class_methods($toobject) as $methodName){
				if(preg_match("/^set(.+)$/i",$methodName,$setter)){
					if(isset($methodList[strtolower($setter[1])])){
						call_user_func_array(
							array(&$toobject,$methodName),
							array(
								call_user_func_array(array(&$fromobject,$methodList[strtolower($setter[1])]),array())
							)
						);
					}
				}
			}
			return $toobject;
		}
		return false;
	}
	function toArray($array){
		if(!empty($array)){
			if(is_array($array)){
				return $array;
			}
			return array($array);
		}
		return array();
	}
	function isArrayValue($array,$searchvalue){
		if(is_array($array)){
			foreach($array as $value){
				if(strval($searchvalue) == strval($value)){
					return true;
				}
			}
		}
		return false;
	}
	function toJson($variable){
		switch(gettype($variable)){
			case "boolean":
				if($variable){
					return "true";
				}
				return "false";
			case "integer":
				return sprintf("%d",$variable);
			case "double":
				return sprintf("%f",$variable);			
			case "array":
				$list = array();
				foreach($variable as $key => $value){
					$list[] = Variable::toJson($value);
				}
				return sprintf("[%s]",implode(",",$list));
			case "object":
				$list = array();
				foreach(Variable::objectConvHash($variable) as $key => $value){
					$list[] = sprintf("%s:%s",$key,Variable::toJson($value));
				}
				return sprintf("{%s}",implode(",",$list));
			case "string":
				return sprintf("\"%s\"",addslashes(StringUtil::encoding($variable,StringUtil::getEncodeTypeUTF8())));
			default:
		}
		return "null";		
	}
}
?>