<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/ExceptionTrigger.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/data/NotSupportedException.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/DbUtil.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.1.2
 */
class ExtDbUtil extends DbUtil{
	function ExtDbUtil($dbConnection,$new=true){
		$this->_setDatabase($dbConnection->type);

		if($this->database == "MYSQL"){
			if(require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/ExtDbUtilMySQL.php")){
				$this->dbUtil = new ExtDbUtilMySQL();
			}
		}else if($this->database == "POSTGRESQL"){
			if(require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/ExtDbUtilPostgreSQL.php")){
				$this->dbUtil = new ExtDbUtilPostgreSQL();
			}
		}
		if($this->dbUtil == null){
			ExceptionTrigger::raise(new NotSupportedException(Message::_("database controler [{1}]",$dbConnection->type)));
		}else{
			$this->_open($dbConnection,$new);
		}
	}
	function forward($databaseObject){
		if($this->dbUtil != null){
			return $this->dbUtil->forward($databaseObject);
		}
		return "";
	}
}
?>