#==============================================================================
#  Game_Item
#------------------------------------------------------------------------------
# ACeNX
# Copyright (C) 2005 fukuyama
#==============================================================================

class Game_Item < Game_Item_Base
  include Game_Item_Animation_Module

  def initialize(id = nil)
    @scope = 0
    @occasion = 0
    @menu_se = RPG::AudioFile.new("", 80)
    @common_event_id = 0
    @consumable = true
    @parameter_type = 0
    @parameter_points = 0
    @recover_hp_rate = 0
    @recover_hp = 0
    @recover_sp_rate = 0
    @recover_sp = 0
    @hit = 100
    @pdef_f = 0
    @mdef_f = 0
    @variance = 0
    @element_set = []
    @plus_state_set = []
    @minus_state_set = []
    super()
    setup($data_items[id]) if not id.nil?
  end

  def setup(item)
    super(item)
    @scope            = item.scope
    @occasion         = item.occasion
    @menu_se          = item.menu_se
    @common_event_id  = item.common_event_id
    @price            = item.price
    @consumable       = item.consumable
    @parameter_type   = item.parameter_type
    @parameter_points = item.parameter_points
    @recover_hp_rate  = item.recover_hp_rate
    @recover_hp       = item.recover_hp
    @recover_sp_rate  = item.recover_sp_rate
    @recover_sp       = item.recover_sp
    @hit              = item.hit
    @pdef_f           = item.pdef_f
    @mdef_f           = item.mdef_f
    @variance         = item.variance
    @element_set      = item.element_set
    @plus_state_set   = item.plus_state_set
    @minus_state_set  = item.minus_state_set
  end

  attr_accessor :scope
  attr_accessor :occasion
  attr_accessor :menu_se
  attr_accessor :common_event_id
  attr_accessor :price
  attr_accessor :consumable
  attr_accessor :parameter_type
  attr_accessor :parameter_points
  attr_accessor :recover_hp_rate
  attr_accessor :recover_hp
  attr_accessor :recover_sp_rate
  attr_accessor :recover_sp
  attr_accessor :hit
  attr_accessor :pdef_f
  attr_accessor :mdef_f
  attr_accessor :variance
  attr_accessor :element_set
  attr_accessor :plus_state_set
  attr_accessor :minus_state_set

  # ΏۂŜǂ
  def scope_all?
    return (self.scope == 4 or self.scope == 6 or self.scope == 2)
  end
  # ΏۂP̂ǂ
  def scope_unit?
    return (not scope_all?)
  end
end
