#==============================================================================
#  Window_Item
#------------------------------------------------------------------------------
# ACeEBhE
# Copyright (C) 2005 fukuyama
#==============================================================================

module DQ

class Window_Item < Window_Item_Base
  #--------------------------------------------------------------------------
  # 
  #--------------------------------------------------------------------------
  def initialize(parent,help=true)
    @row_max = 12
    super(parent)
    # ʒu̐ݒ
    self.top  = top_window.top
    self.left = parent.right

    if help
      # ACewvEBhE쐬
      x = self.x + self.width
      y = 64
      w = 640 - x - 16
      h = 240
      @window_help = Window_Markup_Text.new(x,y,w,h)
      @window_help.back_opacity = WINDOW_BACK_OPACITY

      # qEBhEɒǉ
      add_child @window_help
      @window_help.visible = false
    end
  end
  def delete_window_help
    if not @window_help.nil?
      if not @window_help.disposed?
        delete_child @window_help
        @window_help.dispose
      end
      @window_help = nil
    end
  end
  #--------------------------------------------------------------------------
  # ĕ`
  #--------------------------------------------------------------------------
  def refresh
    self.clear
    refresh_actor_items
    refresh_help
    super
  end
  #--------------------------------------------------------------------------
  # XV
  #--------------------------------------------------------------------------
  def update
    super
    if (not @window_help.nil?) and (not @window_help.disposed?)
      @window_help.visible = (self.active or child_window_active?)
    end
    if (not Input.press?(Input::UP)) and (not Input.press?(Input::DOWN))
      if @index != @refresh_help_index and @index >= 0
        refresh_help
        @refresh_help_index = @index
      end
    end
  end
  #--------------------------------------------------------------------------
  # ACeEBhEĕ`
  #--------------------------------------------------------------------------
  def active_event
    if (not @window_help.nil?) and (not @window_help.disposed?)
      if self.active
        refresh_help
      end
    end
  end
  def make_item_status_description
    return '' if @actor.nil?
    return '' if not @actor.is_a?(Game_Actor)
    return '' if item.is_a?(Game_Item)
    text = '\bottom'
    case item
    when Game_Weapon
      a = 0
      b = item.atk
      if not @actor.weapon.nil?
        a = @actor.weapon.atk
      end
    when Game_Armor
      a = 0
      b = item.pdef
      if not @actor.equip_armors[item.kind].nil?
        a = @actor.equip_armors[item.kind].pdef
      end
    end
    text += "\\left[#{a}]#{a}"
    text += "\\center_left[]"
    text += "\\center_right[ #{b}] #{b}"
    return text
  end
  def refresh_help
    if (not @window_help.nil?) and (not @window_help.disposed?)
      if not self.item.nil?
        text = self.item.description
        text += make_item_status_description
        @window_help.set_text text
      else
        @window_help.set_text ""
      end
    end
  end
  #--------------------------------------------------------------------------
  # ACȇI
  #--------------------------------------------------------------------------
  def select_item
    window = Window_Item_Menu.new(self)
    add_child window
    set_active_window(window.class)
  end
  #--------------------------------------------------------------------------
  # LZ
  #--------------------------------------------------------------------------
  def input_b
    cancel_se
    self.index = -1
    set_active_window(Window_Actor_Menu_Item)
  end
end

end
