#==============================================================================
#  Window_Config
#------------------------------------------------------------------------------
# ĂEBhE
# Copyright (C) 2005 fukuyama
#==============================================================================

module DQ

class Window_Config < Window_Menu
  include Window_Tree_Module

  class Config
    attr_accessor :name
    attr_accessor :values
    attr_accessor :texts
    attr_accessor :get
    attr_accessor :set
  end

  #--------------------------------------------------------------------------
  #  IuWFNg
  #--------------------------------------------------------------------------
  def initialize(parent)
    @title = 'Ă'
    @index = 0

    @configs = []

    cf = Config.new
    cf.name = 'bZ[WXs[h            '
    cf.values = [-1, 0, 1]
    cf.texts  = ['x', '', '']
    cf.get = proc { return $game_system.user_default_map_message_speed }
    cf.set = proc { |val| $game_system.user_default_map_message_speed = val }
    @configs.push cf

    for cf in @configs
      add_menu(cf.name, :command_config)
    end

    add_menu('^Cg', :command_to_title)
    add_menu('Vbg_E', :command_shutdown)

    super(parent)

    # ʒu̐ݒ
    rect = parent.menu_rect(parent.index)
    self.top = parent.top + rect.y
    self.left = parent.left + rect.x
  end
  def command_config
  end
  #--------------------------------------------------------------------------
  #  R}h [^Cg] Ȉ
  #--------------------------------------------------------------------------
  def command_to_title
    # BGMABGSAME tF[hAEg
    Audio.bgm_fade(800)
    Audio.bgs_fade(800)
    Audio.me_fade(800)
    # ^Cgʂɐ؂ւ
    $scene = ::Scene_Title.new
  end
  #--------------------------------------------------------------------------
  #  R}h [Vbg_E] Ȉ
  #--------------------------------------------------------------------------
  def command_shutdown
    # BGMABGSAME tF[hAEg
    Audio.bgm_fade(800)
    Audio.bgs_fade(800)
    Audio.me_fade(800)
    # Vbg_E
    $scene = nil
  end

  def input_left
    if @configs.size <= index
      return
    end
    cf = @configs[index]
    current_index = cf.values.index(cf.get.call)
    current_index -= 1
    if current_index < 0
      buzzer_se
      return
    end
    cf.set.call(cf.values[current_index])
    decision_se
    refresh
  end
  def input_right
    if @configs.size <= index
      return
    end
    cf = @configs[index]
    current_index = cf.values.index(cf.get.call)
    current_index += 1
    if current_index >= cf.values.size
      buzzer_se
      return
    end
    cf.set.call(cf.values[current_index])
    decision_se
    refresh
  end

  #--------------------------------------------------------------------------
  # ڂ̕`
  #--------------------------------------------------------------------------
  def draw_menu_item(index,color,rect,name)
    super
    if @configs.size <= index
      return
    end
    cf = @configs[index]
    text = cf.texts[cf.values.index(cf.get.call)].to_s
    self.contents.font.size -= 2
    self.contents.draw_text(rect,text,2)
    self.contents.font.size += 2
  end
end

end
