#==============================================================================
#  Window_Target_Enemy
#------------------------------------------------------------------------------
# ^[QbgGl~[EBhE
# Copyright (C) 2005 fukuyama
#==============================================================================

module DQ
module Battle

class Window_Target_Enemy < Window_Menu
  include Window_Tree_Module

  def target_enemies
    enemies = []
    name = get_menu
    group_arrows = @enemies_arrow[name]
    if not group?
      # C̏ꍇ
      enemies.push group_arrows[@enemy_group_index].enemy
    else
      # O[v̏ꍇ
      for arrow in group_arrows
        enemies.push arrow.enemy
      end
    end
    return enemies
  end

  def group?
    return @group_target
  end

  #--------------------------------------------------------------------------
  # 
  #--------------------------------------------------------------------------
  def initialize(parent,group_target = false)
    # Gl~[
    @enemies_count = {}
    @enemies_arrow = {}
    @arrows = []
    @enemy_group_index = 0
    @group_target = group_target

    # Gl~[O擾
    names = []
    for enemy in $game_troop.enemies
      next if not enemy.exist?
      names.push enemy.name
      if @enemies_count[enemy.name].nil?
        @enemies_count[enemy.name] = 0
        @enemies_arrow[enemy.name] = []
      end
      @enemies_count[enemy.name] += 1
      arrow = Arrow_Enemy.new($scene.spriteset.viewport1,enemy)
      @enemies_arrow[enemy.name].push arrow
      @arrows.push arrow
    end

    # Gl~[j[Nɍi
    for name in names.uniq
      add_menu(name, :select_target_enemy)
    end

    @index = 0
    @column_max = 1

    super(parent)

    # EBhEʒu
    window_actor_command = get_window(Window_Actor_Command)
    self.left = window_actor_command.right
    self.top = window_actor_command.top

    refresh_arrows
  end
  #--------------------------------------------------------------------------
  # j
  #--------------------------------------------------------------------------
  def dispose
    dispose_arrows
    super
  end

  #--------------------------------------------------------------------------
  # Cxgnh
  #--------------------------------------------------------------------------
  def input_up
    super
    refresh_arrows
  end
  def input_down
    super
    refresh_arrows
  end
  def input_left
    cursor_se
    @enemy_group_index -= 1
    refresh_arrows
  end
  def input_right
    cursor_se
    @enemy_group_index += 1
    refresh_arrows
  end
  def input_b
    if Input.trigger?(Input::B)
      @index = -1
      cancel_se
      dispose
    end
  end
  def select_target_enemy
    window = get_window(Window_Actor_Command)
    window.targets = self.target_enemies
    top_window.dispose
  end

  #---------------------------------------------------------------------------
  # A[J[\ύX
  #---------------------------------------------------------------------------
  def refresh_arrows
    for arrow in @arrows
      arrow.visible = false
    end
    name = get_menu
    group_arrows = @enemies_arrow[name]
    if not group?
      # C̏ꍇ
      if @enemy_group_index < 0
        @enemy_group_index = group_arrows.size - 1
      end
      if group_arrows.size <= @enemy_group_index
        @enemy_group_index = 0
      end
      group_arrows[@enemy_group_index].visible = true
    else
      # O[v̏ꍇ
      for arrow in group_arrows
        arrow.visible = true
      end
    end
  end
  #---------------------------------------------------------------------------
  # A[J[\XV
  #---------------------------------------------------------------------------
  def update_arrows
    for arrow in @arrows
      arrow.update
    end
  end
  #---------------------------------------------------------------------------
  # A[J[\j
  #---------------------------------------------------------------------------
  def dispose_arrows
    for arrow in @arrows
      arrow.dispose
    end
  end

  #---------------------------------------------------------------------------
  # XV
  #---------------------------------------------------------------------------
  def update
    update_arrows
    super
  end

  #--------------------------------------------------------------------------
  # ڂ̕`
  #--------------------------------------------------------------------------
  def draw_menu_item(index,color,rect,name)
    self.contents.font.color = color
    self.contents.fill_rect(rect, Color.new(0, 0, 0, 0))
    self.contents.draw_text(rect, name,0)
    count = "#{@enemies_count[name]} C"
    self.contents.draw_text(rect, count,2)
  end

  #---------------------------------------------------------------------------
  # Rec̍쐬
#  def _contents_height
#    return _menu_height * 4
#  end
  #---------------------------------------------------------------------------
  # Rec̍쐬
  def _contents_width
    return _menu_width
  end
  #---------------------------------------------------------------------------
  # j[̍쐬
  def _menu_width
    return BATTLE_WINDOW_TARGET_ENEMY_WIDTH
  end
end

end
end
