#==============================================================================
#  Phase_Battle_End
#------------------------------------------------------------------------------
# 퓬ItF[Y
# Copyright (C) 2005 fukuyama
#==============================================================================

module DQ
module Battle

class Phase_Battle_End
  include Battle_Phase_Base_Module

  # 萔ݒ
  @@action_log_level_up_me = nil
  @@action_log_level_up_me = ACTION_LOG_LEVEL_UP_ME if Module.constants.include?('ACTION_LOG_LEVEL_UP_ME')

  def initialize
    # bZ[W\Ԋu퓬pǂ
    $scene.message_window.auto_message_interval = nil
    # Xe[^XEBhEɖ߂
    $scene.status_window.state_on
    # bZ[WEBhE悤ɂ
    $scene.message_window.fade_out_off = false
    # bZ[WEFCg
    $scene.message_window.sprite_message.no_wait = false
    if $scene.win?
      start_phase5
    elsif $scene.lose?
      # ogUgO
      action_log_battle_result_lose
    end
  end

  def update
    update_phase5
  end

  #--------------------------------------------------------------------------
  #  At^[ogtF[YJn
  #--------------------------------------------------------------------------
  def start_phase5
    # tF[Y 5 Ɉڍs
    @phase = 5
    # ogI ME t
    $game_system.me_play($game_system.battle_end_me)
    # ogJnO BGM ɖ߂
    $game_system.bgm_play($game_temp.map_bgm)
    # EXPAS[hAgW[
    exp = 0
    gold = 0
    treasures = []
    drop_enemies = []
    level_up_actors = []
    # [v
    for enemy in $game_troop.enemies
      # Gl~[BԂłȂꍇ
      unless enemy.hidden
        # l EXPAS[hǉ
        exp += enemy.exp
        gold += enemy.gold
        # gW[o
        if rand(100) < enemy.treasure_prob
          if enemy.item_id > 0
            treasures.push(Game_Item.new(enemy.item_id))
            drop_enemies.push enemy
          end
          if enemy.weapon_id > 0
            treasures.push(Game_Weapon.new(enemy.weapon_id))
            drop_enemies.push enemy
          end
          if enemy.armor_id > 0
            treasures.push(Game_Armor.new(enemy.armor_id))
            drop_enemies.push enemy
          end
        end
      end
    end
    # gW[̐ 6 ܂łɌ
    treasures = treasures[0..5]
    # EXP l
    for i in 0...$game_party.actors.size
      actor = $game_party.actors[i]
      if actor.cant_get_exp? == false
        last_level = actor.level
        actor.exp += exp
        if actor.level > last_level
          level_up_actors.push([actor,last_level])
#          @status_window.level_up(i)
        end
      end
    end
    # S[hl
    $game_party.gain_gold(gold)
    # gW[l
    for item in treasures
      Item_Facade.gain(item)
    end
    # ogUgO
    action_log_battle_result_win(exp, gold, treasures, drop_enemies, level_up_actors)
  end

  #--------------------------------------------------------------------------
  #  t[XV (At^[ogtF[Y)
  #--------------------------------------------------------------------------
  def update_phase5
    # CtF[YtONA
    $game_temp.battle_main_phase = false
    # Xe[^XEBhEtbV
    refresh_status_window
    # ogI
    battle_end(0)
  end

  def action_log_battle_result_win(exp, gold, treasures, drop_enemies, level_up_actors)
    # ANVʕ\Cxg
    action_event = Script_Event.new
    msg = '\clear'
    if $game_troop.enemies.size == 1
      msg += $game_troop.enemies[0].name + '@I\n'
    else
      msg += '܂̂̂ނ@I\n'
    end
    action_event.message(msg)
    msg = '\clear'
    if exp != 0
      msg += "ꂼ\\n"
      msg += "#{exp}|Cǵ@񂿂ƂI\\n"
    end
    if gold != 0
      msg += "#{gold}S[h@ĂɂꂽI\\n"
    end
    action_event.message(msg)

    if treasures.size == 1
      msg = "#{drop_enemies[0].name}́@#{treasures[0].name}@ĂI\\n"
      action_event.message(msg)
    elsif treasures.size != 0
      msg = "܂̂̂ނ́@ACe@ĂI\\n"
      action_event.message(msg)
    end
    for i in 0 ... treasures.size
      item = treasures[i]
      enemy = drop_enemies[i]
      if $game_party.actors.size == 1
        msg = "\\PN[0]́@#{item.name}@ɓꂽB"
        action_event.message(msg)
      else
        msg = "\\PN[0]B́@#{item.name}@ɓꂽB"
        action_event.message(msg)
      end
    end

    for level_up_data in level_up_actors
      actor,last_level = level_up_data
      action_event.me_start(nil)
      action_event.me_start(@@action_log_level_up_me)
      action_event.message("#{actor.name}́@xI\\n")

      names = [
        $data_system.words.hp,
        $data_system.words.sp,
        $data_system.words.str,
        $data_system.words.dex,
        $data_system.words.agi,
        $data_system.words.int,
      ]
      for key in [2,3,4,5,0,1]
        name = names[key]
        last_val = $data_actors[actor.id].parameters[key, last_level]
        base_val = $data_actors[actor.id].parameters[key, actor.level]
        action_event.message("#{name}@#{base_val - last_val}@B")
      end
      for level in (last_level+1) .. actor.level
        # XLK
        for learning in $data_classes[actor.class_id].learnings
          if learning.level == level
            skill = $data_skills[learning.skill_id]
            action_event.message("#{skill.name}@ڂB")
          end
        end
      end
    end

    action_event_start(action_event)
  end

  def action_log_battle_result_lose
    # ANVʕ\Cxg
    action_event = Script_Event.new
    msg = '\clear'
    if $game_party.actors.size == 1
      msg += '\PN[0]́@߂I\n'
    else
      msg += '\PN[0]B́@߂I\n'
    end
    action_event.message(msg)
    # sk\̏ꍇ
    if $game_temp.battle_can_lose
      # ogJnO BGM ɖ߂
      action_event.script('$game_system.bgm_play($game_temp.map_bgm)')
      action_event.method_call(method(:battle_end),2)
    else
      action_event.script('$game_temp.gameover = true')
    end
    action_event_start(action_event)
  end

end

end
end
