#==============================================================================
#  Phase_Actor_Command
#------------------------------------------------------------------------------
# AN^[R}htF[Y
# Copyright (C) 2005 fukuyama
#==============================================================================

module DQ
module Battle

class Phase_Actor_Command
  include Battle_Phase_Base_Module

  def initialize
    # AN^[IԂɐݒ
    @actor_index = -1
    @active_battler = nil

    next_actor
  end

  def update
    # AN^[R}hEBhEXV
    @window_actor_command.update

    # ꍇ
    if @window_actor_command.disposed?
      if @window_actor_command.attack?
        setup_attack_action
      end
      if @window_actor_command.guard?
        setup_guard_action
      end
      if @window_actor_command.skill?
        setup_skill_action
      end
      if @window_actor_command.item?
        setup_item_action
      end
      if @window_actor_command.cancel?
        prev_actor
      else
        next_actor
      end
    end
  end

  def setup_attack_action
    # UANVݒ
    @active_battler.current_action.kind = 0
    @active_battler.current_action.basic = 0
    @active_battler.current_action.targets = @window_actor_command.targets
  end

  def setup_guard_action
    # hANVݒ
    @active_battler.current_action.kind = 0
    @active_battler.current_action.basic = 1
  end

  def setup_skill_action
    # XLANVݒ
    skill = @window_actor_command.skill
    @active_battler.current_action.kind = 1
    @active_battler.current_action.basic = 0
    @active_battler.current_action.skill_id = skill.id
    @active_battler.current_action.targets = @window_actor_command.targets
  end

  def setup_item_action
    # ACeANVݒ
    item = @window_actor_command.item
    @active_battler.current_action.kind = 2
    if @window_actor_command.item_use?
      @active_battler.current_action.basic = 0
    elsif @window_actor_command.item_equip?
      @active_battler.current_action.basic = 1
    end
    @active_battler.current_action.item_id = item.id
    @active_battler.current_action.item = item
    @active_battler.current_action.targets = @window_actor_command.targets
  end

  def next_actor
    # [v
    begin
      # Ō̃AN^[̏ꍇ
      if @actor_index == $game_party.actors.size-1
        # CtF[YJn
        $scene.phase = Phase_Main.new
        return
      end
      # AN^[̃CfbNXi߂
      @actor_index += 1
      @active_battler = $game_party.actors[@actor_index]
      @active_battler.blink = true
    # AN^[R}h͂󂯕tȂԂȂx
    end until @active_battler.inputable?

    # AN^[R}h
    @window_actor_command = Window_Actor_Command.new(@active_battler)
  end

  def prev_actor
    # [v
    begin
      # ŏ̃AN^[̏ꍇ
      if @actor_index == 0
        # p[eBR}htF[YJn
        $scene.phase = Phase_Party_Command.new
        return
      end
      # AN^[̃CfbNX߂
      @actor_index -= 1
      @active_battler = $game_party.actors[@actor_index]
      @active_battler.blink = true
    # AN^[R}h͂󂯕tȂԂȂx
    end until @active_battler.inputable?

    # AN^[R}h
    @window_actor_command = Window_Actor_Command.new(@active_battler)
  end

end

end
end
