
package rescue;

import java.util.*;
import java.io.*;
import java.net.*;

public class LongUDPSocket
{
	protected DatagramSocket _socket;
	public LongUDPSocket() throws SocketException
	{
		_socket = new DatagramSocket();
	}
	
	public void send(byte[] data, InetAddress address, int port) throws IOException
	{
		byte[] d = new byte[data.length + 8];
		d[0] = 0x00;
		d[1] = 0x08;
		d[2] = 0x00;
		d[3] = 0x00;
		d[4] = 0x00;
		d[5] = 0x00;
		d[6] = 0x00;
		d[7] = 0x01;
		System.arraycopy(data, 0, d, 8, data.length);
		_socket.send(new DatagramPacket(d, d.length, address, port));
	}
	
	protected static class Frame {
		public int size;
		public byte[] data;
	}
	protected static class Packet {
		public InetAddress address;
		public int port;
		public int id;
		public Vector data;
	}
	protected Vector _packets = new Vector();

	protected InetAddress _address;
	public InetAddress getAddress() {
		return _address;
	}
	protected int _port;
	public int getPort() {
		return _port;
	}
	public InputStream receive() throws IOException
	{
		for(;;) {
			byte[] input = new byte[0x4000];
			DatagramPacket packet = new DatagramPacket(input, input.length);
			_socket.receive(packet);
			int id = (((int)input[2] & 0xFF) << 8) | ((int)input[3] & 0xFF);
			int number = (((int)input[4] &0xFF) << 8) | ((int)input[5] & 0xFF);
			int total = (((int)input[6] & 0xFF) << 8) | ((int)input[7] & 0xFF);
			System.out.println(id + ":" + number + "/" + total);
			if(total == 1) {
				_address = packet.getAddress();
				_port = packet.getPort();
				System.out.println(packet.getLength() - 8);
				return new ByteArrayInputStream(input, 8, packet.getLength() - 8);
			}
			Enumeration e = _packets.elements();
			Packet p = null;
			int index = 0;
			boolean hotPacket = true;
			while(e.hasMoreElements()) {
				p = (Packet)e.nextElement();
				if(p.id == id && p.port == packet.getPort() && p.address.equals(packet.getAddress())) {
					hotPacket = false;
					break;
				}
				index++;
			}
			if(hotPacket) {
				System.out.println("new");
				p = new Packet();
				p.address = packet.getAddress();
				p.port = packet.getPort();
				p.id = id;
				p.data = new Vector(total);
				for(int i=0; i<total; i++)
					p.data.addElement(null);
				Frame f = new Frame();
				f.size = packet.getLength();
				f.data = input;
				p.data.setElementAt(f, number);
				_packets.insertElementAt(p, 0);
				if(_packets.size() > 16)
					_packets.removeElementAt(_packets.size() - 1);
			} else {
				System.out.println("added");
				Frame f = new Frame();
				f.size = packet.getLength();
				f.data = input;
				p.data.setElementAt(f, number);
				int i = 0;
				for(; i<p.data.size(); i++) {
					if(p.data.elementAt(i) == null)
						break;
				}
				_packets.removeElementAt(index);
				if(i >= p.data.size()) {
					Vector v = new Vector(number);
					Enumeration e2 = p.data.elements();
					while(e2.hasMoreElements()) {
						Frame fr = (Frame)e2.nextElement();
						v.addElement(new ByteArrayInputStream(fr.data, 8, fr.size-8));
					}
					_address = p.address;
					_port = p.port;
					return new SequenceInputStream(v.elements());
				}
				_packets.insertElementAt(p, 0);
			}
		}
	}
	
}

