

#include "common.hxx"
#include "basic.hxx"
#include "Config.hxx"
#include "Address.hxx"
#include "Input.hxx"
#include "Output.hxx"
#include "LongUDPSocket.hxx"

#ifdef MISC
#  include "MiscObjectPool.hxx"
//#  include "MiscHumanoid.hxx"
#else
#  include "ObjectPool.hxx"
#endif

#include "objects.hxx"

#ifdef MISC_CLASS
#include "misc_class.hxx"
#endif
//#include "simBlockage.h"
#include "PolygonData.hxx"

using namespace Rescue;

int main2(int argc, char** argv);

#ifdef MISC
void commands(S32& time, Input& input, Output& output, LongUDPSocket& socket, Address& to, MiscObjectPool& pool, Config& config);
void commands(S32& time, Header type, Input& input, MiscObjectPool& pool, Config& config);
void load(S32& time, MovingObject* agent, Input& input, MiscObjectPool& pool, Config& config);
void unload(S32& time, MovingObject* agent, Input& input, MiscObjectPool& pool);
void rescue(S32& time, MovingObject* agent, Input& input, MiscObjectPool& pool, Config& config);
void stretch(S32& time, MovingObject* agent, Input& input, MiscObjectPool& pool, Config& config);
void move(S32& time, MovingObject* agent, Input& input, MiscObjectPool& pool, Config& config);
void clear(S32& time, MovingObject* agent, Input& input, MiscObjectPool& pool, Config& config);
#else
void commands(S32& time, Input& input, Output& output, LongUDPSocket& socket, Address& to, ObjectPool& pool, Config& config);
void commands(S32& time, Header type, Input& input, ObjectPool& pool, Config& config);
void load(S32& time, MovingObject* agent, Input& input, ObjectPool& pool, Config& config);
void unload(S32& time, MovingObject* agent, Input& input, ObjectPool& pool);
void rescue(S32& time, MovingObject* agent, Input& input, ObjectPool& pool, Config& config);
void stretch(S32& time, MovingObject* agent, Input& input, ObjectPool& pool, Config& config);
void move(S32& time, MovingObject* agent, Input& input, ObjectPool& pool, Config& config);
void clear(S32& time, MovingObject* agent, Input& input, ObjectPool& pool, Config& config);
#endif // MISC

#ifdef MISC_CLASS
void step(S32& time, MiscObjectPool& pool, Config& config, Dice& dice, IMOCivilian& imoc);
void step_init(S32& time, MiscObjectPool& pool, Config& config, Dice& dice, IMOCivilian& imoc);

void step(S32& time, ObjectPool& pool, Config& config, Dice& dice, IMOCivilian& imoc);
void step_init(S32& time, ObjectPool& pool, Config& config, Dice& dice, IMOCivilian& imoc);
#endif

void survive(S32& time, S32& x, Civilian* c);

#ifdef MISC_CLASS
bool testPosition(IMOCivilian& imoc, MovingObject* mo);
void testSelectObject(ObjectPool& pool, IMOCivilian& imoc);
void testJudgeObject(IMOCivilian& imoc, MovingObject* mo);
#endif

//long int polyNum;
//long int pointNum;
//coordinates* polyPtr;
//polyData* pData;

int main(int argc, char** argv)
{
     try {
          return main2(argc, argv);
     } catch(std::exception& e) {
          fprintf(stderr, "%s\n", (const char*)e.what());
     } catch(...) {
          fprintf(stderr, "error...\n");
     }
     return 1;
}

int main2(int argc, char** argv)
{
     const char* host = "localhost";
     Config config;

     // 
     int i;
     int count = 0;
     for(i=1; i<argc; i++) {
          if(argv[i][0] == '-') {
               if(strcmp(argv[i], "-file") == 0) {
                    if(++i < argc) {
                         config.readConfigFile(argv[i]);
                    } else {
                         fprintf(stderr, "error: '-file'\n");
                    }
               } else {
                    if(++i < argc) {
                         if(!config.setValue(argv[i-1]+1, argv[i]))
                              fprintf(stderr, "error: '%s'\n", argv[i]);
                    } else {
                         fprintf(stderr, "error: '%s'\n", argv[i-1]);
                    }
               }
          } else {
               switch(count++) {
               case 0:
                    host = argv[i];
                    break;
               default:
                    fprintf(stderr, "error: '%s'\n", argv[i]);
                    break;
               }
          }
     }

#ifdef MISC_DEBUG
     printf("config.misc_random_seed() : %d\n", config.misc_random_seed());
     printf("magnitude_dice() : %d\n", config.magnitude_dice());
     printf("parameter_damage_bury_k() : %f\n", config.parameter_damage_bury_k());
     printf("config.brokenness_partial_collapsed(): %d\n", config.brokenness_partial_collapsed());
     printf("config.brokenness_half_collapsed(): %d\n", config.brokenness_half_collapsed());
     printf("config.brokenness_all_collapsed(): %d\n", config.brokenness_all_collapsed());
     printf("config.buriedness_wood_partial_6seismic() : %d\n", config.buriedness_wood_partial_6seismic());
     printf("config.buriedness_wood_half_6seismic() : %d\n", config.buriedness_wood_half_6seismic());
     printf("config.buriedness_wood_all_6seismic() : %d\n", config.buriedness_wood_all_6seismic());
     printf("config.damage_bury_unhurt(): %d\n", config.damage_bury_unhurt());
     printf("config.damage_bury_slight() : %d\n", config.damage_bury_slight());
     printf("config.damage_bury_serious() : %d\n", config.damage_bury_serious());
     printf("config.damage_bury_dying() : %d\n", config.damage_bury_dying());
     printf("config.prob_bury_slight() : %f\n", config.prob_bury_slight());
     printf("config.prob_bury_serious() : %f\n", config.prob_bury_serious());
     printf("config.prob_bury_dying() : %f\n", config.prob_bury_dying());
     printf("config.damage_broken_unhurt() : %d\n", config.damage_broken_unhurt());
     printf("config.damage_broken_slight() : %d\n", config.damage_broken_slight());
     printf("config.damage_broken_serious() : %d\n", config.damage_broken_serious());
     printf("config.damage_broken_death() : %d\n", config.damage_broken_death());
     printf("config.rate_wood_death_5seismic() : %f\n", config.rate_wood_death_5seismic());
     printf("config.rate_wood_death_6seismic() : %f\n", config.rate_wood_death_6seismic());
     printf("config.rate_wood_death_7seismic() : %f\n", config.rate_wood_death_7seismic());
     printf("config.rate_wood_death_8seismic() : %f\n", config.rate_wood_death_8seismic());
     printf("config.rate_wood_serious_5seismic() : %f\n", config.rate_wood_serious_5seismic());
     printf("config.rate_wood_serious_6seismic() : %f\n", config.rate_wood_serious_6seismic());
     printf("config.rate_wood_serious_7seismic() : %f\n", config.rate_wood_serious_7seismic());
     printf("config.rate_wood_serious_8seismic() : %f\n", config.rate_wood_serious_8seismic());
     printf("config.rate_wood_slight_5seismic() : %f\n", config.rate_wood_slight_5seismic());
     printf("config.rate_wood_slight_6seismic() : %f\n", config.rate_wood_slight_6seismic());
     printf("config.rate_wood_slight_7seismic() : %f\n", config.rate_wood_slight_7seismic());
     printf("config.rate_wood_slight_8seismic() : %f\n", config.rate_wood_slight_8seismic());
     fflush(NULL);
#endif

     // åȺ
     LongUDPSocket socket(config.textlogname_miscsimulator());
     Input input;
     Output output;
     output.setWait(config.send_udp_wait());
     output.resetFrameSize(config.send_udp_size());
     Address to(host, config.port());   //

     // ³å
     printf("connecting...\n");
     output.clear();                                                            //ϥХåեˤ
     output.put(SK_CONNECT);                                            //ϥХåե SK_CONNECT (4ХȤ)Ϥ
     Output::Cursor base = output.put(~(S32)0); //body ΥȤƤȤꤢߡͤϤƤơbase ˤΰ֤򵭲롣
     output.put(0);                                                             //ϥХåե 0 Ϥ
     output.setSize(base);                                              //base ǵ֤ˡbase 餳ޤǤ put Хȿꤹ롣
     output.put(HEADER_NULL);
     socket.send(output, to, -1);                                       //output  put Х to 롣

     // å롼
     S32 time = 0;

//     Dice dice(config.misc_random_seed());

#ifdef MISC
     MiscObjectPool pool(config, config.misc_random_seed());
#else
     ObjectPool pool;
#endif

     for(;;) {
          try {
               socket.receive(input);   // TODO: 顼㳰֤     //ǡinput ߤ롣
               for(;;) {
                    Header header = input.get();        //input (4ХȤ)ǡФheader 
                    if(header == HEADER_NULL)
                         break;

                    S32 size = input.get();
                    Input::Cursor start = input.cursor();       //ɤ߽ФƤ֤򵭲

                    switch(header) {
                    default:
                         printf("Unknown header.\n");
                         break;
                    case KS_CONNECT_ERROR:
                         printf("Connection failed.\n");
                         return 1;
                    case KS_CONNECT_OK:
                         printf("Connect Ok.\n");
                         // ack ֤
                         output.clear();
                         output.put(SK_ACKNOWLEDGE);
                         output.put(~(S32)0);
                         output.put(HEADER_NULL);
                         socket.send(output, to, -1);
                                        
                         to = socket.addressRecievedFrom();     //ʹߤѹ
                         pool.restructure(0, input);                    //ɥǥ롣

                         break;
                    case KS_COMMANDS:
                         printf("KS_COMMANDS\n");
                         commands(time, input, output, socket, to, pool, config);
                         break;
                    case KS_UPDATE:
                         time = input.get();
                         pool.restructure(time, input);

                         printf("time = %ld.\n", (long)time);

#ifdef MISC
    // by TM ,  commands ľ˹Ԥ٤, Τѹݤ
    // by TM Ȥ, commands ľ step(time) Ȥ step(time +- 1) ȤǤϥʤȤǧ
    pool.step(time);
#endif
                         break;
                    }

                    input.setCursor(start);
                    input.skip(size);                                           //size Хȥåפ
               }
          } catch(std::exception& e) {
               fprintf(stderr, "%s\n", (const char*)e.what());
          } catch(...) {
               fprintf(stderr, "error...\n");
          }
     }
        
     return 0;
}

#ifdef MISC
void commands(S32& time, Input& input, Output& output, LongUDPSocket& socket, Address& to, MiscObjectPool& pool, Config& config)
#else
void commands(S32& time, Input& input, Output& output, LongUDPSocket& socket, Address& to, ObjectPool& pool, Config& config)
#endif
{
     // KS_COMMANDS 
     time = input.get();
     Header type;
     while(type = input.get(), type != HEADER_NULL) {
          S32 size = input.get();
          Input::Cursor start = input.cursor();
          commands(time, type, input, pool, config);
          input.setCursor(start);
          input.skip(size);
     }

     // ߥ졼̤
     output.clear();
     output.put(SK_UPDATE);
     Output::Cursor base = output.put(~(S32)0);
     pool.output(output, time);
     output.setSize(base);
     output.put(HEADER_NULL);
     socket.send(output, to, time);
}
#ifdef MISC
void commands(S32& time, Header type, Input& input, MiscObjectPool& pool, Config& config)
#else
void commands(S32& time, Header type, Input& input, ObjectPool& pool, Config& config)
#endif
{
     Id sender;
     while(sender = input.get(), sender != 0) {
          S32 size = input.get();
          Input::Cursor start = input.cursor();

          Object* o = pool.get(sender); //ɥǥ뤫顢sender  ID ˻ĥ֥ȤĥФ
          MovingObject* agent = dynamic_cast<MovingObject*>(o);
          if(agent != 0) {
               switch(type) {
               case AK_LOAD:
                    load(time, agent, input, pool, config);
                    break;
               case AK_UNLOAD:
                    unload(time, agent, input, pool);
                    break;
               case AK_RESCUE:
                    rescue(time, agent, input, pool, config);
                    break;
               case AK_STRETCH:
                    stretch(time, agent, input, pool, config);
                    break;
               case AK_MOVE:
                    move(time, agent, input, pool, config);
                    break;
               case AK_CLEAR:
                    clear(time, agent, input, pool, config);
                    break;
               }
          }
                
          input.setCursor(start);
          input.skip(size);
     }
}

static bool isNear(Object* a, Object* b, Config& config) {
     if (config.near_agents_rescuable()) {
          Vertex* nodeA = dynamic_cast<Vertex*>(a);
          Vertex* nodeB = dynamic_cast<Vertex*>(b);
          Edge* edgeA = dynamic_cast<Edge*>(a);
          Edge* edgeB = dynamic_cast<Edge*>(b);
          if (nodeA != NULL && edgeB != NULL) {
               if (edgeB->head() == nodeA || edgeB->tail() == nodeA)
                    return true;
          } else if (nodeB != NULL && edgeA != NULL) {
               if (edgeA->head() == nodeB || edgeA->tail() == nodeB)
                    return true;
          }
     }
     return a == b;
}

#ifdef MISC
void load(S32& time, MovingObject* agent, Input& input, MiscObjectPool& pool, Config& config)
#else
void load(S32& time, MovingObject* agent, Input& input, ObjectPool& pool, Config& config)
#endif
{
     if (!config.miscsimulator_supports_load())
          return;
     
     AmbulanceTeam* a = dynamic_cast<AmbulanceTeam*>(agent);
     if(a != 0) {
          if(agent->contents().empty() && a->buriedness() == 0) {
               Id id = input.get();
               MovingObject* target = dynamic_cast<MovingObject*>(pool.get(id));
               if(target != 0) {
                    Humanoid* h = dynamic_cast<Humanoid*>(target);
                    Car* car = dynamic_cast<Car*>(target);
                    if(h != 0 && car == 0){
                         if(h->buriedness() == 0 && isNear(target->position(), agent->position(), config)){
                              target->setPosition(time, agent);
                              target->setPositionExtra(time, 0);
//                            printf("load %ld by %ld\n", (long)target->id(), (long)agent->id());
                              printf("id%ld load id%ld\n", (long)agent->id(), (long)target->id());
                              return ;
                         }
                    }
               }
//             printf("load failed %ld by %ld\n", (long)target->id(), (long)agent->id());
               printf("id%ld failed load id%ld\n", (long)agent->id(), (long)target->id());
          }
     }
}

#ifdef MISC
void unload(S32& time, MovingObject* agent, Input& input, MiscObjectPool& pool)
#else
void unload(S32& time, MovingObject* agent, Input& input, ObjectPool& pool)
#endif
{
     AmbulanceTeam* a = dynamic_cast<AmbulanceTeam*>(agent);
     if(a != 0) {
          if(!agent->contents().empty() && a->buriedness() == 0) {
               Object* target = agent->contents().front();
               ASSERT(dynamic_cast<MovingObject*>(target) != 0);
               MovingObject* mo = (MovingObject*)target;
               mo->setPosition(time, agent->position());
               mo->setPositionExtra(time, agent->positionExtra());
               printf("id%ld unload %ld\n", (long)agent->id(), (long)mo->id());
          }
     }
}

#ifdef MISC
void rescue(S32& time, MovingObject* agent, Input& input, MiscObjectPool& pool, Config& config)
#else
void rescue(S32& time, MovingObject* agent, Input& input, ObjectPool& pool, Config& config)
#endif
{
     AmbulanceTeam* a = dynamic_cast<AmbulanceTeam*>(agent);
     if(a != 0 && a->buriedness() == 0) {
          Id id = input.get();
          Humanoid* target = dynamic_cast<Humanoid*>(pool.get(id));
          if(target != 0) {
               if(isNear(target->position(), agent->position(), config)) {
                    if(target->buriedness() > 0) {
                         target->setBuriedness(time, target->buriedness() - 1);
                         printf("id%ld rescue id%ld : buriedness %ld\n", (long)agent->id(), (long)target->id(), (long)target->buriedness());
                    }
                    else{
                         target->setBuriedness(time, 0);
                         printf("id%ld failed rescue id%ld : buriedness already 0\n", (long)agent->id(), (long)target->id());
                    }
               }
          }
     }
}

#ifdef MISC
void stretch(S32& time, MovingObject* agent, Input& input, MiscObjectPool& pool, Config& config)
#else
void stretch(S32& time, MovingObject* agent, Input& input, ObjectPool& pool, Config& config)
#endif
{
     FireBrigade* brigade = dynamic_cast<FireBrigade*>(agent);
     if(brigade != 0 && brigade->buriedness() == 0) {
          brigade->setStretchedLength(time, brigade->stretchedLength() + config.stretch_length());
          printf("id%ld stretch\n", (long)agent->id());
     }

}

#ifdef MISC
void move(S32& time, MovingObject* agent, Input& input, MiscObjectPool& pool, Config& config)
#else
void move(S32& time, MovingObject* agent, Input& input, ObjectPool& pool, Config& config)
#endif
{
     FireBrigade* brigade = dynamic_cast<FireBrigade*>(agent);
     if(brigade != 0 && brigade->stretchedLength() > 1)
          brigade->setStretchedLength(time, 0);
}


#ifdef MISC
void clear(S32& time, MovingObject* agent, Input& input, MiscObjectPool& pool, Config& config)
#else
void clear(S32& time, MovingObject* agent, Input& input, ObjectPool& pool, Config& config)
#endif
{
     PoliceForce* police = dynamic_cast<PoliceForce*>(agent);
     if(police != 0 && police->buriedness() == 0) {
          Id id = input.get();
          Road* target = dynamic_cast<Road*>(pool.get(id));
          if(target != 0) {
               if(target != agent->position()   && target->head() != agent->position() && target->tail() != agent->position()){
                    printf("id%ld failed clear id%ld : not appropriate position\n", (long)agent->id(), (long)target->id());
                    return;
               }
               S32 block = target->block();
               S32 repairCost = target->repairCost();
               if(repairCost <= 0) {
                    block = 0;
               } else {
                    block = block * (repairCost - 1) / repairCost;
                    repairCost--;
                    target->setRepairCost(time, repairCost);
               }
               target->setBlock(time, block);
               printf("id%ld clear id%ld : block %ld , repairCost %ld\n", (long)agent->id(), (long)target->id(), (long)target->block(), (long)target->repairCost());
          }
     }
}
