// UDPSocket.cxx
//
/////////////////////////////////////////////////////////////////////////////

#include "common.hxx"
#include "UDPSocket.hxx"

#ifndef NDEBUG
#  include "UDPSocket.inl"
#endif

namespace Rescue
{
	/////////////////////////////////////////////////////////////////////////
	// UDPSocket
	
	UDPSocket::~UDPSocket()
	{
		if(m_socket != INVALID_SOCKET)
			closesocket(m_socket);
	}
	
	UDPSocket::UDPSocket(const Address& self) : m_addressRecievedFrom((u_long)0, 0)
	{
		initializeSocketLibrary();
		
		//m_socket = INVALID_SOCKET;
		
		// socket 롣
		m_socket = socket(PF_INET, SOCK_DGRAM, 0);
		if(m_socket == INVALID_SOCKET) {
			perror("error: can't create a socket.");
			throw SocketError("can't create a socket.");
		}
		
		// bind 롣
		sockaddr_in sai = { 0 };
		sai.sin_family = AF_INET;
		sai.sin_addr.s_addr = self.addressAsNetworkOrder();
		sai.sin_port = self.portAsNetworkOrder();
		if(bind(m_socket, (sockaddr*)&sai, sizeof(sai)) == SOCKET_ERROR) {
			perror("error: can't bind(...)");
			closesocket(m_socket);
			throw SocketError("can't bind(...)");
		}
	}
	
	bool UDPSocket::send(const Address& to, const char* buffer, int size)
	{
		ASSERT(m_socket != INVALID_SOCKET);
		sockaddr_in sai = { 0 };
		sai.sin_family = AF_INET;
		sai.sin_addr.s_addr = to.addressAsNetworkOrder();
		sai.sin_port = to.portAsNetworkOrder();
		
		int sent = sendto(m_socket, buffer, size, 0, (const sockaddr*)&sai, sizeof(sai));
		if(sent != size) {
			perror("error: can't sendto(...)\n");
			return false;
		}
		return true;
	}
	bool UDPSocket::send(const Address& to, const Byte* buffer, int size)
	{
		return send(to, (const char*)buffer, size);
	}
	bool UDPSocket::empty() const
	{
		ASSERT(m_socket != INVALID_SOCKET);
		
		fd_set fds;
		FD_ZERO(&fds);
		FD_SET(m_socket, &fds);
		timeval timeout = { 0 };
		int exist = select(m_socket+1, &fds, NULL, NULL, &timeout);
		ASSERT(exist != SOCKET_ERROR);
		return !exist;
	}
	int UDPSocket::receive(char* buffer, int size)
	{
		ASSERT(m_socket != INVALID_SOCKET);
		struct sockaddr_in sai;
		struct SockLength {
			int size;
			SockLength() {
				size = sizeof(sockaddr_in);
			}
			operator int* () {
				return (int*)&size;
			}
			operator unsigned int* () {
				return (unsigned int*)&size;
			}
		} sizeof_sai;
		int received = recvfrom(m_socket, buffer, size, 0, (sockaddr*)&sai, sizeof_sai);
		if(received < 0) {
			if(WSAGetLastError() == WSAEMSGSIZE)
				return -2;
			perror("error: recvfrom");
			return -1;
		}
		
		m_addressRecievedFrom = Address(ntohl(sai.sin_addr.s_addr), ntohs(sai.sin_port));
		return received;
	}
	int UDPSocket::receive(Byte* buffer, int size)
	{
		return receive((char*)buffer, size);
	}

	int UDPSocket::wait(const std::vector<const UDPSocket*>& sockets, int ms)
	{
		if(sockets.size() <= 0)
			return true;
		fd_set fds;
		FD_ZERO(&fds);
		std::vector<const UDPSocket*>::const_iterator it = sockets.begin();
		SOCKET max = 0;
		for(; it != sockets.end(); it++) {
			SOCKET socket = (*it)->m_socket;
			FD_SET(socket, &fds);
			if(max < socket)
				max = socket;
		}
		timeval timeout = { 0 };
		timeout.tv_sec = ms / 1000;
		timeout.tv_usec = ms % 1000 * 1000;
		int result = select(max+1, &fds, NULL, NULL, &timeout);
		ASSERT(result != SOCKET_ERROR);
		return result;
	}
	
	/////////////////////////////////////////////////////////////////////////
} // namespace Rescue
