// MiscObjectPool.cxx
//
/////////////////////////////////////////////////////////////////////////////

#include "common.hxx"
#include "MiscObjectPool.hxx"
//#include "misc_class.hxx"

#ifndef NDEBUG
#  include "MiscObjectPool.inl"
#endif

//#include "MiscHumanoid.hxx"

namespace Rescue
{
     /////////////////////////////////////////////////////////////////////////
     // MiscObjectPool
	
     MiscObjectPool::~MiscObjectPool(){
     }

     //////////////////////////////////////////////////////////////
     // ΥƥåפΥߥ졼ʹ
     void MiscObjectPool::step(S32 time){
#ifdef MISC_DEBUG_FUNC_NAME
	  printf("void MiscObjectPool::step(S32 time){\n");
	  fflush(NULL);
#endif	  

	  // ֥Ȥʬ
	  classifyObjects(time);

	  // Ͽȯˤʤ륨Ȥ꿶
	  // ʪ¤ȿ٤Ȥ˷
	  if(time == 1){
	       setBuried(time);
	  }

	  // װ˴Ťƥ᡼Ϳ
	  setDamages(time);

	  // ߥ졼ʹ (᡼ʹ)
	  progressDamages(time);
     }

     // ֥Ȥʬ
     void MiscObjectPool::classifyObjects(S32 time){
#ifdef MISC_DEBUG_FUNC_NAME
	  printf("void MiscObjectPool::classifyObjects(S32 time){\n");
	  fflush(NULL);
#endif	  
	  // 
	  m_agent.clear();
	  m_injury.clear();
	  m_treatedInRefuge.clear();
	  m_onRoadBlock.clear();
	  for(int i = 0; i <= ATTB_MAX; i++){  
	       m_indoor[i].clear(); // ˤ륨
	       for(int j = 0; j <= SEISMIC_MAX; j++){
		    m_inCivils[i][j].clear();  // ο, ¤ͼʬष
		    m_inCivilsBroken[i][j].clear();  
		    m_inCivilsFiery[i][j].clear();
		    for(int k = 0; k <= BROKEN_MAX; k++){
			 m_victimBroken[i][j][k].clear();
		    }
	       }
	  }

	  // ֥Ȥʬ
	  Objects::const_iterator it = objects().begin();
	  for(int count = 0; it != objects().end(); it++, count++){
//	       Civilian* mc = dynamic_cast<Civilian*>(*it);
	       Humanoid* h = dynamic_cast<Humanoid*>(*it);
	       if(h != 0) {
		    classifyAgents(time, h);
	       }
	       Building* b = dynamic_cast<Building*>(*it);
	       if(b != 0) {
		    classifyBuilding(time, b);
	       }
	  }

#if MISC_DEBUG
	  for(int i = 0; i <= ATTB_MAX; i++){
	       for(int j = 0; j <= SEISMIC_MAX; j++){
		    printf("InCivils[%ld][%ld]: %ld ", (long)i, (long)j, (long)m_inCivils[i][j].size());
	       }
	       printf("\n");
	  }
	  printf("\n");

	  printf("Civilians in the breaking buildings\n");
	  for(int i = 0; i <= ATTB_MAX; i++){
	       for(int j = 0; j <= SEISMIC_MAX; j++){
		    printf("InCivilsB[%ld][%ld]: %ld ", (long)i, (long)j, (long)m_inCivilsBroken[i][j].size());
	       }
	       printf("\n");
	  }
	  printf("\n");

	  printf("Civilians in the fierying buildings\n");	  
	  for(int i = 0; i <= ATTB_MAX; i++){
	       for(int j = 0; j <= SEISMIC_MAX; j++){
		    printf("InCivilsF[%ld][%ld]: %ld ", (long)i, (long)j, (long)m_inCivilsFiery[i][j].size());
	       }
	       printf("\n");
	  }
	  printf("\n");

	  printf("Victims in the breaking buildings\n");	  
	  for(int k = 0; k <= BROKEN_MAX; k++){
	       for(int i = 0; i <= ATTB_MAX; i++){
		    for(int j = 0; j <= SEISMIC_MAX; j++){
			 printf("VB[%ld][%ld][%ld]: %ld ", (long)i, (long)j, (long)k, (long)m_victimBroken[i][j][k].size());
		    }
		    printf("\n");
	       }
	       printf("\n");
	  }
	  printf("\n");
	  fflush(NULL);
#endif

     }

     // ʪʬ
     void MiscObjectPool::classifyBuilding(S32 time, Building* b){
#ifdef MISC_DEBUG_FUNC_NAME
	  printf("void MiscObjectPool::classifyBuilding(S32 time, Building* b){\n");
	  fflush(NULL);
#endif	  

#if MISC_DEBUG
	  // ݲηʪ
	  if(b->brokenness() > 0 && time == b->getTimeBrokennessUpdated())
	       m_buildingBroken.push_back(b);
	  // ǳƤʪ
	  if(b->fieryness() >= 1 && b->fieryness() <= 3)
	       m_buildingFiery.push_back(b);
#endif 
     }

     // Ȥʬ
     void MiscObjectPool::classifyAgents(S32 time, Humanoid* h){

#ifdef MISC_DEBUG_FUNC_NAME
	  printf("MiscObjectPool::classifyAgents(S32 time, Humanoid* mc){\n");
	  fflush(NULL);
#endif
	  Humanoid* mc = dynamic_cast<Humanoid*>(h);
	  Car* car = dynamic_cast<Car*>(h);
	  if(mc != 0 && car == 0)
	       classifyCivils(time, mc);
     }

     void MiscObjectPool::classifyCivils(S32 time, Humanoid* mc){
#ifdef MISC_DEBUG_FUNC_NAME
	  printf("MiscObjectPool::classifyCivils(S32 time, Humanoid* mc){\n");
	  fflush(NULL);
#endif	  
	  // ͸Υ
	  // ͸
	  // ¤Ȳ͸
	  // ¤Ȳ͸
	  // ǳƤʪˤ͸

	  m_agent.push_back(mc);
	  
	  // ϩˤ
	  Road* r = dynamic_cast<Road*>(mc->position());
	  if(r != 0){
	       // ƻϩ줿
// by TM
//	       if(r->block() > 0 && time == r->getTimeBlockUpdated()){
if(r->block() > r->previousBlock() && time == r->getTimeBlockUpdated()){
		    m_onRoadBlock.push_back(mc);
#ifdef MISC_DEBUG
		    printf("getTimeBlockUpdated(): %ld\n", r->getTimeBlockUpdated());
		    fflush(NULL);
#endif
	       }
	  }

	  Building* b = dynamic_cast<Building*>(mc->position());
	  // ˤ
	  if(b != 0) {
	       // ʪǳƤ
	       if(b->fieryness() >= 1 && b->fieryness() <= 3){
		    m_inBuildingFiery.push_back(mc);
	       }

	       // ٤ȹ¤ͼĴ٤ʬ
	       GradeSeismic Sgrade = prmt.pData.getSeismic(b->x(), b->y());
	       AttBuilding Abuild = (AttBuilding)b->buildingAttributes();
	       m_indoor[Abuild].push_back(mc);
	       m_inCivils[Abuild][Sgrade].push_back(mc);
 	       m_inCivils[ATTB_MAX][Sgrade].push_back(mc);
 	       m_inCivils[Abuild][SEISMIC_MAX].push_back(mc);
 	       m_inCivils[ATTB_MAX][SEISMIC_MAX].push_back(mc);

	       // ¤ͼȿ٤ݲ٤Ĵ٤ʬ
	       if(b->brokenness() > 0 && time == b->getTimeBrokennessUpdated()){
		    // ¤ͼȿ٤ݲ٤ˤʬ
		    GradeBroken Bgrade = prmt.getBrokenGrade(b->brokenness());
		    m_victimBroken[Abuild][Sgrade][Bgrade].push_back(mc);
 		    m_victimBroken[ATTB_MAX][Sgrade][Bgrade].push_back(mc);
 		    m_victimBroken[Abuild][SEISMIC_MAX][Bgrade].push_back(mc);
 		    m_victimBroken[ATTB_MAX][SEISMIC_MAX][Bgrade].push_back(mc);
 		    m_victimBroken[Abuild][Sgrade][BROKEN_MAX].push_back(mc);
 		    m_victimBroken[ATTB_MAX][Sgrade][BROKEN_MAX].push_back(mc);
 		    m_victimBroken[Abuild][SEISMIC_MAX][BROKEN_MAX].push_back(mc);
 		    m_victimBroken[ATTB_MAX][SEISMIC_MAX][BROKEN_MAX].push_back(mc);

		    // ¤ͼȿ٤ˤʬ
		    m_inCivilsBroken[Abuild][Sgrade].push_back(mc);
 		    m_inCivilsBroken[ATTB_MAX][Sgrade].push_back(mc);
 		    m_inCivilsBroken[Abuild][SEISMIC_MAX].push_back(mc);
 		    m_inCivilsBroken[ATTB_MAX][SEISMIC_MAX].push_back(mc);

	       }

	       // TODO: ٤ˤʬѹ
	       if(b->fieryness() >= 1 && b->fieryness() <= 3){
		    m_inCivilsFiery[Abuild][Sgrade].push_back(mc);
 		    m_inCivilsFiery[ATTB_MAX][Sgrade].push_back(mc);
 		    m_inCivilsFiery[Abuild][SEISMIC_MAX].push_back(mc);
 		    m_inCivilsFiery[ATTB_MAX][SEISMIC_MAX].push_back(mc);
	       }
	  }
     }

     //////////////////////////////////////////////////////////////
     // Ԥ (Ȳ¤, ٤ˤ)
     void MiscObjectPool::setBuried(S32 time){
#ifdef MISC_DEBUG_FUNC_NAME
	  printf("MiscObjectPool::setBuried(S32 time){\n");
	  fflush(NULL);
#endif
	  // ¤ͼȿ٤˱٤ꤹ
	  for(int i = 0; i < ATTB_MAX; i++){
	       for(int j = 0; j < SEISMIC_MAX; j++){
		    setBuried(time, AttBuilding(i), GradeSeismic(j));
	       }
	  }
     }

     void MiscObjectPool::setBuried(S32 time, AttBuilding ABuild, GradeSeismic SGrade){
#ifdef MISC_DEBUG_FUNC_NAME
	  printf("MiscObjectPool::setBuried(S32 time, AttBuilding ABuild, GradeSeismic SGrade){\n");
	  fflush(NULL);
#endif

	  // Ȳݲʪˤ륨
	  MCivils mc = m_inCivilsBroken[ABuild][SGrade]; 
	  // ˤʤΨ
	  double rate = prmt.rateBury[ABuild][SGrade];
	  // Ԥδ
	  S32 expectBuried = static_cast<S32>(mc.size() * rate);

#ifdef MISC_DEBUG
	  printf("Agents in Broken Building: %ld rate: %f\n", (long)mc.size(), rate);
	  printf("Expectation of Buried Agent: %ld\n", (long)expectBuried);
	  fflush(NULL);
#endif
	  // ʬˤ
	  int count = 0;


	  for(; count < expectBuried; ){
	       int order = dice.cast(0, mc.size() - 1);
	       Humanoid* target = mc[order];
	       if(time + 1 > target->getTimeBuriednessUpdated()){
		    Building* b = dynamic_cast<Building*>(target->position());
		    GradeBroken BGrade = prmt.getBrokenGrade(b->brokenness());
		    // buriedness¤ͼ, , ݲ̤Ѱդ
		    S32 buriedness = prmt.buriedness[ABuild][BGrade][SGrade];
		    // damage¤ͼ, , ݲ̤Ѱդ
		    S32 damageBury = cfg->damage_bury_unhurt();
		    // Ψǥ᡼Ϳ (̵, ڽ, Ž, λ)
		    long mag = cfg->magnitude_dice();
		    long pip = dice.cast(1, mag);
		    long pip1 = long(cfg->prob_bury_dying() * mag);
		    long pip2 = long((cfg->prob_bury_dying() + cfg->prob_bury_serious()) * mag);
		    long pip3 = long((cfg->prob_bury_dying() + cfg->prob_bury_serious() + cfg->prob_bury_slight()) * mag);
		    // λ
		    if(pip >= 1 && pip <= pip1){
			 damageBury = cfg->damage_bury_dying();
		    }
		    // Ž
		    else if(pip >= pip1 && pip <= pip2){
			 damageBury = cfg->damage_bury_serious();
		    }
		    // ڽ
		    else if(pip >= pip2 && pip <= pip3){
			 damageBury = cfg->damage_bury_slight();
		    }
		    // ̵
		    else {
			 damageBury = cfg->damage_bury_unhurt();
		    }

		    target->setBuriedness(time + 1, buriedness);
		    target->property()->setDamageBury(time + 1, damageBury);
		    count++;

#ifdef MISC_DEBUG
		    printf("id: %ld Buriedness: %ld DamageBury: %ld timeUpdated: %ld\n",
			   (long)target->id(), (long)target->buriedness(),
			   (long)target->property()->damageBury(),
			   (long)target->getTimeBuriednessUpdated());
		    fflush(NULL);
#endif
	       }
	  }
     }

     //////////////////////////////////////////////////////////////
     // ᡼ (ƿ̿װˤ)
     void MiscObjectPool::setDamages(S32 time){
#ifdef MISC_DEBUG_FUNC_NAME
	  printf("MiscObjectPool::setDamages(S32 time, Humanoid* mc){\n");
	  fflush(NULL);
#endif
	  setDamageBroken(time);
	  setDamageFiery(time);
	  setDamageBlock(time);  

#ifdef MISC_TMP
	  setDamageFieryRoad(time);
#endif
     }

     //////////////////////////////////////////////////////////////
     // Ȳݲˤ᡼
     void MiscObjectPool::setDamageBroken(S32 time){
#ifdef MISC_DEBUG_FUNC_NAME
	  printf("MiscObjectPool::setDamageBroken(S32 time){\n");
	  fflush(NULL);
#endif

	  for(int i = 0; i < ATTB_MAX; i++){
	       for(int j = 0; j < SEISMIC_MAX; j++){
		    for(int k = (int)BROKEN_25; k < BROKEN_MAX; k++){
			 MCivils mc = m_victimBroken[i][j][k];
			 S32 upper = mc.size();
			 if(upper > 0){
#ifdef MISC_DEBUG	  
			      printf("############ time                         = %ld\n", (long)time);
			      printf("############ getTimeDamageBrokenUpdated() = %ld\n", (long)mc[mc.size()-1]->property()->getTimeDamageBrokenUpdated());
			      fflush(NULL);
#endif

			      double rateDeath= prmt.rateDeathBroken[i][k][j];
			      double rateSerious = prmt.rateSeriousBroken[i][k][j];
			      double rateSlight = prmt.rateSlightBroken[i][k][j];
			      S32 expDeath = static_cast<S32>(m_indoor[i].size() * rateDeath);
			      S32 expSerious = static_cast<S32>(m_indoor[i].size() * rateSerious);
			      S32 expSlight = static_cast<S32>(m_indoor[i].size() * rateSlight);
			      S32 upper = mc.size();
#ifdef MISC_DEBUG
			      printf("m_indoor[%d].size() = %d\n", i, m_indoor[i].size());
			      printf("rateDeath = %f\n", rateDeath);
			      printf("rateSerious = %f\n", rateSerious);
			      printf("rateSlight = %f\n", rateSlight);
			      printf("expDeath = %ld\n", (long)expDeath);
			      printf("expSerious = %ld\n", (long)expSerious);
			      printf("expSlight = %ld\n", (long)expSlight);
			      printf("\n");
			      fflush(NULL);
#endif
			      // ʬ˴
			      int m;
			      for(m = 0; m< expDeath && m <= upper; ){
				   S32 order = dice.cast(0, mc.size() -1);
				   Humanoid* target = mc[order];
				   if(time + 1 > target->property()->getTimeDamageBrokenUpdated()){
					S32 damageBroken = cfg->damage_broken_death();
					// Civilianʳξ᡼Ψ򤫤
					damageBroken = magnificationDamageBroken(time, target, damageBroken);
					double oldDmg = target->property()->damageBroken();
					target->property()->setDamageBroken(time, (double)(oldDmg + damageBroken));
					m++;
				   }
			      }
			      // ʬŽ
			      for(m = 0; m < expSerious && m <= upper; ){
				   S32 order = dice.cast(0, mc.size() -1);
				   Humanoid* target = mc[order];
				   if(time + 1 > target->property()->getTimeDamageBrokenUpdated()){
					S32 damageBroken = cfg->damage_broken_serious();
					damageBroken = magnificationDamageBroken(time, target, damageBroken);
					double oldDmg = target->property()->damageBroken();
					target->property()->setDamageBroken(time, (double)(oldDmg + damageBroken));
					m++;
				   }
			      }
			      // ʬڽ
			      for(m = 0; m < expSlight && m <= upper; ){
				   S32 order = dice.cast(0, mc.size() -1);
				   Humanoid* target = mc[order];
				   if(time + 1 > target->property()->getTimeDamageBrokenUpdated()){
					S32 damageBroken = cfg->damage_broken_slight();
					damageBroken = magnificationDamageBroken(time, target, damageBroken);
					double oldDmg = target->property()->damageBroken();
					target->property()->setDamageBroken(time, (double)(oldDmg + damageBroken));
					m++;
				   }
			      }
			 }
		    }
	       }
	  }
     }

     //////////////////////////////////////////////////////////////
     // Civilian ʳΥȤΥ᡼Ψ򤫤
     S32 MiscObjectPool::magnificationDamageBroken(S32 time, Humanoid* h, S32 damage){

	  if(dynamic_cast<AmbulanceTeam*>(h) != 0)
	       damage = long(damage * cfg->magnification_damage_broken_ambulance());
	  if(dynamic_cast<PoliceForce*>(h) != 0)
	       damage = long(damage * cfg->magnification_damage_broken_police());
	  if(dynamic_cast<FireBrigade*>(h) != 0)
	       damage = long(damage * cfg->magnification_damage_broken_firebrigade());	  

	  return damage;
     }

     S32 MiscObjectPool::magnificationDamageFiery(S32 time, Humanoid* h, S32 damage){

	  if(dynamic_cast<AmbulanceTeam*>(h) != 0)
	       damage = long(damage * cfg->magnification_damage_fiery_ambulance());
	  if(dynamic_cast<PoliceForce*>(h) != 0)
	       damage = long(damage * cfg->magnification_damage_fiery_police());
	  if(dynamic_cast<FireBrigade*>(h) != 0)
	       damage = long(damage * cfg->magnification_damage_fiery_firebrigade());	  

	  return damage;
     }

     S32 MiscObjectPool::magnificationDamageBlock(S32 time, Humanoid* h, S32 damage){

	  if(dynamic_cast<AmbulanceTeam*>(h) != 0)
	       damage = long(damage * cfg->magnification_damage_block_ambulance());
	  if(dynamic_cast<PoliceForce*>(h) != 0)
	       damage = long(damage * cfg->magnification_damage_block_police());
	  if(dynamic_cast<FireBrigade*>(h) != 0)
	       damage = long(damage * cfg->magnification_damage_block_firebrigade());	  

	  return damage;
     }

     //////////////////////////////////////////////////////////////
     // ȲкҤˤ᡼
     // void MiscObjectPool::setDamageFiery(S32 time, Humanoid* mc){
     void MiscObjectPool::setDamageFiery(S32 time){
#ifdef MISC_DEBUG_FUNC_NAME
	  printf("MiscObjectPool::setDamageFiery(S32 time){\n");
	  fflush(NULL);
#endif
	  // ƤƤʪˤ륨Ȥ˥᡼Ϳ
	  MCivils::const_iterator it = m_inBuildingFiery.begin();
	  for(; it != m_inBuildingFiery.end(); it++){
	       Humanoid* mc = dynamic_cast<Humanoid*>(*it);
	       if(mc != 0 && mc->hp() > 0){
		    S32 damageFiery = cfg->damage_fiery_serious();
		    S32 mag = cfg->magnitude_dice();
		    mysrand(mc, time);  // by TM
		    long pip = dice.cast(1, mag);
		    long pip1 = long(cfg->prob_fiery_dying() * mag);
		    long pip2 = long(cfg->prob_fiery_dying() * mag + cfg->prob_fiery_serious() * mag);
		    long pip3 = long(cfg->prob_fiery_dying() * mag + cfg->prob_fiery_serious() * mag + cfg->prob_fiery_slight() * mag);
#ifdef MISC_DEBUG
		    printf("pip  (dice.cast(1, mag))               = %ld\n", pip);
		    printf("pip1 (cfg->prob_fiery_dying() * mag)   = %ld\n", pip1);
		    printf("pip2 (cfg->prob_fiery_serious() * mag) = %ld\n", pip2);
		    printf("pip1 (cfg->prob_fiery_slight() * mag)  = %ld\n", pip3);
		    printf("\n");
		    fflush(NULL);
#endif
		    // λ
		    if(pip >= 1 && pip <= pip1){
			 damageFiery = cfg->damage_fiery_dying();
		    }
		    // Ž
		    else if(pip > pip1 && pip <= pip2){
			 damageFiery = cfg->damage_fiery_serious();
		    }
		    // ڽ
		    else if(pip > pip2 && pip <= pip3){
			 damageFiery = cfg->damage_fiery_slight();
		    }
		    else{
			 damageFiery = cfg->damage_fiery_unhurt();;
		    }

		    // Civilianʳξ᡼Ψ򤫤
		    damageFiery = magnificationDamageFiery(time, mc, damageFiery);
		    double oldDmg = mc->property()->damageFiery();
		    mc->property()->setDamageFiery(time + 1 , (double)(oldDmg + damageFiery));
	       }
	  }
     }

     //////////////////////////////////////////////////////////////
     // TODO: ϩǤμϤβȲкҤˤ᡼
     void MiscObjectPool::setDamageFieryRoad(S32 time){
#ifdef MISC_DEBUG_FUNC_NAME
	  printf("MiscObjectPool::setDamageFieryRoad(S32 time){\n");
	  fflush(NULL);
#endif

     }

     //////////////////////////////////////////////////////////////
     // ƻϩĺɤˤ᡼
     void MiscObjectPool::setDamageBlock(S32 time){
#ifdef MISC_DEBUG_FUNC_NAME
	  printf("MiscObjectPool::setDamageBlock(S32 time){\n");
	  fflush(NULL);
#endif

	  if(m_onRoadBlock.size() == 0)
	       return;

#ifdef MISC_DEBUG
	  printf("*********** damage by block ***********\n");
	  fflush(NULL);
#endif
	  MCivils::const_iterator it = m_onRoadBlock.begin();
	  for(; it != m_onRoadBlock.end(); it++){
	       Humanoid* mc = dynamic_cast<Humanoid*>(*it);
	       if(mc != 0){
		    S32 damageBlock = cfg->damage_block_serious();
		    S32 mag = cfg->magnitude_dice();
		    long pip = dice.cast(1, mag);
		    long pip1 = long(cfg->prob_block_dying() * mag);
		    long pip2 = long(cfg->prob_block_dying() * mag + cfg->prob_block_serious() * mag);
		    long pip3 = long(cfg->prob_block_dying() * mag + cfg->prob_block_serious() * mag + cfg->prob_block_slight() * mag);
#ifdef MISC_DEBUG
		    printf("pip  (dice.cast(1, mag))               = %ld\n", pip);
		    printf("pip1 (cfg->prob_block_dying() * mag)   = %ld\n", pip1);
		    printf("pip2 (cfg->prob_block_serious() * mag) = %ld\n", pip2);
		    printf("pip1 (cfg->prob_block_slight() * mag)  = %ld\n", pip3);
		    printf("\n");
		    fflush(NULL);
#endif

		    // λ
		    if(pip >= 1 && pip <= pip1){
			 damageBlock = cfg->damage_block_dying();
		    }
		    // Ž
		    else if(pip > pip1 && pip <= pip2){
			 damageBlock = cfg->damage_block_serious();
		    }
		    // ڽ
		    else if(pip > pip2 && pip <= pip3){
			 damageBlock = cfg->damage_block_slight();
		    }
		    else{
			 damageBlock = cfg->damage_block_unhurt();;

		    }

		    // Civilianʳξ᡼Ψ򤫤
		    damageBlock = magnificationDamageBlock(time, mc, damageBlock);
		    double oldDmg = mc->property()->damageBlock();
		    mc->property()->setDamageBlock(time + 1 , (double)(oldDmg + damageBlock));
	       }
	  }
     }

     //////////////////////////////////////////////////////////////
     // ߥ졼ʹ (᡼ʹ)
     void MiscObjectPool::progressDamages(S32 time){
#ifdef MISC_DEBUG_FUNC_NAME
	  printf("void MiscObjectPool::progressDamages(S32 time){\n");
	  fflush(NULL);
#endif

#ifdef MISC_DEBUG
	  printf("m_agent.size() = %ld\n", (long)m_agent.size());
	  fflush(NULL);
#endif

#ifdef MISC_STATUS
	  printf("agnets damaged or buried are following... (hp > 0 only)\n");
	  printf("  id  |  hp  |damage| Bury |Broken|Fiery |Block |buriedness\n");
	  fflush(NULL);
#endif
	  MCivils::const_iterator it = m_agent.begin();
 	  for(; it != m_agent.end(); it++){
	       Humanoid* mc = dynamic_cast<Humanoid*>(*it);
	       Car* car = dynamic_cast<Car*>(*it);
	       if(mc != 0 && car == 0){
		    progressDamages(time, mc);
		    mergeDamages(time, mc);
		    updateHp(time, mc);
		    treatDamage(time, mc);
#ifdef MISC_STATUS
		    if((mc->damage() > 0 || mc->buriedness() > 0) && mc->hp() != 0){
			 m_injury.push_back(mc);
			 printf(" %5ld| %5ld| %5ld| %5ld| %5ld| %5ld| %5ld| %5ld\n", (long)mc->id(), (long)mc->hp(), (long)mc->damage(), (long)mc->property()->damageBury(), (long)mc->property()->damageBroken(), (long)mc->property()->damageFiery(), (long)mc->property()->damageBlock(), (long)mc->buriedness());
//			 printf("id %ld | hp %5ld | damage %5ld | Bury %5ld | Broken %5ld | Fiery %5ld | Block %5ld | buriedness %5ld\n", (long)mc->id(), (long)mc->hp(), (long)mc->damage(), (long)mc->property()->damageBury(), (long)mc->property()->damageBroken(), (long)mc->property()->damageFiery(), (long)mc->property()->damageBlock(), (long)mc->buriedness());
			 fflush(NULL);
		    }
#endif
	       }
	  }
#ifdef MISC_DEBUG
	  printf("m_death.size()            = %d\n", m_death.size());
	  printf("m_injury.size()          = %d\n", m_injury.size());
	  printf("m_inBuildingFiery.size() = %d\n", m_inBuildingFiery.size());
	  printf("m_onRoadBlock.size()     = %d\n", m_onRoadBlock.size());
	  printf("m_treatedInRefuge.size() = %d\n", m_treatedInRefuge.size());
	  printf("\n");
	  fflush(NULL);
#endif	  

     }
     //////////////////////////////////////////////////////////////
     // ᡼οʹ
     void MiscObjectPool::progressDamages(S32 time, Humanoid* mc){
#ifdef MISC_DEBUG_FUNC_NAME
	  printf("MiscObjectPool::progressDamage(S32 time, Humanoid* mc){\n");
	  fflush(NULL);
#endif

	  if(mc->hp() == 0 || mc->damage() == 0)
	       return;

	  // DamageBuryοʹ
	  progressDamageBury(time, mc);
	  // DamageBuryοʹ
	  progressDamageBroken(time, mc);
	  // DamageFieryοʹ
	  progressDamageFiery(time, mc);
	  // DamageBlockοʹ
	  progressDamageBlock(time, mc);
     }

     //////////////////////////////////////////////////////////////
     // ᡼οʹ DamageBury
     void MiscObjectPool::progressDamageBury(S32 time, Humanoid* mc){
#ifdef MISC_DEBUG_FUNC_NAME
	  printf("MiscObjectPool::progressDamageBury(S32 time, Humanoid* mc){\n");
	  fflush(NULL);
#endif
	  if(mc->hp() == 0 || mc->property()->damageBury() == 0)
	       return;

	  double k = cfg->parameter_damage_bury_k();
	  double l = cfg->parameter_damage_bury_l();

	  // damage ι
	  // TODO: ᡼ʹԤδؿη
	  //       餮 U(P) η
	  long mag = cfg->magnitude_dice();
	  mysrand(mc, time);  // by TM
	  long cast = dice.cast(1, mag);
	  double mutation = 0.0;
	  if(cast % 100 < 100 * cfg->probability_mutation_damage_bury()){
	       mutation = (double)cast / mag / 10;
	  }
	  ///////////////  ᡼ʹ  /////////////////////
	  double dmg = mc->property()->damageBury();
	  double newDamage = dmg + k * dmg * dmg + l + mutation;

 	  ////////////////////////////////////////////////////
	  if(newDamage > 10000)
	       newDamage = 10000.0;
	  mc->property()->setDamageBury(time+1, newDamage);
     }

     //////////////////////////////////////////////////////////////
     // ᡼οʹ DamageBroken
     void MiscObjectPool::progressDamageBroken(S32 time, Humanoid* mc){
#ifdef MISC_DEBUG_FUNC_NAME
	  printf("MiscObjectPool::progressDamageBroken(S32 time, Humanoid* mc){\n");
	  fflush(NULL);
#endif
	  if(mc->hp() == 0 || mc->property()->damageBroken() == 0)
	       return;

	  double k = cfg->parameter_damage_broken_k();
	  double l = cfg->parameter_damage_broken_l();

	  // damage ι
	  // TODO: ᡼ʹԤδؿη
	  //       餮 U(P) η
	  long mag = cfg->magnitude_dice();
	  mysrand(mc, time);  // by TM
	  long cast = dice.cast(1, mag);
	  double mutation = 0.0;
	  if(cast % 100 < 100 * cfg->probability_mutation_damage_broken()){
	       mutation = (double)cast / mag / 10;
	  }
	  ///////////////  ᡼ʹ  /////////////////////
	  double dmg = mc->property()->damageBroken();
	  double newDamage = dmg + k * dmg * dmg + l + mutation;

	  ////////////////////////////////////////////////////
	  if(newDamage > 10000)
	       newDamage = 10000.0;
	  mc->property()->setDamageBroken(time+1, newDamage);
     }

     //////////////////////////////////////////////////////////////
     // ᡼οʹ DamageFiery
     void MiscObjectPool::progressDamageFiery(S32 time, Humanoid* mc){
#ifdef MISC_DEBUG_FUNC_NAME
	  printf("MiscObjectPool::progressDamageFiery(S32 time, Humanoid* mc){\n");
	  fflush(NULL);
#endif
	  if(mc->hp() == 0 || mc->property()->damageFiery() == 0)
	       return;
	  
	  double k = cfg->parameter_damage_fiery_k();
	  double l = cfg->parameter_damage_fiery_l();

	  // damage ι
	  // TODO: ᡼ʹԤδؿη
	  //       餮 U(P) η
	  long mag = cfg->magnitude_dice();
	  mysrand(mc, time);  // by TM
	  long cast = dice.cast(1, mag);
	  double mutation = 0.0;
	  if(cast % 100 < 100 * cfg->probability_mutation_damage_fiery()){
	       mutation = (double)cast / mag / 10;
	  }
	  ///////////////  ᡼ʹ  /////////////////////
	  double dmg = mc->property()->damageFiery();
	  double newDamage = dmg + k * dmg * dmg + l + mutation;

	  ////////////////////////////////////////////////////
	  if(newDamage > 10000)
	       newDamage = 10000.0;
	  mc->property()->setDamageFiery(time+1, newDamage);
     }

     void MiscObjectPool::progressDamageBlock(S32 time, Humanoid* mc){
#ifdef MISC_DEBUG_FUNC_NAME
	  printf("MiscObjectPool::progressDamageBlock(S32 time, Humanoid* mc){\n");
	  fflush(NULL);
#endif
	  if(mc->hp() == 0 || mc->property()->damageBlock() == 0)
	       return;
	  
	  double k = cfg->parameter_damage_block_k();
	  double l = cfg->parameter_damage_block_l();

	  // damage ι
	  // TODO: ᡼ʹԤδؿη
	  //       餮 U(P) η
	  long mag = cfg->magnitude_dice();
	  mysrand(mc, time);  // by TM
	  long cast = dice.cast(1, mag);
	  double mutation = 0.0;
	  if(cast % 100 < 100 * cfg->probability_mutation_damage_block()){
	       mutation = (double)cast / mag / 10;
	  }
	  ///////////////  ᡼ʹ  /////////////////////
	  double dmg = mc->property()->damageBlock();
	  double newDamage = dmg + k * dmg * dmg + l + mutation;

	  ////////////////////////////////////////////////////
	  if(newDamage > 10000)
	       newDamage = 10000.0;
	  mc->property()->setDamageBlock(time+1, newDamage);
     }

     //////////////////////////////////////////////////////////////
     // ᡼Υޡ
     void MiscObjectPool::mergeDamages(S32 time, Humanoid* mc){
#ifdef MISC_DEBUG_FUNC_NAME
	  printf("MiscObjectPool::mergeDamages(S32 time, Humanoid* mc){\n");
	  fflush(NULL);
#endif
	  double dmg = 0.0;
	  dmg += mc->property()->damageBury();
	  dmg += mc->property()->damageBroken();
	  dmg += mc->property()->damageFiery();
	  dmg += mc->property()->damageBlock();
	  mc->property()->setDamage(time+1, dmg);
	  mc->setDamage(time+1, (long)floor(dmg));
     }

     //////////////////////////////////////////////////////////////
     // Hp ι
     void MiscObjectPool::updateHp(S32 time, Humanoid* mc){
#ifdef MISC_DEBUG_FUNC_NAME
	  printf("MiscObjectPool::updateHp(S32 time, Humanoid* mc){\n");
	  fflush(NULL);
#endif
	  if(mc->hp() > 0){
	       S32 newDamage = mc->damage();
	       S32 newHp = mc->hp() - newDamage;
	       if(newHp <= 0){
		    newHp = 0;
		    m_death.push_back(mc);
	       }

	       mc->setHp(time+1, newHp);
	  }
     }

     //////////////////////////////////////////////////////////////
     // ᡼μ
     //       Refuge ä damage  0 ˤ
     void MiscObjectPool::treatDamage(S32 time, Humanoid* mc){
#ifdef MISC_DEBUG_FUNC_NAME
	  printf("MiscObjectPool::treatDamage(S32 time, Humanoid* mc){\n");
	  fflush(NULL);
#endif
	  if(mc->hp() > 0 && mc->damage() > 0){
	       if(dynamic_cast<Refuge*>(mc->position()) != 0){
		    mc->property()->setDamageBroken(time+1, 0);
		    mc->property()->setDamageBury(time+1, 0);
		    mc->property()->setDamageFiery(time+1, 0);
		    mc->property()->setDamageBlock(time+1, 0);
		    mc->setDamage(time+1, 0);
		    if(dynamic_cast<Civilian*>(mc) != 0)
			 m_treatedInRefuge.push_back(mc);
	       }
	  }
     }
     /////////////////////////////////////////////////////////////////////////
} // namespace Rescue
