// LongUDPSocket.cxx
//
/////////////////////////////////////////////////////////////////////////////

#include "common.hxx"
#include "LongUDPSocket.hxx"

#ifndef NDEBUG
#  include "LongUDPSocket.inl"
#endif

namespace Rescue
{
	/////////////////////////////////////////////////////////////////////////
	// LongUDPSocket
	
	LongUDPSocket::~LongUDPSocket()
	{
		if(m_fp)
			fclose(m_fp);
	}

	void LongUDPSocket::eat(/*non-const*/ bool block) const
	{
		while(block || !m_socket.empty()) {
			if(m_booksIncomplete.size() > 0xFF) {	// TODO: ե뤫ɤ߹
				Books::iterator it = m_booksIncomplete.end();
				m_booksIncomplete.erase(--it);
			}

			AutoPtr<Page> f(new Page(m_sizeReceiveBuffer));
			int tmp = m_socket.receive(f->m_buffer, f->m_capacity);
			if(tmp >= 0) {
				if(tmp < 2 || tmp < f->m_buffer[1])
					continue;
				f->m_size = tmp - f->m_buffer[1];
			} else {
				if(tmp == -2)
					m_sizeReceiveBuffer += 1024;
				continue;
			}

			ASSERT(f->m_buffer[0] == 0);
			S16 id = (S16)((f->m_buffer[2] << 8) | f->m_buffer[3]);
			S16 segment = (S16)((f->m_buffer[4] << 8) | f->m_buffer[5]);
			S16 total = (S16)((f->m_buffer[6] << 8) | f->m_buffer[7]);
			
			/*if(total == 1) {
				input.reset(f);
				m_addressRecievedFrom = m_socket.addressRecievedFrom();
				return true;
			}*/
			
			Books::iterator it = m_booksIncomplete.begin();
			for(; it != m_booksIncomplete.end(); it++) {
				Book* p = it->get();
				if(p->from == m_socket.addressRecievedFrom() && p->id == id)
					break;
			}
			if(it == m_booksIncomplete.end()) {
				AutoPtr<Book> p(new Book(total));
				p->from = m_socket.addressRecievedFrom();
				p->id = id;
				//p->frames[segment] = f;
				m_booksIncomplete.push_front(p);
				it = m_booksIncomplete.begin();
			} 

			{
				AutoPtr<Book> p = *it;
				m_booksIncomplete.erase(it);
				p->pages[segment] = f;
				Pages::iterator it;
#if 1
				if(total > 100) {
					it = p->pages.begin();
					int tmp = 0, start = -1, last = -1;
					for(; it != p->pages.end(); it++, tmp++) {
						if(it->get() != 0) {
							if(start == -1)
								start = tmp;
							last = tmp;
						} else {
							if(start != -1) {
								if(start == last)
									printf("%d ", start);
								else
									printf("%d-%d ", start, last);
								start = -1;
							}
						}
					}
					if(start != -1) {
						if(start == 0 && last == total-1)
							printf("all");
						else if(start == last)
							printf("%d ", start);
						else
							printf("%d-%d ", start, last);
					}
					printf("/%d\n", (int)total);
				}
#endif			
				it = p->pages.begin();
				for(; it != p->pages.end(); it++) {
					if(it->get() == 0)
						break;
				}
				if(it != p->pages.end()) {
					m_booksIncomplete.push_front(p);
				} else {
					m_booksComplete.push_back(p);
					block = false;
				}
			}
		}
	}

	int LongUDPSocket::wait(const std::vector<const LongUDPSocket*>& sockets, int ms)
	{
		typedef std::vector<const LongUDPSocket*> Sockets;
		typedef std::vector<const UDPSocket*> UDPSockets;
		UDPSockets us;
		Sockets::const_iterator it = sockets.begin();
		for(; it != sockets.end(); it++) {
			const LongUDPSocket* socket = *it;
			if(!socket->empty())
				return true;
			us.push_back(&socket->m_socket);
		}

		for(;;) {
			int count = UDPSocket::wait(us, ms);
			if(count == 0)
				return false;
			
			it = sockets.begin();
			for(; it != sockets.end(); it++) {
				const LongUDPSocket* socket = *it;
				if(!socket->empty())
					return true;
			}
		}
	}

	/////////////////////////////////////////////////////////////////////////
} // namespace Rescue
