// ObjectPool.inl
//
/////////////////////////////////////////////////////////////////////////////

#ifdef NDEBUG
//#  include
#endif
#include "objects.hxx"

#ifndef NDEBUG
#  define inline
#else
#  define inline inline
#endif

namespace Rescue
{
	/////////////////////////////////////////////////////////////////////////
	// ObjectPool
	
	inline ObjectPool::ObjectPool()
	{
		m_lastId = 0;
	}
	inline void ObjectPool::add(Object* newObject)
	{
		Id id = newObject->id();
		ASSERT(id > 0);
		ASSERT(m_idToObjects.find(id) == m_idToObjects.end());
		m_idToObjects[id] = AutoPtr<Object>(newObject);
		m_objects.push_back(newObject);
	}
	inline Object* ObjectPool::get(Id id)
	{
		Map::const_iterator it = m_idToObjects.find(id);
		if(it != m_idToObjects.end())
			return it->second.get();
		else
			return 0;
	}
	
	inline const Objects& ObjectPool::objects() const
	{
		return m_objects;
	}

	inline void ObjectPool::output(Output& output, S32 time)
	{
		Objects::const_iterator it = objects().begin();
		for(; it != objects().end(); it++) {
			const Object& object = **it;
			object.outputObject(output, time);
		}
		output.put(TYPE_NULL);
	}
	inline void ObjectPool::output(Output& output)
	{
		Objects::const_iterator it = objects().begin();
		for(; it != objects().end(); it++) {
			const Object& object = **it;
			object.outputObject(output);
		}
		output.put(TYPE_NULL);
	}

	inline Id ObjectPool::testAdd(Object* newObject)
	{
		Id id = ++m_lastId;
		if(id >= 0x70000000) {
			ASSERT(false);
			exit(1);
		}
		newObject->setId(id);
		ASSERT(m_idToObjects.find(id) == m_idToObjects.end());
		m_idToObjects[id] = AutoPtr<Object>(newObject);
		m_objects.push_back(newObject);
		return id;
	}

	/*inline ObjectPool::ObjectPool(const ObjectPool& source)
	{
		ObjectPool();
		operator= (source);
	}
	inline ObjectPool& ObjectPool::operator= (const ObjectPool& rhs)
	{
		if(this == &rhs)
			return *this;
		return *this;
	}
	inline bool ObjectPool::operator== (const ObjectPool& rhs) const
	{
		if(this == &rhs)
			return true;
	}*/

	/////////////////////////////////////////////////////////////////////////
} // namespace Rescue
#undef inline
