// Address.cxx
//
/////////////////////////////////////////////////////////////////////////////

#include "common.hxx"
#include "Address.hxx"
#include "SocketLibrary.hxx"

#ifndef NDEBUG
#  include "Address.inl"
#endif

namespace Rescue
{
	/////////////////////////////////////////////////////////////////////////
	// Address
	
	Address::~Address()
	{
	}

	Address::Address(const char* name, int port)
	{
		initializeSocketLibrary();

		u_long address = inet_addr(name);
		if(address == INADDR_NONE) {
			hostent* he = gethostbyname(name);
			if(he) {
				//result = htonl(*(unsigned long*)he->h_addr); ???
				in_addr* pia = (struct in_addr*)*(he->h_addr_list);
				const char* ia = inet_ntoa(*pia) ;
				if(ia)
					address = inet_addr(ia);
			}
		}
		if(address == INADDR_NONE) {
			throw IllegalHost(name);
		}
		
		m_address = address;
		m_port = htons((u_short)port);
		m_isValid = true;
	}
	
	
	/////////////////////////////////////////////////////////////////////////
} // namespace Rescue
