
#include "common.hxx"
#include "basic.hxx"
#include "Config.hxx"
#include "Address.hxx"
#include "Input.hxx"
#include "Output.hxx"
#include "LongUDPSocket.hxx"
#include "ObjectPool.hxx"
#include "objects.hxx"
using namespace Rescue;

// by koto
int fread2(S32* buffer, int size, int count, FILE* fp) {
    ASSERT(size == sizeof(S32) && count == 1);
    
    Byte b1;
    if(fread(&b1, sizeof(Byte), 1, fp) != 1)
        return 0;
    Byte b2;
    if(fread(&b2, sizeof(Byte), 1, fp) != 1)
        return 0;
    Byte b3;
    if(fread(&b3, sizeof(Byte), 1, fp) != 1)
        return 0;
    Byte b4;
    if(fread(&b4, sizeof(Byte), 1, fp) != 1)
        return 0;
    
    *buffer = (S32)b1 | ((S32)b2 << 8) | ((S32)b3 << 16) | ((S32)b4 << 24);
    return 1;
}
//

// created by M.H
// modified by M.H 2000.8.24
int DetPositions( std::vector<S32> * pEntities, S32 nRecCount, S32 nAllRecCount) {
    S32     loop2, nCntRec, tmp;
    bool    bFlag;

    srand( (unsigned)time( NULL ) );
    pEntities->clear();

    nCntRec = 0;
    while(nCntRec<nRecCount){
        tmp = (S32)rand() % nAllRecCount;
        bFlag = false;
        for (loop2=0; loop2<nCntRec; loop2++){
            if (tmp == (*pEntities)[loop2])
                bFlag = true;
        }
        if (bFlag != true){
            pEntities->push_back(tmp);
            nCntRec++;
        }
    }

    return 1;
}

// created by M.H 2001/04/14
void ChangeDelimiter( char *pBuf, char delimiter) {
    while(*pBuf != '\0') {
        if(*pBuf == delimiter) *pBuf = ' ';
        pBuf++;
    }
    return;
}
//

int main2(int argc, char** argv);
void makeWorld(ObjectPool& pool, int number, const char* mapdir, const char* gisini);

int main(int argc, char** argv)
{
    try {
        return main2(argc, argv);
    } catch(std::exception& e) {
        fprintf(stderr, "%s\n", (const char*)e.what());
    } catch(...) {
        fprintf(stderr, "error...\n");
    }
    return 1;
}

int main2(int argc, char** argv)
{
    const char* host = "localhost";
    Config config;
    int number = 50;
    const char* mapdir = "";
    const char* gisini = "gisini.txt";

    // 
    int i;
    for(i=1; i<argc; i++) {
        if(argv[i][0] == '-') {
            if(strcmp(argv[i], "-file") == 0) {
                if(++i < argc) {
                    config.readConfigFile(argv[i]);
                } else {
                    fprintf(stderr, "error: '-file'\n");
                }
            } else if(strcmp(argv[i], "-n") == 0) {
                if(++i < argc) {
                    number = atoi(argv[i]);
                } else {
                    fprintf(stderr, "error: '-n'\n");
                }
            } else if(strcmp(argv[i], "-mapdir") == 0) {
                if(++i < argc) {
                    mapdir = argv[i];
                } else {
                    fprintf(stderr, "error: '-mapdir'\n");
                }
            } else if(strcmp(argv[i], "-gisini") == 0) {
                if(++i < argc) {
                    gisini = argv[i];
                } else {
                    fprintf(stderr, "error: '-gisini'\n");
                }
            } else {
                if(++i < argc) {
                    if(!config.setValue(argv[i-1]+1, argv[i]))
                        fprintf(stderr, "error: '%s'\n", argv[i]);
                } else {
                    fprintf(stderr, "error: '%s'\n", argv[i-1]);
                }
            }
        } else {
            fprintf(stderr, "error: '%s'\n", argv[i]);
        }
    }

    // åȺ
    Address address = Address(INADDR_ANY, config.gis_port(), true);
    LongUDPSocket socket(address, config.textlogname_gis());
    Input input;
    Output output;
    output.setWait(config.send_udp_wait());
    Address to(host, config.port());    //

    printf("start\n");

    // å롼
    S32 time = 0;
    ObjectPool pool;
    makeWorld(pool, number, mapdir, gisini);
    for(;;) {
        try {
            socket.receive(input);  // TODO: 顼㳰֤ //ǡinput ߤ롣
            for(;;) {
                Header header = input.get();    //input (4ХȤ)ǡФheader 
                if(header == HEADER_NULL)
                    break;

                S32 size = input.get();
                Input::Cursor start = input.cursor();   //ɤ߽ФƤ֤򵭲

                switch(header) {
                default:
                    printf("Unknown header. %lx\n", (long)header);
                    break;
                case KG_CONNECT:
                    printf("KG_CONNECT\n");
                    to = socket.addressRecievedFrom();
                    output.clear();
                    output.put(GK_CONNECT_OK);
                    output.put(~(S32)0);
                    pool.output(output, 0);
                    output.put(HEADER_NULL);
                    socket.send(output, to);
                    break;
                case KG_ACKNOWLEDGE:
                    printf("KG_ACKNOWLEDGE\n");
                    break;
                case KG_UPDATE:
                    printf("KG_UPDATE\n");
                    time = input.get();
                    pool.restructure(time, input);
                    break;
                }

                input.setCursor(start);
                input.skip(size);                       //size Хȥåפ
            }
        } catch(std::exception& e) {
            fprintf(stderr, "%s\n", (const char*)e.what());
        } catch(...) {
            fprintf(stderr, "error...\n");
        }
    }
    
    return 0;
}

// GIS by M.Hatayama
// modified by M.H 2000.8.24
// modified by M.H 2001.4.14
void makeWorld(ObjectPool& pool, int number, const char* mapdir, const char* gisini)
{
    char        filename[9999];
    FILE *      fpTxt;
    FILE *      fpRoad;
    FILE *      fpNode;
    FILE *      fpBuilding;
    int         result;
    S32         nCntRec, nCntRec2;
    S32         tmp, loop1, loop2, tmp_byte;
    S32         cntBA, cntBP, cntBF, cntBR, cntB;
    S32         nCntRoad, nCntNode, nCntAllBuilding, nCntBuilding;
    S32         nCntAmbulanceCenter, nCntPoliceOffice, nCntFireStation, nCntRefuge;
    S32         nCntCivilian, nAmbulanceTeam, nCntFireBrigade, nCntPoliceForce;
    S32         nCntCivilianN, nAmbulanceTeamN, nCntFireBrigadeN, nCntPoliceForceN;
    S32         nCntCivilianB, nAmbulanceTeamB, nCntFireBrigadeB, nCntPoliceForceB;
    S32         nCntCivilianR, nAmbulanceTeamR, nCntFireBrigadeR, nCntPoliceForceR;
    S32         nCntFirePoint;

    World *     pWorld;
    Road *      pRoad;
    Node *      pNode;
    Building *  pAllBuilding;
    Building *  pBuilding;
    Building *  pAmbulanceCenter;
    Building *  pPoliceOffice;
    Building *  pFireStation;
    Building *  pRefuge;

    Bytes       bytes;

    int         n;
    int         data[9];
    const int   size = 1024;
    char        buffer[size];
    
    bool        bIniFileF;
    int         AllListOutput;
    
    S32                 CivilianRatio = 20;
    S32                 start, end;
    std::vector<S32>    attTmp;
    std::vector<S32>    FirePointIDs;
    std::vector<S32>    FirePointIDs2;
    std::vector<S32>    MotionlessObj[4];
    std::vector<S32>    MotionlessObj2[4];
    std::vector<S32>    MoveObjN[4];
    std::vector<S32>    MoveObjB[4];
    std::vector<S32>    MoveObjRs[4];
    std::vector<S32>    MoveObjRe[4];
    std::vector<S32>    MoveObjRl[4];
    std::vector<S32>    MoveObjR[4];
    std::vector<S32>    MoveObjN2[4];
    std::vector<S32>    MoveObjB2[4];
    std::vector<S32>    MoveObjR2[4];

    //init Cnt
    nCntAmbulanceCenter = nCntPoliceOffice = nCntFireStation = nCntRefuge = 0;
    nCntCivilian = nAmbulanceTeam = nCntFireBrigade = nCntPoliceForce = 0;
    nCntFirePoint = 0;

    //world data
    pWorld = new World;
    pool.testAdd( pWorld );

    //load road data
    strcpy(filename, mapdir);
    strcat(filename, "road.bin");
    if( (fpRoad = fopen(filename, "r"FOPEN_MODE_BINARY) ) == NULL){
        printf("cannot find file --- %s\n", filename);
        return;
    }
    result = fseek( fpRoad, 0L, SEEK_SET);
    result = fseek( fpRoad, sizeof( S32 )*3, SEEK_CUR);
    result = fread2( &nCntRoad, sizeof( S32 ), 1, fpRoad );

    //load noad data
    strcpy(filename, mapdir);
    strcat(filename, "node.bin");
    if( (fpNode = fopen(filename, "r"FOPEN_MODE_BINARY) ) == NULL){
        printf("cannot find file --- %s\n", filename);
        fclose(fpRoad);
        return;
    }
    result = fseek( fpNode, 0L, SEEK_SET);
    result = fseek( fpNode, sizeof( S32 )*3, SEEK_CUR);
    result = fread2( &nCntNode, sizeof( S32 ), 1, fpNode );

    //load building data
    strcpy(filename, mapdir);
    strcat(filename, "building.bin");
    if( (fpBuilding = fopen(filename, "r"FOPEN_MODE_BINARY) ) == NULL){
        printf("cannot find file --- %s\n", filename);
        fclose(fpRoad);
        fclose(fpNode);
        return;
    }
    result = fseek( fpBuilding, 0L, SEEK_SET);
    result = fseek( fpBuilding, sizeof( S32 )*3, SEEK_CUR);
    result = fread2( &nCntAllBuilding, sizeof( S32 ), 1, fpBuilding );

    //load initial data
    char name1[size];
    char name2[size];

    if( (fpTxt = fopen(gisini, "r"FOPEN_MODE_TEXT) ) == NULL){
        printf("%s not found.  initialized randomly.\n", gisini);
        bIniFileF = false;
        AllListOutput = 0;

        nCntAmbulanceCenter = nCntPoliceOffice = nCntFireStation = 1;
        nCntRefuge = 4;
        nCntFirePoint = 5;

        DetPositions(&attTmp, nCntAmbulanceCenter+nCntPoliceOffice+nCntFireStation+nCntRefuge, nCntAllBuilding);

        start = 0;
        end = nCntAmbulanceCenter;
        for (loop2=start; loop2<end; loop2++)
            MotionlessObj2[0].push_back(attTmp[loop2]);

        start = end;
        end = start + nCntFireStation;
        for (loop2=start; loop2<end; loop2++)
            MotionlessObj2[1].push_back(attTmp[loop2]);

        start = end;
        end = start + nCntPoliceOffice;
        for (loop2=start; loop2<end; loop2++)
            MotionlessObj2[2].push_back(attTmp[loop2]);

        start = end;
        end = start + nCntRefuge;
        for (loop2=start; loop2<end; loop2++)
            MotionlessObj2[3].push_back(attTmp[loop2]);

        DetPositions(&FirePointIDs2, nCntFirePoint, nCntAllBuilding);

        nCntBuilding = nCntAllBuilding - nCntRefuge - nCntAmbulanceCenter - nCntPoliceOffice - nCntFireStation;

        if ( nCntBuilding / CivilianRatio == 0 ){
            nCntCivilian = nCntCivilianB = 1;
            nCntCivilianR = 0;
            nCntCivilianN = 0;
        }
        else {
            nCntCivilian = 2* ( nCntBuilding / CivilianRatio );
            nCntCivilianB = nCntCivilian * 19 / 20;
            nCntCivilianR = ( nCntCivilian - nCntCivilianB ) / 2;
            nCntCivilianN = nCntCivilian - nCntCivilianB - nCntCivilianR;
        }
        DetPositions(&MoveObjN2[0], nCntCivilianN, nCntNode);
        DetPositions(&MoveObjB2[0], nCntCivilianB, nCntBuilding);
        DetPositions(&MoveObjR2[0], nCntCivilianR, nCntRoad);
    
        if ( nCntNode/50 == 0 ){
            nAmbulanceTeamB = 0;
            nAmbulanceTeamR = 0;
            nAmbulanceTeamN = 1;
        }
        else if ( nCntNode / 50 > 5 ){
            nAmbulanceTeamB = 0;
            nAmbulanceTeamR = 0;
            nAmbulanceTeamN = 5;
        }
        else{
            nAmbulanceTeamB = 0;
            nAmbulanceTeamR = 0;
            nAmbulanceTeamN = nCntNode / 50;
        }

        DetPositions(&MoveObjN2[1], nAmbulanceTeamN, nCntNode);
        DetPositions(&MoveObjB2[1], nAmbulanceTeamB, nCntBuilding);
        DetPositions(&MoveObjR2[1], nAmbulanceTeamR, nCntRoad);

        if ( nCntNode / 50 == 0 ){
            nCntFireBrigadeN = 1;
            nCntFireBrigadeB = 0;
            nCntFireBrigadeR = 0;
        }
        else if ( nCntNode / 50 > 10 ){
            nCntFireBrigadeN = 10;
            nCntFireBrigadeB = 0;
            nCntFireBrigadeR = 0;
        }
        else{
            nCntFireBrigadeN = nCntNode / 50;
            nCntFireBrigadeB = 0;
            nCntFireBrigadeR = 0;
        }

        DetPositions(&MoveObjN2[2], nCntFireBrigadeN, nCntNode);
        DetPositions(&MoveObjB2[2], nCntFireBrigadeB, nCntBuilding);
        DetPositions(&MoveObjR2[2], nCntFireBrigadeR, nCntRoad);

        if ( nCntNode / 50 == 0 ){
            nCntPoliceForceN = 0;
            nCntPoliceForceB = 0;
            nCntPoliceForceR = 1;
        }
        else if ( nCntNode / 50 > 10 ){
            nCntPoliceForceN = 0;
            nCntPoliceForceB = 0;
            nCntPoliceForceR = 10;
        }
        else{
            nCntPoliceForceN = 0;
            nCntPoliceForceB = 0;
            nCntPoliceForceR = nCntNode / 50;
        }

        DetPositions(&MoveObjN2[3], nCntPoliceForceN, nCntNode);
        DetPositions(&MoveObjB2[3], nCntPoliceForceB, nCntBuilding);
        DetPositions(&MoveObjR2[3], nCntPoliceForceR, nCntRoad);

        nCntCivilian = nCntCivilianN + nCntCivilianB + nCntCivilianR;
        nAmbulanceTeam = nAmbulanceTeamN + nAmbulanceTeamB + nAmbulanceTeamR;
        nCntFireBrigade = nCntFireBrigadeN + nCntFireBrigadeB + nCntFireBrigadeR;
        nCntPoliceForce = nCntPoliceForceN + nCntPoliceForceB + nCntPoliceForceR;
    }
    else {
        bIniFileF = true;

        nCntCivilianN = nAmbulanceTeamN = nCntFireBrigadeN = nCntPoliceForceN = 0;
        nCntCivilianB = nAmbulanceTeamB = nCntFireBrigadeB = nCntPoliceForceB = 0;
        nCntCivilianR = nAmbulanceTeamR = nCntFireBrigadeR = nCntPoliceForceR = 0;

        while(fgets(buffer, size, fpTxt) != NULL) {
            if (buffer[0] == '#' || buffer[0] == '\n')  continue;

            char *p = buffer;
            while(*p != '\0') {
                if(*p == ':') *p = ' ';
                if(*p == '=') *p = ' ';
                p++;
            }
            n = sscanf(buffer, "%s %s", name1, name2);
            if(n == 2) {
//              if ( strcmp( name1, "AllListOutput") == 0 )
//                  AllListOutput = atoi(name2);

                if ( strcmp( name1, "AmbulanceCenterNum") == 0 )
                    nCntAmbulanceCenter = atol(name2);

                for (loop1=0; loop1<nCntAmbulanceCenter; loop1++ ){
                    sprintf( buffer, "AmbulanceCenter%ld", loop1 );
                    if ( strcmp( name1, buffer) == 0 ){
                        ChangeDelimiter(name2, ',');
                        n = sscanf(name2, "%ld %ld %ld %ld %ld", 
                                        &data[0], &data[1], &data[2], &data[3], &data[4]);
                        MotionlessObj[0].push_back(data[2]);
                    }
                }

                if ( strcmp( name1, "FireStationNum") == 0 )
                    nCntFireStation = atol(name2);

                for (loop1=0; loop1<nCntFireStation; loop1++ ){
                    sprintf( buffer, "FireStation%ld", loop1 );
                    if ( strcmp( name1, buffer) == 0 ){
                        ChangeDelimiter(name2, ',');
                        n = sscanf(name2, "%ld %ld %ld %ld %ld", 
                                        &data[0], &data[1], &data[2], &data[3], &data[4]);
                        MotionlessObj[1].push_back(data[2]);
                    }
                }

                if ( strcmp( name1, "PoliceOfficeNum") == 0 )
                    nCntPoliceOffice = atol(name2);

                for (loop1=0; loop1<nCntPoliceOffice; loop1++ ){
                    sprintf( buffer, "PoliceOffice%ld", loop1 );
                    if ( strcmp( name1, buffer) == 0 ){
                        ChangeDelimiter(name2, ',');
                        n = sscanf(name2, "%ld %ld %ld %ld %ld", 
                                        &data[0], &data[1], &data[2], &data[3], &data[4]);
                        MotionlessObj[2].push_back(data[2]);
                    }
                }

                if ( strcmp( name1, "RefugeNum") == 0 )
                    nCntRefuge = atol(name2);

                for (loop1=0; loop1<nCntRefuge; loop1++ ){
                    sprintf( buffer, "Refuge%ld", loop1 );
                    if ( strcmp( name1, buffer) == 0 ){
                        ChangeDelimiter(name2, ',');
                        n = sscanf(name2, "%ld %ld %ld %ld %ld", 
                                        &data[0], &data[1], &data[2], &data[3], &data[4]);
                        MotionlessObj[3].push_back(data[2]);
                    }
                }

                if ( strcmp( name1, "CivilianNum") == 0 )
                    nCntCivilian = atol(name2);

                for (loop1=0; loop1<nCntCivilian; loop1++ ){
                    sprintf( buffer, "Civilian%ld", loop1 );
                    if ( strcmp( name1, buffer) == 0 ){
                        ChangeDelimiter(name2, ',');
                        n = sscanf(name2, "%ld %ld %ld %ld %ld %ld %ld %ld %ld", 
                                        &data[0], &data[1], &data[2], &data[3], &data[4],
                                        &data[5], &data[6], &data[7], &data[8]);
                        if ( data[1] == 0 ){ 
                            MoveObjN[0].push_back(data[2]);
                            nCntCivilianN += 1;
                        }
                        else if ( data[1] == 1 ) {
                            MoveObjB[0].push_back(data[2]);
                            nCntCivilianB += 1;
                        }
                        else if ( data[1] == 2 ){ 
                            MoveObjRs[0].push_back(data[2]);
                            MoveObjRe[0].push_back(data[5]);
                            MoveObjRl[0].push_back(data[8] * 1000); //[m]->[mm]
                            nCntCivilianR += 1;
                        }
                    }
                }

                if ( strcmp( name1, "AmbulanceTeamNum") == 0 )
                    nAmbulanceTeam = atol(name2);

                for (loop1=0; loop1<nAmbulanceTeam; loop1++ ){
                    sprintf( buffer, "AmbulanceTeam%ld", loop1 );
                    if ( strcmp( name1, buffer) == 0 ){
                        ChangeDelimiter(name2, ',');
                        n = sscanf(name2, "%ld %ld %ld %ld %ld %ld %ld %ld %ld", 
                                        &data[0], &data[1], &data[2], &data[3], &data[4],
                                        &data[5], &data[6], &data[7], &data[8]);
                        if ( data[1] == 0 ) {
                            MoveObjN[1].push_back(data[2]);
                            nAmbulanceTeamN += 1;
                        }
                        else if ( data[1] == 1 ) {
                            MoveObjB[1].push_back(data[2]);
                            nAmbulanceTeamB += 1;
                        }
                        else if ( data[1] == 2 ){ 
                            MoveObjRs[1].push_back(data[2]);
                            MoveObjRe[1].push_back(data[5]);
                            MoveObjRl[1].push_back(data[8] * 1000); //[m]->[mm]
                            nAmbulanceTeamR += 1;
                        }
                    }
                }

                if ( strcmp( name1, "FireBrigadeNum") == 0 )
                    nCntFireBrigade = atol(name2);

                for (loop1=0; loop1<nCntFireBrigade; loop1++ ){
                    sprintf( buffer, "FireBrigade%ld", loop1 );
                    if ( strcmp( name1, buffer) == 0 ){
                        ChangeDelimiter(name2, ',');
                        n = sscanf(name2, "%ld %ld %ld %ld %ld %ld %ld %ld %ld", 
                                        &data[0], &data[1], &data[2], &data[3], &data[4],
                                        &data[5], &data[6], &data[7], &data[8]);
                        if ( data[1] == 0 ) {
                            MoveObjN[2].push_back(data[2]);
                            nCntFireBrigadeN += 1;
                        }
                        else if ( data[1] == 1 ) {
                            MoveObjB[2].push_back(data[2]);
                            nCntFireBrigadeB += 1;
                        }
                        else if ( data[1] == 2 ){ 
                            MoveObjRs[2].push_back(data[2]);
                            MoveObjRe[2].push_back(data[5]);
                            MoveObjRl[2].push_back(data[8] * 1000); //[m]->[mm]
                            nCntFireBrigadeR += 1;
                        }
                    }
                }

                if ( strcmp( name1, "PoliceForceNum") == 0 )
                    nCntPoliceForce = atol(name2);

                for (loop1=0; loop1<nCntPoliceForce; loop1++ ){
                    sprintf( buffer, "PoliceForce%ld", loop1 );
                    if ( strcmp( name1, buffer) == 0 ){
                        ChangeDelimiter(name2, ',');
                        n = sscanf(name2, "%ld %ld %ld %ld %ld %ld %ld %ld %ld", 
                                        &data[0], &data[1], &data[2], &data[3], &data[4],
                                        &data[5], &data[6], &data[7], &data[8]);
                        if ( data[1] == 0 ) {
                            MoveObjN[3].push_back(data[2]);
                            nCntPoliceForceN += 1;
                        }
                        else if ( data[1] == 1 ) {
                            MoveObjB[3].push_back(data[2]);
                            nCntPoliceForceB += 1;
                        }
                        else if ( data[1] == 2 ){ 
                            MoveObjRs[3].push_back(data[2]);
                            MoveObjRe[3].push_back(data[5]);
                            MoveObjRl[3].push_back(data[8] * 1000); //[m]->[mm]
                            nCntPoliceForceR += 1;
                        }
                    }
                }

                if ( strcmp( name1, "FirePointNum") == 0 )
                    nCntFirePoint = atol(name2);

                for (loop1=0; loop1<nCntFirePoint; loop1++ ){
                    sprintf( buffer, "FirePoint%ld", loop1 );
                    if ( strcmp( name1, buffer) == 0 ){
                        ChangeDelimiter(name2, ',');
                        n = sscanf(name2, "%ld %ld %ld %ld %ld", 
                                        &data[0], &data[1], &data[2], &data[3], &data[4]);
                        FirePointIDs.push_back(data[2]);
                    }
                }

            }
        }
        fclose(fpTxt);
        nCntBuilding = nCntAllBuilding - nCntRefuge - nCntAmbulanceCenter - nCntPoliceOffice - nCntFireStation;
    }

    //Constract Data
    pRoad = new Road[nCntRoad];
printf("Road:%ld\n", nCntRoad );

    pNode = new Node[nCntNode];
printf("Node:%ld\n", nCntNode );

    pBuilding = new Building[nCntBuilding];
printf("Building:%ld\n", nCntBuilding );
    pAmbulanceCenter = new AmbulanceCenter[nCntAmbulanceCenter];
printf("AmbulanceCenter:%ld\n", nCntAmbulanceCenter );
    pPoliceOffice = new PoliceOffice[nCntPoliceOffice];
printf("PoliceOffice:%ld\n", nCntPoliceOffice );
    pFireStation = new FireStation[nCntFireStation];
printf("FireStation:%ld\n", nCntFireStation );
    pRefuge = new Refuge[nCntRefuge];
printf("Refuge:%ld\n", nCntRefuge );

printf("Civilian:%ld(N:%ld,B:%ld,R:%ld))\n", nCntCivilian, nCntCivilianN, nCntCivilianB, nCntCivilianR );
printf("AmbulanceTeam:%ld(N:%ld,B:%ld,R:%ld))\n", nAmbulanceTeam, nAmbulanceTeamN, nAmbulanceTeamB, nAmbulanceTeamR );
printf("FireBrigade:%ld(N:%ld,B:%ld,R:%ld))\n", nCntFireBrigade, nCntFireBrigadeN, nCntFireBrigadeB, nCntFireBrigadeR );
printf("PoliceForce:%ld(N:%ld,B:%ld,R:%ld))\n", nCntPoliceForce, nCntPoliceForceN, nCntPoliceForceB, nCntPoliceForceR );
    //make road data
    if ( bIniFileF == true ){
        for ( loop1=0; loop1<nCntRoad; loop1++ ){
//printf("%ld/%ld\n", loop1, nCntRoad);
            result = fread2( &nCntRec, sizeof( S32 ), 1, fpRoad );
            result = fread2( &tmp, sizeof( S32 ), 1, fpRoad );
            data[0] = tmp;
            result = fread2( &tmp, sizeof( S32 ), 1, fpRoad );
            data[1] = tmp;
            result = fread2( &tmp, sizeof( S32 ), 1, fpRoad );
            data[2] = tmp;

            for (loop2=0; loop2<nCntCivilianR; loop2++){
                if ( data[1] == MoveObjRs[0][loop2] && data[2] == MoveObjRe[0][loop2] ){
                    MoveObjR2[0].push_back(loop1);
                }
            }

            for (loop2=0; loop2<nAmbulanceTeamR; loop2++){
                if ( data[1] == MoveObjRs[1][loop2] && data[2] == MoveObjRe[1][loop2] ){
                    MoveObjR2[1].push_back(loop1);
                }
            }

            for (loop2=0; loop2<nCntFireBrigadeR; loop2++){
                if ( data[1] == MoveObjRs[2][loop2] && data[2] == MoveObjRe[2][loop2] ){
                    MoveObjR2[2].push_back(loop1);
                }
            }

            for (loop2=0; loop2<nCntPoliceForceR; loop2++){
                if ( data[1] == MoveObjRs[3][loop2] && data[2] == MoveObjRe[3][loop2] ){
                    MoveObjR2[3].push_back(loop1);
                }
            }

            result = fseek( fpRoad, sizeof( S32 )*(nCntRec-4), SEEK_CUR);
        }
    }
    else {
        for ( loop1=0; loop1<nCntRoad; loop1++ ){
            result = fread2( &nCntRec, sizeof( S32 ), 1, fpRoad );
            result = fseek( fpRoad, sizeof( S32 )*3, SEEK_CUR);
            result = fread2( &tmp, sizeof( S32 ), 1, fpRoad );

            for (loop2=0; loop2<nCntCivilianR; loop2++){
                if ( MoveObjR2[0][loop2]  == loop1 ){
                    MoveObjRl[0].push_back(tmp * 3 / 10);
                }
            }

            for (loop2=0; loop2<nAmbulanceTeamR; loop2++){
                if ( MoveObjR2[1][loop2]  == loop1 ){
                    MoveObjRl[1].push_back(tmp * 5 / 10);
                }
            }

            for (loop2=0; loop2<nCntFireBrigadeR; loop2++){
                if ( MoveObjR2[2][loop2]  == loop1 ){
                    MoveObjRl[2].push_back(tmp * 7 / 10);
                }
            }

            for (loop2=0; loop2<nCntPoliceForceR; loop2++){
                if ( MoveObjR2[3][loop2]  == loop1 ){
                    MoveObjRl[3].push_back(tmp * 1 / 10);
                }
            }

            result = fseek( fpRoad, sizeof( S32 )*(nCntRec-5), SEEK_CUR);
        }
    }

    result = fseek( fpRoad, sizeof( S32 )*4, SEEK_SET);
    for ( loop1=0; loop1<nCntRoad; loop1++ ){
        result = fread2( &nCntRec, sizeof( S32 ), 1, fpRoad );
        result = fread2( &tmp, sizeof( S32 ), 1, fpRoad );
        pRoad[loop1].setId( tmp );
        result = fread2( &tmp, sizeof( S32 ), 1, fpRoad );
        pNode[tmp-1].testConnect(0, &pRoad[loop1], true);
        result = fread2( &tmp, sizeof( S32 ), 1, fpRoad );
        pNode[tmp-1].testConnect(0, &pRoad[loop1], false);
        result = fread2( &tmp, sizeof( S32 ), 1, fpRoad );
        pRoad[loop1].setLength(0, tmp);
        result = fread2( &tmp, sizeof( S32 ), 1, fpRoad );
        pRoad[loop1].setRoadKind(0, tmp);
        result = fread2( &tmp, sizeof( S32 ), 1, fpRoad );
        pRoad[loop1].setCarsPassToHead(0, tmp);
        result = fread2( &tmp, sizeof( S32 ), 1, fpRoad );
        pRoad[loop1].setCarsPassToTail(0, tmp);
        result = fread2( &tmp, sizeof( S32 ), 1, fpRoad );
        pRoad[loop1].setHumansPassToHead(0, tmp);
        result = fread2( &tmp, sizeof( S32 ), 1, fpRoad );
        pRoad[loop1].setHumansPassToTail(0, tmp);
        result = fread2( &tmp, sizeof( S32 ), 1, fpRoad );
//printf("width:%ld\n", tmp );
        pRoad[loop1].setWidth(0, tmp);
        result = fread2( &tmp, sizeof( S32 ), 1, fpRoad );
        pRoad[loop1].setBlock(0, tmp);
        result = fread2( &tmp, sizeof( S32 ), 1, fpRoad );
        pRoad[loop1].setRepairCost(0, tmp);
        result = fread2( &tmp, sizeof( S32 ), 1, fpRoad );
        pRoad[loop1].setMedianStrip(0, tmp);
        result = fread2( &tmp, sizeof( S32 ), 1, fpRoad );
        pRoad[loop1].setLinesToHead(0, tmp);
        result = fread2( &tmp, sizeof( S32 ), 1, fpRoad );
        pRoad[loop1].setLinesToTail(0, tmp);
        result = fread2( &tmp, sizeof( S32 ), 1, fpRoad );
        pRoad[loop1].setWidthForWalkers(0, tmp);

        pool.testAdd( &pRoad[loop1] );
    }
    fclose(fpRoad);
//printf("Road Data OK\n" );

    //make node data
    if ( bIniFileF == true ){
        for ( loop1=0; loop1<nCntNode; loop1++ ){
            result = fread2( &nCntRec, sizeof( S32 ), 1, fpNode );
            result = fread2( &tmp, sizeof( S32 ), 1, fpNode );

            for (loop2=0; loop2<nCntCivilianN; loop2++){
                if ( tmp == MoveObjN[0][loop2] ){
                    MoveObjN2[0].push_back(loop1);
                }
            }

            for (loop2=0; loop2<nAmbulanceTeamN; loop2++){
                if ( tmp == MoveObjN[1][loop2] ){
                    MoveObjN2[1].push_back(loop1);
                }
            }

            for (loop2=0; loop2<nCntFireBrigadeN; loop2++){
                if ( tmp == MoveObjN[2][loop2] ){
                    MoveObjN2[2].push_back(loop1);
                }
            }

            for (loop2=0; loop2<nCntPoliceForceN; loop2++){
                if ( tmp == MoveObjN[3][loop2] ){
                    MoveObjN2[3].push_back(loop1);
                }
            }

            result = fseek( fpNode, sizeof( S32 )*(nCntRec-2), SEEK_CUR);
        }
    }
    result = fseek( fpNode, sizeof( S32 )*4, SEEK_SET);
    for ( loop1=0; loop1<nCntNode; loop1++ ){
        result = fread2( &nCntRec, sizeof( S32 ), 1, fpNode );
        result = fread2( &tmp, sizeof( S32 ), 1, fpNode );
        pNode[loop1].setId( tmp );
        result = fread2( &tmp, sizeof( S32 ), 1, fpNode );
        pNode[loop1].setX(0, tmp);
        result = fread2( &tmp, sizeof( S32 ), 1, fpNode );
        pNode[loop1].setY(0, tmp);

        result = fread2( &nCntRec2, sizeof( S32 ), 1, fpNode );
        for (loop2=0; loop2<nCntRec2; loop2++){
            result = fread2( &tmp, sizeof( S32 ), 1, fpNode );
            //  eIDs & bIDs
        }

        result = fread2( &tmp, sizeof( S32 ), 1, fpNode );
        pNode[loop1].setSignal(0, tmp);

        bytes.clear();
        for (loop2=0; loop2<nCntRec2; loop2++){
            result = fread2( &tmp, sizeof( S32 ), 1, fpNode );
            tmp_byte = tmp & 0xff000000;
            bytes.push_back( (Byte)(tmp_byte >> 24) );
            tmp_byte = tmp & 0x00ff0000;
            bytes.push_back( (Byte)(tmp_byte >> 16) );
            tmp_byte = tmp & 0x0000ff00;
            bytes.push_back( (Byte)(tmp_byte >> 8) );
            tmp_byte = tmp & 0x000000ff;
            bytes.push_back( (Byte)tmp_byte );
        }
        pNode[loop1].setShortcutToTurn(0, bytes);

        bytes.clear();
        for (loop2=0; loop2<nCntRec2; loop2++){
            result = fread2( &tmp, sizeof( S32 ), 1, fpNode );
            tmp_byte = tmp & 0xff000000;
            bytes.push_back( (Byte)(tmp_byte >> 24) );
            tmp_byte = tmp & 0x00ff0000;
            bytes.push_back( (Byte)(tmp_byte >> 16) );
            tmp_byte = tmp & 0x0000ff00;
            bytes.push_back( (Byte)(tmp_byte >> 8) );
            tmp_byte = tmp & 0x000000ff;
            bytes.push_back( (Byte)tmp_byte );

            result = fread2( &tmp, sizeof( S32 ), 1, fpNode );
            tmp_byte = tmp & 0xff000000;
            bytes.push_back( (Byte)(tmp_byte >> 24) );
            tmp_byte = tmp & 0x00ff0000;
            bytes.push_back( (Byte)(tmp_byte >> 16) );
            tmp_byte = tmp & 0x0000ff00;
            bytes.push_back( (Byte)(tmp_byte >> 8) );
            tmp_byte = tmp & 0x000000ff;
            bytes.push_back( (Byte)tmp_byte );
        }
        pNode[loop1].setPocketToTurnAcross(0, bytes);

        bytes.clear();
        for (loop2=0; loop2<nCntRec2; loop2++){
            result = fread2( &tmp, sizeof( S32 ), 1, fpNode );
            tmp_byte = tmp & 0xff000000;
            bytes.push_back( (Byte)(tmp_byte >> 24) );
            tmp_byte = tmp & 0x00ff0000;
            bytes.push_back( (Byte)(tmp_byte >> 16) );
            tmp_byte = tmp & 0x0000ff00;
            bytes.push_back( (Byte)(tmp_byte >> 8) );
            tmp_byte = tmp & 0x000000ff;
            bytes.push_back( (Byte)tmp_byte );

            result = fread2( &tmp, sizeof( S32 ), 1, fpNode );
            tmp_byte = tmp & 0xff000000;
            bytes.push_back( (Byte)(tmp_byte >> 24) );
            tmp_byte = tmp & 0x00ff0000;
            bytes.push_back( (Byte)(tmp_byte >> 16) );
            tmp_byte = tmp & 0x0000ff00;
            bytes.push_back( (Byte)(tmp_byte >> 8) );
            tmp_byte = tmp & 0x000000ff;
            bytes.push_back( (Byte)tmp_byte );

            result = fread2( &tmp, sizeof( S32 ), 1, fpNode );
            tmp_byte = tmp & 0xff000000;
            bytes.push_back( (Byte)(tmp_byte >> 24) );
            tmp_byte = tmp & 0x00ff0000;
            bytes.push_back( (Byte)(tmp_byte >> 16) );
            tmp_byte = tmp & 0x0000ff00;
            bytes.push_back( (Byte)(tmp_byte >> 8) );
            tmp_byte = tmp & 0x000000ff;
            bytes.push_back( (Byte)tmp_byte );
        }
        pNode[loop1].setSignalTiming(0, bytes);

//printf("b:%ld, %ld,%ld\n", pNode[loop1].id(), pNode[loop1].x() ,pNode[loop1].y() );       
        pool.testAdd( &pNode[loop1] );
    }
    fclose(fpNode);
//printf("Node Data OK\n" );

//AmbulanceCenter
//PoliceOffice
//FireStation
//Refuge
    //make building data
    if ( bIniFileF == true ){
        cntBA = cntBP = cntBF = cntBR = cntB = 0;
        for ( loop1=0; loop1<nCntAllBuilding; loop1++ ){
            result = fread2( &nCntRec, sizeof( S32 ), 1, fpBuilding );
            result = fread2( &tmp, sizeof( S32 ), 1, fpBuilding );
            for (loop2=0; loop2<nCntAmbulanceCenter; loop2++){
                if ( tmp == MotionlessObj[0][loop2] ){
                    MotionlessObj2[0].push_back(loop1);
                    cntBA += 1;
                }
            }

            for (loop2=0; loop2<nCntFireStation; loop2++){
                if ( tmp == MotionlessObj[1][loop2] ){
                    MotionlessObj2[1].push_back(loop1);
                    cntBF += 1;
                }
            }

            for (loop2=0; loop2<nCntPoliceOffice; loop2++){
                if ( tmp == MotionlessObj[2][loop2] ){
                    MotionlessObj2[2].push_back(loop1);
                    cntBP += 1;
                }
            }

            for (loop2=0; loop2<nCntRefuge; loop2++){
                if ( tmp == MotionlessObj[3][loop2] ){
                    MotionlessObj2[3].push_back(loop1);
                    cntBR += 1;
                }
            }
            cntB = loop1 - cntBA - cntBP - cntBF - cntBR;

            for (loop2=0; loop2<nCntFirePoint; loop2++){
                if ( tmp == FirePointIDs[loop2] ){
                    FirePointIDs2.push_back(loop1);
                }
            }

            for (loop2=0; loop2<nCntCivilianB; loop2++){
                if ( tmp == MoveObjB[0][loop2] ){
                    MoveObjB2[0].push_back(cntB);
                }
            }

            for (loop2=0; loop2<nAmbulanceTeamB; loop2++){
                if ( tmp == MoveObjB[1][loop2] ){
                    MoveObjB2[1].push_back(cntB);
                }
            }

            for (loop2=0; loop2<nCntFireBrigadeB; loop2++){
                if ( tmp == MoveObjB[2][loop2] ){
                    MoveObjB2[2].push_back(cntB);
                }
            }

            for (loop2=0; loop2<nCntPoliceForceB; loop2++){
                if ( tmp == MoveObjB[3][loop2] ){
                    MoveObjB2[3].push_back(cntB);
                }
            }

            result = fseek( fpBuilding, sizeof( S32 )*(nCntRec-2), SEEK_CUR);
        }
    }

    bool                bFire = false;
    bool                bspF;

    cntBA = cntBP = cntBF = cntBR = cntB = 0;

    result = fseek( fpBuilding, sizeof( S32 )*4, SEEK_SET);
    for ( loop1=0; loop1<nCntAllBuilding; loop1++ ){
//printf("%ld/%ld\n", loop1, nCntAllBuilding);
        bspF = NULL;
        for (loop2=0; loop2<nCntAmbulanceCenter; loop2++){
            if ( loop1 == MotionlessObj2[0][loop2] ){
                pAllBuilding = & pAmbulanceCenter[cntBA];
                cntBA = cntBA +1;
                bspF = true;
            }
        }

        for (loop2=0; loop2<nCntFireStation; loop2++){
            if ( loop1 == MotionlessObj2[1][loop2] ){
                pAllBuilding = & pFireStation[cntBF];
                cntBF = cntBF +1;
                bspF = true;
            }
        }

        for (loop2=0; loop2<nCntPoliceOffice; loop2++){
            if ( loop1 == MotionlessObj2[2][loop2] ){
                pAllBuilding = & pPoliceOffice[cntBP];
                cntBP = cntBP +1;
                bspF = true;
            }
        }

        for (loop2=0; loop2<nCntRefuge; loop2++){
            if ( loop1 == MotionlessObj2[3][loop2] ){
                pAllBuilding = & pRefuge[cntBR];
                cntBR = cntBR +1;
                bspF = true;
            }
        }

        if (!bspF){
            pAllBuilding = & pBuilding[cntB];
            cntB = cntB +1;
        }

//printf("cntBA:%ld,", cntBA);
//printf("cntBP:%ld,", cntBP);
//printf("cntBF:%ld,", cntBF);
//printf("cntBR:%ld,", cntBR);
//printf("cntB:%ld\n",  cntB);
        result = fread2( &nCntRec, sizeof( S32 ), 1, fpBuilding );
        result = fread2( &tmp, sizeof( S32 ), 1, fpBuilding );
        pAllBuilding->setId( tmp );
        result = fread2( &tmp, sizeof( S32 ), 1, fpBuilding );
        pAllBuilding->setX(0, tmp);
        result = fread2( &tmp, sizeof( S32 ), 1, fpBuilding );
        pAllBuilding->setY(0, tmp);
        result = fread2( &tmp, sizeof( S32 ), 1, fpBuilding );
        pAllBuilding->setFloors(0, tmp);
        result = fread2( &tmp, sizeof( S32 ), 1, fpBuilding );
        pAllBuilding->setBuildingAttributes(0, tmp);
        result = fread2( &tmp, sizeof( S32 ), 1, fpBuilding );
//      if (bFire != true){
//          tmp = 1;
//          printf("%ld, %ld\n", pBuilding[loop1].x(), pBuilding[loop1].y() );
//          bFire = true;
//      }
/*
        if (pBuilding[loop1].x() == 23046400 && pBuilding[loop1].y() == 3731000 ){
            tmp = 1;
        }
        if (pBuilding[loop1].x() == 22776000 && pBuilding[loop1].y() == 3621000 ){
            tmp = 1;
        }
        if (pBuilding[loop1].x() == 22942100 && pBuilding[loop1].y() == 3796300 ){
            tmp = 1;
        }
        if (pBuilding[loop1].x() == 22975800 && pBuilding[loop1].y() == 3702000 ){
            tmp = 1;
        }
*/
        for (loop2=0; loop2<nCntFirePoint; loop2++){
            if (loop1 == FirePointIDs2[loop2]){
                tmp = 1;
printf("FirePoint (%ld, %ld)\n", pAllBuilding->x(), pAllBuilding->y() );        
            }
        }
        pAllBuilding->setIgnition(0, tmp);
        result = fread2( &tmp, sizeof( S32 ), 1, fpBuilding );
        pAllBuilding->setFieryness(0, tmp);
        result = fread2( &tmp, sizeof( S32 ), 1, fpBuilding );
        pAllBuilding->setBrokenness(0, tmp);

        result = fread2( &nCntRec2, sizeof( S32 ), 1, fpBuilding );
        for (loop2=0; loop2<nCntRec2; loop2++){
            result = fread2( &tmp, sizeof( S32 ), 1, fpBuilding );
            pNode[tmp-1].testConnect(0, pAllBuilding);
        }

        result = fread2( &tmp, sizeof( S32 ), 1, fpBuilding );
//      pAllBuilding->setBuildingShapeId(0, tmp);
        result = fread2( &tmp, sizeof( S32 ), 1, fpBuilding );
        pAllBuilding->setBuildingAreaGround(0, tmp);
        result = fread2( &tmp, sizeof( S32 ), 1, fpBuilding );
        pAllBuilding->setBuildingAreaTotal(0, tmp);
        result = fread2( &tmp, sizeof( S32 ), 1, fpBuilding );
        pAllBuilding->setBuildingCode(0, tmp);

        result = fread2( &nCntRec2, sizeof( S32 ), 1, fpBuilding );
        bytes.clear();
        for (loop2=0; loop2<nCntRec2; loop2++){

            result = fread2( &tmp, sizeof( S32 ), 1, fpBuilding );
            tmp_byte = tmp & 0xff000000;
            bytes.push_back( (Byte)(tmp_byte >> 24) );
            tmp_byte = tmp & 0x00ff0000;
            bytes.push_back( (Byte)(tmp_byte >> 16) );
            tmp_byte = tmp & 0x0000ff00;
            bytes.push_back( (Byte)(tmp_byte >> 8) );
            tmp_byte = tmp & 0x000000ff;
            bytes.push_back( (Byte)tmp_byte );

            result = fread2( &tmp, sizeof( S32 ), 1, fpBuilding );
            tmp_byte = tmp & 0xff000000;
            bytes.push_back( (Byte)(tmp_byte >> 24) );
            tmp_byte = tmp & 0x00ff0000;
            bytes.push_back( (Byte)(tmp_byte >> 16) );
            tmp_byte = tmp & 0x0000ff00;
            bytes.push_back( (Byte)(tmp_byte >> 8) );
            tmp_byte = tmp & 0x000000ff;
            bytes.push_back( (Byte)tmp_byte );
        }
        pAllBuilding->setBuildingApexes(0, bytes);
        
        pool.testAdd( pAllBuilding );
    }
    fclose(fpBuilding);
//printf("Motionless Object OK\n");

/*  //make AllGISDataList
    if( AllListOutput != 0 ){
        if( (fpTxt = fopen( "road.txt", "w+"FOPEN_MODE_TEXT )) != NULL ){
            for ( loop1=0; loop1<nCntRoad; loop1++ ){
                sprintf(buffer, "%ld : %ld->%ld\n", pRoad[loop1].id() ,
                    pRoad[loop1].head()->id(),  pRoad[loop1].tail()->id() );        
                result = fwrite( buffer, sizeof( char ), strlen( buffer ), fpTxt );
            }
            fclose(fpTxt);
        }

        if( (fpTxt = fopen( "node.txt", "w+"FOPEN_MODE_TEXT )) != NULL ){
            for ( loop1=0; loop1<nCntNode; loop1++ ){
                sprintf(buffer, "%ld : (%ld, %ld)\n", pNode[loop1].id() ,
                    pNode[loop1].x() ,pNode[loop1].y() );       
                result = fwrite( buffer, sizeof( char ), strlen( buffer ), fpTxt );
            }
            fclose(fpTxt);
        }

        if( (fpTxt = fopen( "building.txt", "w+"FOPEN_MODE_TEXT )) != NULL ){
            for ( loop1=0; loop1<nCntBuilding; loop1++ ){
                sprintf(buffer, "%ld : (%ld, %ld)\n", pBuilding[loop1].id() ,
                    pBuilding[loop1].x(), pBuilding[loop1].y() );       
                result = fwrite( buffer, sizeof( char ), strlen( buffer ), fpTxt );
            }
            fclose(fpTxt);
        }
    
    }
*/

//  int k, z;

//  k = number;
//  z = nCntRoad / k;
//  if(z < 1)
//      z = 1;
//  for ( loop1=0; loop1<nCntRoad; loop1++ ){
//      if(loop1 % z == 0 && k-- > 0) {
//          Civilian* civilian = new Civilian();
//          pool.testAdd(civilian);
//          civilian->setPosition(0, &pRoad[loop1]);
//          civilian->setPositionExtra(0, pRoad[loop1].length() * 3 / 10);
//      }
//  }

    // Place Agents
    
    // Civilian

    // Civilian on Node
    for ( loop1=0; loop1<nCntCivilianN; loop1++ ){
        Civilian* civilian = new Civilian();
        pool.testAdd(civilian);
        civilian->setPosition(0, &pNode[MoveObjN2[0][loop1]]);
    }
//  printf("On Node OK\n");

    // Civilian in Building
    for ( loop1=0; loop1<nCntCivilianB; loop1++ ){
        Civilian* civilian = new Civilian();
        pool.testAdd(civilian);
        civilian->setPosition(0, &pBuilding[MoveObjB2[0][loop1]]);
    }
//  printf("On Building OK\n");

    // Civilian on Road
    for ( loop1=0; loop1<nCntCivilianR; loop1++ ){
        Civilian* civilian = new Civilian();
        pool.testAdd(civilian);
        civilian->setPosition(0, &pRoad[MoveObjR2[0][loop1]]);
        civilian->setPositionExtra(0, MoveObjRl[0][loop1]);
    }
//  printf("On Road OK\n");

    //AmbulanceTeam

    //AmbulanceTeam on Node
    for ( loop1=0; loop1<nAmbulanceTeamN; loop1++ ){
        AmbulanceTeam* ambulance = new AmbulanceTeam();
        pool.testAdd(ambulance);
        ambulance->setPosition(0, &pNode[MoveObjN2[1][loop1]]);
    }

    // AmbulanceTeam in Building
    for ( loop1=0; loop1<nAmbulanceTeamB; loop1++ ){
        AmbulanceTeam* ambulance = new AmbulanceTeam();
        pool.testAdd(ambulance);
        ambulance->setPosition(0, &pBuilding[MoveObjB2[1][loop1]]);
    }

    // AmbulanceTeam on Road
    for ( loop1=0; loop1<nAmbulanceTeamR; loop1++ ){
        AmbulanceTeam* ambulance = new AmbulanceTeam();
        pool.testAdd(ambulance);
        ambulance->setPosition(0, &pRoad[MoveObjR2[1][loop1]]);
        ambulance->setPositionExtra(0, MoveObjRl[1][loop1]);
    }

    //FireBrigade

    //FireBrigade on Node
    for ( loop1=0; loop1<nCntFireBrigadeN; loop1++ ){
        FireBrigade* fireteam = new FireBrigade();
        pool.testAdd(fireteam);
        fireteam->setPosition(0, &pNode[MoveObjN2[2][loop1]]);
    }

    // FireBrigade in Building
    for ( loop1=0; loop1<nCntFireBrigadeB; loop1++ ){
        FireBrigade* fireteam = new FireBrigade();
        pool.testAdd(fireteam);
        fireteam->setPosition(0, &pBuilding[MoveObjB2[2][loop1]]);
    }

    // FireBrigade on Road
    for ( loop1=0; loop1<nCntFireBrigadeR; loop1++ ){
        FireBrigade* fireteam = new FireBrigade();
        pool.testAdd(fireteam);
        fireteam->setPosition(0, &pRoad[MoveObjR2[2][loop1]]);
        fireteam->setPositionExtra(0, MoveObjRl[2][loop1]);
    }

    //PoliceForce

    //PoliceForce on Node
    for ( loop1=0; loop1<nCntPoliceForceN; loop1++ ){
        PoliceForce* policeforce = new PoliceForce();
        pool.testAdd(policeforce);
        policeforce->setPosition(0, &pNode[MoveObjN2[3][loop1]]);
    }

    // PoliceForce in Building
    for ( loop1=0; loop1<nCntPoliceForceB; loop1++ ){
        PoliceForce* policeforce = new PoliceForce();
        pool.testAdd(policeforce);
        policeforce->setPosition(0, &pBuilding[MoveObjB2[3][loop1]]);
    }

    //PoliceForce on Road
    for ( loop1=0; loop1<nCntPoliceForceR; loop1++ ){
        PoliceForce* policeforce = new PoliceForce();
        pool.testAdd(policeforce);
        policeforce->setPosition(0, &pRoad[MoveObjR2[3][loop1]]);
        policeforce->setPositionExtra(0, MoveObjRl[3][loop1]);
    }

//#if 0
//  k = number;
//  z = nCntNode / k;
//  if(z < 1)
//      z = 1;
//  for ( loop1=0; loop1<nCntNode; loop1++ ){
//      if(loop1 % z == 0 && k-- > 0) {
//          AmbulanceTeam* ambulance = new AmbulanceTeam();
//          pool.testAdd(ambulance);
//          ambulance->setPosition(0, &pNode[loop1]);
//      }
//  }
//#endif
    printf("Make World OK\n");
    return;
}


