#ifndef XY_HXX_INCLUDED
#define XY_HXX_INCLUDED

#include <complex>
#include "objects.hxx"

namespace Rescue
{
	template<class T> class _XY :public std::complex<T> 
	{
	public:
		_XY(T x = 0, T y = 0) : std::complex<T>(x, y){} 
		_XY(const std::complex<T>& xy): std::complex<T>(xy){} 
		T x() const {  return real(); }
		T y() const {  return imag(); }
		T operator[](int i)  const { return (i == 0)? x(): y(); }
	};

	typedef Rescue::_XY<double> XY;
}

#endif //!XY_HXX_INCLUDED
