// FlammableBuilding.hxx
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(FLAMMABLEBUILDING_HXX__INCLUDED) // {
#define FLAMMABLEBUILDING_HXX__INCLUDED

#include "objects.hxx"

namespace Rescue
{
	/////////////////////////////////////////////////////////////////////////
	// FlammableBuilding
	
	class RescueObjectPool;
	class FlammableBuilding : public Building
	{
	private:
		
	protected:
		RescueObjectPool* m_owner;
		enum { m_initialFuel = 100 };
		int m_fuel;
		double m_flame;
		// m_fuel -= m_flame per step.  if m_fuel <= 0, the building burned out.
		
	public:
		virtual ~FlammableBuilding();
		FlammableBuilding(RescueObjectPool* pool);

		void step(S32 time);
		void ignitePeriphery();
		void ignite();
		void extinguish();
		
	private:
		FlammableBuilding(const FlammableBuilding& source);
		FlammableBuilding& operator= (const FlammableBuilding& rhs);
		bool operator== (const FlammableBuilding& rhs) const;
	};
	
	/////////////////////////////////////////////////////////////////////////
} // namespace Rescue

#ifdef NDEBUG
#  include "FlammableBuilding.inl"
#endif

#endif // } !defined(FLAMMABLEBUILDING_HXX__INCLUDED)
