// AppTechFlammableBuilding.cxx
//
/////////////////////////////////////////////////////////////////////////////

#include "common.hxx"
#include "AppTech.hxx"
#include "AppTechFlammableBuilding.hxx"

#ifndef NDEBUG
#  include "AppTechFlammableBuilding.inl"
#endif

namespace Rescue
{
	/////////////////////////////////////////////////////////////////////////
	// AppTechFlammableBuilding
	
	AppTechFlammableBuilding::~AppTechFlammableBuilding()
	{
	}

	void AppTechFlammableBuilding::input(S32 time, ObjectPool& pool, Input& buffer, PropertyId property) {
		switch(property) {
		default:
			Building::input(time, pool, buffer, property);
			break;
		case PROPERTY_FLOORS:
		{
			S32 value = buffer.get();
			if (time > 0) {	// ʳɤФ
				break;
			} else {
				setFloors(time, value);
			}
		}
			break;
		case PROPERTY_BUILDING_ATTRIBUTES:
		{
			S32 value = buffer.get();
			if (time > 0) {	//  ʳɤФ
				break;
			} else {
				setBuildingAttributes(time, value);
			}
		}
			break;
		case PROPERTY_IGNITION:
		{
			S32 value = buffer.get();
			setIgnition(time, value);
		}
			break;
		case PROPERTY_FIERYNESS:
		{
			S32 value = buffer.get();
			setFieryness(time, value);
		}
			break;
		case PROPERTY_BROKENNESS:
		{
			S32 value = buffer.get();
			setBrokenness(time, value);
		}
			break;
		case PROPERTY_ENTRANCES:
		{
			Id id;
			if (time > 0) {		// ʳɤФ
				while(id = buffer.get(), id != 0) {
					;
				}
			} else {
				Building::input(time, pool, buffer, property);
			}
		}
			break;
		case PROPERTY_BUILDING_CODE:
		{
			S32 value = buffer.get();
			if (time > 0) {		// ʳɤФ
				break;
			} else {
				setBuildingCode(time, value);
				switch (value) {
				default:
				case 0: //¤
					m_buildingCode_mkdat = 11;  //¤
					m_buildingCode_trainning = 1;  //¤
					break;
				case 1: //Ŵ¤
					m_buildingCode_mkdat = 21;  //ɲ
					m_buildingCode_trainning = 2;  //¤
					break;
				case 2: //Ŵڥ¤;
					m_buildingCode_mkdat = 31;  //Ѳ
					m_buildingCode_trainning = 3;  //¤
					break;
				}
			}
		}
			break;
		case PROPERTY_BUILDING_AREA_GROUND:
		{
			S32 value = buffer.get();
			if (time > 0) {		// ʳɤФ
				break;
			} else {
				setBuildingAreaGround(time, value);
				setAreaGround(time, double(value) / 100);
			}
		}
			break;
		case PROPERTY_BUILDING_AREA_TOTAL:
		{
			S32 value = buffer.get();
			if (time > 0) {		// ʳɤФ
				break;
			} else {
				setBuildingAreaTotal(time, value);
				setAreaTotal(time, double(value) / 100);
			}
		}
			break;
		case PROPERTY_BUILDING_APEXES:
		{
			if (time > 0) {		// ʳɤФ
				Bytes value;
				buffer.getBytes(value);
				break;
			} else {
				zahyo.clear();
				S32 size = buffer.get();
				int i = 0;
				for(; size > 0; size -= 8, i++) {
					S32 x = buffer.get();
					if(size > 4) {
						S32 x0 = 0, y0 = 0; // ʤȤΤǡ
						S32 y = buffer.get();
						if (i > 0) {
							if (x == x0 && y == y0) {
								continue;
							}
						}
						zahyo.push_back(XY(double(x) / 1000,
								   double(y) / 1000));
						x0 = x;
						y0 = y;

					}
				}
				if (abs(zahyo[0] - zahyo[zahyo.size() - 1]) >= EPS) {
					zahyo.push_back(zahyo[0]);
				}
			}
		}
			break;
		}
	}


	void AppTechFlammableBuilding::dataread()
	{
		// DATA CHECK
		// 1FѤ0:-1
		// Ѥ0:-2
		// ſ0,0:-3

		double wkf;
		// ʪ¤ʷʪ¤3ʳɽѤ
		switch (m_buildingCode_mkdat) {
		case 11:	// ¤кҲٽ120kg
			k2 = 1;
			wkf = 120;
			break;
		case 21:	// ɲСкҲٽ120kg
			k2 = 2;
			wkf = 120;
			break;
		default:	// ѲСкҲٽ 30kg
			k2 = 3;
			wkf = 30;
			break;
		}
		// ƽ̤
		fire.gfr_ttl = areaTotal() * wkf;
		// ǳΨФν
		fire.p = 1.0/(1.0 + exp(-1.0* m_owner->para.pra * m_owner->para.prc));
		// ¸ƽ̤
		fire.gfr_rst = fire.gfr_ttl - fire.p * fire.gfr_ttl;		
	}

#ifndef MKDAT
	void AppTechFlammableBuilding::jushin_cal()
	{
		ajushin = XY(0, 0);
		S32 size = zahyo.size();
		S32 i = 0;
		for (; size > 0; size--) {
			ajushin += zahyo[i++];
		}
		ajushin /= i;
	}

	// ȲΥݥ(Ĺ롩)
	void AppTechFlammableBuilding::scl_cal()
	{
		ascl = 0; // 2֤εΥκ͡
		S32 size = zahyo.size();
		S32 i, j;
		
		for (i = 0; i < size; i++) {
			for (j = i + 1; j < size; j++) {
				double alx = zahyo[i].x() - zahyo[j].x();
				double aly = zahyo[i].y() - zahyo[j].y();
				double al = sqrt(alx * alx + aly * aly);
				if (al > ascl) {
					ascl = al;
				}
					
			}
		}
	}

	// ȲѤ׻
	double AppTechFlammableBuilding::men_cal()
	{
		double s = 0; // 2֤εΥκ͡
		S32 size = zahyo.size();
		S32 i;
		
		for (i = 1; i < size - 1; i++) {
			XY v0 = zahyo[i] - zahyo[0];
			XY v1 = zahyo[i+1] - zahyo[0];
			s += v0.x() * v1.y() - v0.y() * v1.x();
		}
		s = abs(s / 2);
		return s;
	}

//	void AppTechFlammableBuilding::near(std::vector<AppTechFlammableBuilding*>& nrin)
	void AppTechFlammableBuilding::near(std::vector<rinsetu>& nrin)
	{

		Objects::const_iterator it = m_owner->objects().begin();

		for(; it != m_owner->objects().end(); it++) {
			AppTechFlammableBuilding* fb = dynamic_cast<AppTechFlammableBuilding*>(*it);
			if(fb != 0) {
				double dist = abs(ajushin - fb->ajushin); 
				if (dist < EPS) continue;
				double rr = dist - (ascl + fb->ascl) / 2 ;
				if (rr > 20) continue; // XXX: MAGIC NUMBER 20
				nrin.push_back(rinsetu(fb));
			}
		}
	}

//	void AppTechFlammableBuilding::pickup(std::vector<AppTechFlammableBuilding*>& nrin)
	void AppTechFlammableBuilding::pickup(std::vector<rinsetu>& nrin)
	{
		//std::vector<AppTechFlammableBuilding*>::const_iterator it = nrin.begin();
		std::vector<rinsetu>::iterator it = nrin.begin();
		XY sen[2];
		sen[0] = ajushin;

	lp1: 
		for (; it != nrin.end(); it++) {
			double rmin = it->min_dist
				= distmin(*this, *(it->fb));
			if (rmin < 3.0) { // XXX: MAGIC NUMBER
				nrinsetu.push_back(*it);
				continue;
			} else {
				AppTechFlammableBuilding* fb = it->fb;
				sen[1] = fb->ajushin;
				double bunshi = XY(sen[1] - sen[0]).y();
				double bunbo = XY(sen[1] - sen[0]).x();
				double a1, b1;
				bool ifrag;
				if (abs(bunbo) < EPS) {
					ifrag = true;
					b1 = sen[0].x();
				} else {
					ifrag = false;
					a1 = bunshi / bunbo;
					b1 = sen[0].y() - a1 * sen[0].x();
				}
			lp2:
				//std::vector<AppTechFlammableBuilding*>::const_iterator it2 = nrin.begin();
				std::vector<rinsetu>::const_iterator it2 = nrin.begin();
				for (; it2 != nrin.end(); it2++) {
					if (it == it2) {
						continue;
					}
					AppTechFlammableBuilding* fb = it2->fb;
				lp3:
					std::vector<XY>::const_iterator it3 = fb->zahyo.begin();
					if (it3 != fb->zahyo.end()) {
						XY p0, p1;
						p0 = p1 = *it3;
						it3++;
						for (; it3 != fb->zahyo.end(); it3++) {
							XY p2 = *it3;
								
							double bunshi = XY(p2 - p1).y();
							double bunbo =  XY(p2 - p1).x();
							double ya1, ya2, yb1, yb2;
								
							if (abs(bunbo) < EPS) {
								double b2 = p2.x();
								if (!ifrag) {
									ya1 = a1*p1.x() + b1 - p1.y();
									ya2 = a1*p2.x() + b1 - p2.y();
									yb1 = sen[0].x() - b2;
									yb2 = sen[1].x() - b2;
								} else if (b1 == b2) {
									goto continue_lp1;
								} else {
									goto continue_lp3;
								}
							} else {
								double a2 = bunshi / bunbo;
								double b2 = p1.y() - a2 * p1.x();
								if (!ifrag) {
									ya1 = a1 * p1.x() + b1 - p1.y();
									ya2 = a1 * p2.x() + b1 - p2.y();
									yb1 = a2 * sen[0].x() + b2 - sen[0].y();
									yb2 = a2 * sen[1].x() + b2 - sen[1].y();
								} else {
									ya1 = p1.x() - b1;
									ya2 = p2.x() - b1;
									yb1 = a2 * sen[0].x() + b2 - sen[0].y();
									yb2 = a2 * sen[1].x() + b2 - sen[1].y();
								}
							}
							if (ya1 * ya2 < 0 && yb1 * yb2 < 0) {
								goto continue_lp1;
							}
						continue_lp3:
							p1 = p2;
						}
					}
				}
				nrinsetu.push_back(*it);
			}
		continue_lp1:
			;
		}
	}

	void AppTechFlammableBuilding::kashi()
	{
		//std::vector<AppTechFlammableBuilding*> nrin;
		std::vector<rinsetu> nrin;
		near(nrin);
		pickup(nrin);
	}

	static double normal_arg(double rad) {
		while (rad > 2 * M_PI) {
			rad -= 2 * M_PI;
		}
		while (rad < 0) {
			rad += 2 * M_PI;
		}
		return rad;
	}


#endif
	/////////////////////////////////////////////////////////////////////////
} // namespace Rescue



