#include <stdlib.h>
#include "common.hxx"
#include "basic.hxx"
#include "Config.hxx"
#include "Address.hxx"
#include "Input.hxx"
#include "Output.hxx"
#include "LongUDPSocket.hxx"
#include "ObjectPool.hxx"
#include "objects.hxx"
#include "simCollapse.h"
using namespace Rescue;

//Prototype
double P(double pga, double lambda, double zeta);

int collapse_check(Building* bPtr, int accel){

  double pga = (accel+1)*100 + 50;
  double lambda_a; //collapse
  double lambda_ha; //moderatecollapse
  double lambda_mp; //slightcollapse
  double zeta_a; //collapse
  double zeta_ha; //moderatecollapse
  double zeta_mp; //slightcollapse
  float m = ((float)rand()/RAND_MAX); //random number 01


  if (bPtr->buildingAttributes() == WOOD){ //¤ξ
    lambda_a = 6.883;
    lambda_ha = 5.683;
    lambda_mp = 4.045;
    zeta_a = 0.636;
    zeta_ha = 0.910;
    zeta_mp = 1.441;
    
    if (m <=  P(pga, lambda_a, zeta_a))
      return COLLAPSE;
    else if (m <= P(pga, lambda_ha, zeta_ha))
      return MODERATE;
    else if (m <= P(pga, lambda_mp, zeta_mp))
      return SLIGHT;
    else
      return NODAMAGE;
  }

  else if (bPtr->buildingAttributes() == S || bPtr->buildingAttributes() == RC){ //RC, S ξ
    lambda_a = 8.523;
    lambda_ha = 7.377;
    lambda_mp = 7.862;
    zeta_a = 1.067;
    zeta_ha = 1.314;
    zeta_mp = 6.897;
    
    if (m <=  P(pga, lambda_a, zeta_a))
      return COLLAPSE;
    else if (m <= P(pga, lambda_ha, zeta_ha))
      return MODERATE;
    else if (m <= P(pga, lambda_mp, zeta_mp))
      return SLIGHT;
    else
      return NODAMAGE;
  }
  return 0;
}
