// -*- Mode:C++ -*-
//Header:
//File: Posit.cc
//Author: NODA, Itsuki
//Date: 2001/11/24
//

//ModifyHistory:
// 2001/11/24: Start to create this file
//EndModifyHistory:

#include "Posit.h"

namespace Rescue {

   //======================================================================
   //   : Posit
   // class Rule

   //------------------------------------------------------------
   //   : Rule : Posit
   // set

   void 
   Posit::Rule::
   set(Sexp * sexp, Posit * sit, Sexp::Heap * sheap) {
      if(!(sexp->isCons() && sexp->first()->equal(RuleTagStr))) {
	 ITK_ERR("Illegal rule sexp : " << sexp) ;
	 throw 0 ;
      } ;

      Sexp * plist = sexp->nthcdr(2) ;

      if(isNull(sheap)) {
	 name() = sexp->nth(1)->symVal() ;
	 condition() = plist->passoc(ConditionTagStr) ;
	 activity() = plist->passoc(ActivityTagStr) ;
	 action() = plist->passoc(ActionTagStr) ;
      } else {
	 name() = sheap->dup(sexp->nth(1))->symVal() ;
	 condition() = sheap->dup(plist->passoc(ConditionTagStr)) ;
	 activity() = sheap->dup(plist->passoc(ActivityTagStr)) ;
	 action() = sheap->dup(plist->passoc(ActionTagStr)) ;
      }

      condition()->fixTag() ;
      activity()->fixTag() ;
      action()->fixTag() ;

      parent() = sit ;
		  
   } ;

   //------------------------------------------------------------
   //   : Rule : Posit
   // checkCondition
   
   Bool 
   Posit::Rule::
   checkCondition(EvalEngine * engine, EvalEngine::Context * context) {
      Sexp * r = engine->evalTop(condition(),True,context) ;
      
      if(r->isNil()) return False ;
      else           return True ;
   } 

   //------------------------------------------------------------
   //   : Rule : Posit
   // calcActivity
   
   Flt 
   Posit::Rule::
   calcActivity(EvalEngine * engine, EvalEngine::Context * context) {
      Sexp * r = engine->evalTop(activity(),False,context) ;
	    
      return r->fltVal() ;
   } 

   //------------------------------------------------------------
   //   : Rule : Posit
   // execAction

   Sexp * 
   Posit::Rule::
   execAction(EvalEngine * engine, EvalEngine::Context * context) {
      Sexp * r = engine->evalTop(action(),False,context) ;
      return r ;
   }

   //======================================================================
   // class Posit

   //------------------------------------------------------------
   //   : Posit
   // set

   void
   Posit::
   set(Sexp * sexp, Sexp::Heap * sheap) {
      if(!(sexp->isCons() && sexp->first()->equal(PositTagStr))) {
	 ITK_ERR("Illegal situation form : " << sexp) ;
	 throw 0 ;
      } ;

      if(isNull(sheap)) {
	 name() = sexp->nth(1)->symVal() ;
      } else {
	 name() = sheap->dup(sexp->nth(1))->symVal() ;
      }
	    
      for(Sexp * rules = sexp->nthcdr(2) ; rules->isCons() ; 
	  rules = rules->rest()) {
	 Rule * r = new Rule ;
	 r->set(rules->first(),this,sheap) ;
	 ruleset().push(r) ;
      }
   } ;

} ;

   

   



   
