// -*- Mode:C++ -*-
//Header:
//File: AgentBase.h
//Author: NODA, Itsuki
//Date: 2001/11/24
//

//ModifyHistory:
// 2001/11/24: Start to create this file
//EndModifyHistory:

/*
 * Copyright (C) 2001 NODA, Itsuki, CARC, AIST, JAPAN
 */

#ifndef _itk_AgentBase_h_
#define _itk_AgentBase_h_
//////////////////////////////////////////////////////////////////////

#include <set>

#include "EvalEngine.h"
#include "Posit.h"

namespace Rescue {

   using namespace Itk ;

   //======================================================================
   // class Agent

   class AgentBase : public WithDescriber {

	 //--------------------------------------------------
	 //    : Agent
	 // agentTypeStr()  used in describe
      public:
	 virtual char * agentTypeStr() const {  return "AgentBase" ; } ;

	 //==================================================
	 //    : Agent
	 // class PositStack
      public:
	 class PositStack : public WithDescriber,
			    public set < Posit * > {
	       //----------------------------------------
	       //    : PositStack : Agent
	       //  typedefs
	    public:
	       typedef iterator Itr ;
	       typedef const_iterator C_Itr ;
	       typedef reverse_iterator RevItr ;
	       typedef const_reverse_iterator C_RevItr ;

	       //----------------------------------------
	       //    : PositStack : Agent
	       //  constructor / destructor
	    public:
	       PositStack() { init() ; } ;

	    public:
	       virtual ~PositStack() {} ;

	       //----------------------------------------
	       //    : PositStack : Agent
	       //  init()
	    public:
	       void init() { } ;

	       //----------------------------------------
	       //    : PositStack : Agent
	       //  other operations
	    public:
	       void add(Posit * p) { insert(begin(),p) ; } ;

	    public:
	       Bool remove(Posit *p) { 
		  Itr pos = find(p) ;
		  if(pos != end()) { erase(pos) ; return True ; }
		  else { return False ; } 
	       } ;

	       // void clear() ;

	       //----------------------------------------
	       //    : PositStack : Agent
	       //  describe
	    public:
	       virtual void describe(ostream& ostr, 
				     const Bool detailp = True) const {
		  ostr << "#PositStack[" << Ptr(this) << "]" ;
		  if(detailp) {
		     ostr << endl ;
		     ostr << "\t[table]" << endl ;
		     for(C_Itr sit = begin() ; sit != end() ; sit++) {
			ostr << "\t\t" << *sit << endl ;
		     }
		     ostr << "\t------------------------------" << endl ;
		  }
	       } ;
	 } ;

	 //==================================================
	 //    : Agent
	 // class PositTable
      public:
	 class PositTable : public WithDescriber,
			    public map < SubString, Posit * > {
	       //----------------------------------------
	       //    : PositTable : Agent
	       //  typedefs
	    public:
	       typedef iterator Itr ;
	       typedef const_iterator C_Itr ;
	       typedef reverse_iterator RevItr ;
	       typedef const_reverse_iterator C_RevItr ;

	       //----------------------------------------
	       //    : PositTable : Agent
	       //  constructor / destructor
	    public:
	       PositTable() { init() ; } ;

	    public:
	       virtual ~PositTable() {} ;

	       //----------------------------------------
	       //    : PositTable : Agent
	       //  init()
	    public:
	       void init() { } ;

	       //----------------------------------------
	       //    : PositTable : Agent
	       //  describe
	    public:
	       virtual void describe(ostream& ostr, 
				     const Bool detailp = True) const {
		  ostr << "#PositTable[" << Ptr(this) << "]" ;
		  if(detailp) {
		     ostr << endl ;
		     ostr << "\t[table]" << endl ;
		     for(C_Itr sit = begin() ; sit != end() ; sit++) {
			ostr << "\t\t" << sit->first 
			     << ":" << *(sit->second) << endl ;
		     }
		     ostr << "\t------------------------------" << endl ;
		  }
	       } ;
	 } ;

	 //==================================================
	 //    : Agent
	 // class CtxRule
      public:
	 class CtxRule : public WithDescriber,
			 public pair < Posit::Rule *, EvalEngine::Context * > {
	       
	       //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	       //    : CtxRule : Agent
	       //  access
	    public:
	       ITK_DEF_ACCESS3(Posit::Rule *, & rule(), { return first ;}) ;

	    public:
	       ITK_DEF_ACCESS3(EvalEngine::Context *, & context(), {
		  return second ;}) ;

	       //----------------------------------------
	       //    : CtxRule : Agent
	       //  constructor / destructor
	    public:
	       CtxRule() { 
		  rule() = ITK_NULLPTR ;
		  context() = ITK_NULLPTR ;
	       } ;
	       CtxRule(Posit::Rule * r, EvalEngine::Context * ctx) {
		  rule() = r ;
		  context() = ctx ;
	       } ;
	       
	    public:
	       virtual ~CtxRule() {} ;

	       //----------------------------------------
	       //    : CtxRule : Agent
	       //  describe
	    public:
	       virtual void describe(ostream& ostr, 
				     const Bool detailp = True) const {
		  ostr << "#CtxRule[" ;

		  if(isNull(rule())) ostr << rule() ;
		  else               ostr << *rule() ;

		  if(isNull(context())) ostr << context() ;
		  else                  ostr << *context() ;

		  ostr << "]" ;
		  
		  if(detailp) {
		     ostr << endl ;

		     ostr << "\t[rule] : " ;
		     if(isNull(rule())) ostr << rule() << endl ;
		     else               rule()->describe(ostr,detailp) ;

		     ostr << "\t[context] : " ;
		     if(isNull(context())) ostr << context() << endl ;
		     else                  context()->describe(ostr,detailp) ;
		  }
	       } ;
	 } ;

	 //==================================================
	 //    : Agent
	 // class CtxRuleStack
      public:
	 class CtxRuleStack : public StackT < CtxRule > {
	       //----------------------------------------
	       //    : RuleStack : Agent
	       //  typedefs
	    public:
	       typedef Iterator Itr ;

	       //----------------------------------------
	       //    : RuleStack : Agent
	       //  clear
	    public:
	       void clear() { reset() ;} ;
	       
	       //----------------------------------------
	       //    : RuleStack : Agent
	       //  describe
	    public:
	       virtual void describe(ostream& ostr, 
				     const Bool detailp = True) const {
		  ostr << "#RuleStack[" << Ptr(this) << "]" ;
		  if(detailp) {
		     ostr << endl ;
		     ostr << "\t[rules]" << endl ;
		     CtxRuleStack * rs = const_cast<CtxRuleStack *>(this) ;
		     for(Itr r = rs->begin() ; r < rs->end() ; r++) {
			ostr << "\t\t" << *r << endl ;
		     }
		     ostr << "\t------------------------------" << endl ;
		  }
	       } ;
	 } ;

	 //==================================================
	 //    : Agent
	 // class ContextStack
      public:
	 class ContextStack : public HeapT < EvalEngine::Context > {
	       //----------------------------------------
	       //    : ContextStack : Agent
	       //  typedefs
	    public:
	       typedef Iterator Itr ;

	       //----------------------------------------
	       //    : ContextStack : Agent
	       //  clear()
	    public:
	       void clear() { reset() ; } ;
	 } ;

	 //==================================================
	 //    : Agent
	 // === BODY ===

	 //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	 //    : Agent
	 // id
      public:
	 Int id_ ;
	 
	 ITK_DEF_ACCESS(Int & id(), { return id_ ;}) ;

	 //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	 //    : Agent
	 // engine
      public:
	 EvalEngine *engine_ ;

	 ITK_DEF_ACCESS(EvalEngine & engine(), { return *engine_ ; }) ;

	 void setEvalEngine(EvalEngine *e) { 
	    if(!isNull(engine_)) delete engine_ ;
	    engine_ = e ; 
	 } ;

	 //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	 //    : Agent
	 // situation
      public:
	 PositStack situation_ ;
	 
	 ITK_DEF_ACCESS(PositStack & situation(), { return situation_ ;}) ;

	 //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	 //    : Agent
	 // positTable ;
      public:
	 PositTable * positTable_ ;

	 ITK_DEF_ACCESS3(PositTable *,& positTable(),{ return positTable_ ;}) ;

      public:
	 static PositTable commonPositTable ;

	 //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	 //    : Agent
	 // contextStack 
      public:
	 ContextStack contextStack_ ;

	 ITK_DEF_ACCESS(ContextStack & contextStack(), { 
	    return contextStack_ ;}) ;

	 //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	 //    : Agent
	 // ctxRuleStack
      public:
	 CtxRuleStack ctxRuleStack_ ;

	 ITK_DEF_ACCESS(CtxRuleStack & ctxRuleStack(), {
	    return ctxRuleStack_ ;}) ;

	 
	 //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	 //    : Agent
	 // globalVar
      public:
	 EvalEngine::Context::BindTable globalvar_ ;
	 
	 ITK_DEF_ACCESS(EvalEngine::Context::BindTable & globalvar(), {
	    return globalvar_ ;}) ;
	 
	 //--------------------------------------------------
	 //   : Agent
	 // constructor / destructor
      public:
	 AgentBase() { init() ; };

      public:
	 virtual ~AgentBase() {} ;

	 //--------------------------------------------------
	 //   : Agent
	 // init()
      public:
	 void init() {
	    id() = 0 ;
	    positTable() = &commonPositTable ;
	    engine_ = ITK_NULLPTR ;
	    setEvalEngine(new EvalEngine) ;
	 } ;
	 
	 //--------------------------------------------------
	 //   : Agent
	 // cycle()
      public:
	 static Sexp noAction_ ;
	 static Sexp * noAction ;
	 
      public:
	 Sexp * cycle() ;
	 
	 //--------------------------------------------------
	 //   : Agent
	 // trace()
      public:
	 void traceOn() { engine().traceOn() ; } ;
      public:
	 void traceOff() { engine().traceOff() ; } ;
	 
	 //--------------------------------------------------
	 //   : Agent
	 // describe
      public:
	 virtual void describe(ostream& ostr, 
			       const Bool detailp = True) const {
	    ostr << "#" << agentTypeStr() << "[" << id() << "]" ;

	    if(detailp) {
	       ostr << endl ;
	       ostr << "\t[situation]: "  ;
	       situation().describe(ostr, detailp) ;
	       ostr << "\t[positTable]: " << *positTable() << endl ;
	    } ;
	 } ;
   } ;
   
} ;

//////////////////////////////////////////////////////////////////////
#endif
