// Address.inl
//
/////////////////////////////////////////////////////////////////////////////

#ifdef NDEBUG
//#  include
#endif

#ifndef NDEBUG
#  define inline
#else
#  define inline inline
#endif

namespace Rescue
{
	/////////////////////////////////////////////////////////////////////////
	// Address

	inline bool Address::operator== (const Address& rhs) const
	{
		if(!isValid()) {
			return isValid() == rhs.isValid();
		} else {
			return isValid() == rhs.isValid() && m_address == rhs.m_address && m_port == rhs.m_port;
		}
	}
	inline bool Address::operator< (const Address& rhs) const
	{
		if(isValid() != rhs.isValid())
			return isValid() < rhs.isValid();
		if(address() != rhs.address())
			return address() < rhs.address();
		return port() < rhs.port();
	}
	
	inline Address::Address()
	{
		m_isValid = false;
	}
	inline Address::Address(u_long address, int port, bool dummy)
	{
		ASSERT(dummy == true);
		m_address = htonl(address);
		m_port = htons((u_short)port);
		m_isValid = true;
	}
	
	inline bool Address::isValid() const
	{
		return m_isValid != false;
	}

	inline u_long Address::address() const
	{
		ASSERT(isValid());
		return ntohl(m_address);
	}
	inline u_long Address::addressAsNetworkOrder() const
	{
		ASSERT(isValid());
		return m_address;
	}
	inline u_short Address::port() const
	{
		ASSERT(isValid());
		return ntohs(m_port);
	}
	inline u_short Address::portAsNetworkOrder() const
	{
		ASSERT(isValid());
		return m_port;
	}

	/*inline Address::Address(const Address& source)
	{
		Address();
		operator= (source);
	}
	inline Address& Address::operator= (const Address& rhs)
	{
		if(this == &rhs)
			return *this;
		return *this;
	}
	inline bool Address::operator== (const Address& rhs) const
	{
		if(this == &rhs)
			return true;
	}*/
	
	/////////////////////////////////////////////////////////////////////////
} // namespace Rescue
#undef inline
