// -*- Mode: c++ -*-

/*
 * Copyright (C) 2001 NODA, Itsuki, CARC, AIST, JAPAN
 * Copyright (C) 1999, 2000 Itsuki Noda, Electrotechnical Laboratory, Japan
 */

#ifndef _itk_WithDescriber_h_
#define _itk_WithDescriber_h_
//////////////////////////////////////////////////////////////////////

#include <iostream.h>
#include <iomanip.h>

#include "itk/btype.h"

namespace Itk {

   /*--------------------*/
   /**
    *
    */

   class WithDescriber {
      public:
	 static Bool _dummy_load_hook_ ; /* to enforce to 
					  * link "WithDesciber.o"
					  * This is introduced
					  * for debug (dbg() functions)
					  */
	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 virtual const char* className() const { return "WithDescriber" ; } ;

	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 virtual ~WithDescriber() {} ;

	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 virtual void describeHead(ostream& ostr) const {
	    ostr << "#" << className() << "[" ;
	 } ;

	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 virtual void describeTail(ostream& ostr) const {
	    ostr << "]" ;
	 } ;

	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 virtual void describeShortBody(ostream& ostr) const {
	    ostr << Ptr(this) ;
	 } ;

	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 virtual void describeDetail(ostream& ostr) const {
	    ostr << endl ;
	 } ;

	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 virtual void describe(ostream& ostr, 
			       const Bool detailp = True) const {
	    describeHead(ostr) ;

	    describeShortBody(ostr) ;

	    describeTail(ostr) ;

	    if(detailp) {
	       describeDetail(ostr) ;
	    }
	 } ;

	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 virtual void describePtr(ostream& ostr, 
				  const Bool detailp = True) const {
	    ostr << Ptr(this) ;
	 } ;
   } ;

   /*--------------------*/
   /**
    *
    */

   inline ostream& operator<<(ostream& ostr, const WithDescriber& dt) {
      dt.describe(ostr,False) ;
      return ostr ;
   } 

   /*--------------------*/
   /**
    *
    */

   inline ostream& operator<<(ostream& ostr, const WithDescriber* ptr) {
      if(isNull(ptr)) ostr << Ptr(ptr) ;
      else ptr->describePtr(ostr,False) ;
      return ostr ;
   } 

   /*--------------------*/
   /**
    *
    */

   extern void dbg(const WithDescriber & obj) ;

   /*--------------------*/
   /**
    *
    */

   extern void dbg(const WithDescriber * obj) ;
}

//////////////////////////////////////////////////////////////////////
#endif
