// -*- Mode:C++ -*-
//Header:
//File: StackT.h
//Author: NODA, Itsuki
//Date: 1999/09/06
//

//ModifyHistory:
// 1999/09/06: Start to create this file
// 1999/09/06: Split cc file
// 1999/11/08: separate into files for each class
//EndModifyHistory:

/*
 * Copyright (C) 2001 NODA, Itsuki, CARC, AIST, JAPAN
 * Copyright (C) 1999, 2000 Itsuki Noda, Electrotechnical Laboratory, Japan
 */

#ifndef _itk_StackT_h_
#define _itk_StackT_h_
////////////////////////////////////////////////////////////////////////
#include "itk/btype.h"
#include "itk/Exception.h"
#include "itk/MemArrayT.h"

namespace Itk {
//======================================================================
// Stack

#ifndef ITK_DFLT_STACK_NAME
#define ITK_DFLT_STACK_NAME		"Stack"
#endif
#ifndef ITK_DFLT_STACK_SIZE
#define ITK_DFLT_STACK_SIZE  ITK_DFLT_MEMARRAY_SIZE
#endif

//------------------------------------------------------------
// class template

   /*--------------------*/
   /**
    *
    */

   template <class Content>
      class StackT : public MemArrayT<Content> {
	 public:

	    //--------------------------------------------------
	    // local type def

	    typedef StackT<Content> Stack ;

	    //------------------------------------------------------------
	    // Exception
	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    class XptUnderflow : public Exception {
	       public:
		  Stack* ptr ;
		  // Stack  copy ; /* this is incomplete type */

		  virtual const char * name() const { 
		     return "StackUnderflow" ; } ;
      
		  static Exception * root(char* const f, UInt const l, 
					  char* const d, const Stack* p) {
		     static XptUnderflow _root ;
		     _root.set(f,l,d) ;
		     _root.ptr = (Stack*)p ;
		     // _root.copy = *p ; /* this is incomplete type */
		     return &_root ;
		  } ;

		  virtual void describe_aux(ostream& ostr) const {
		     ostr << ":stack=" << ptr ;
		     if(!isNull(ptr)) ostr << *ptr ;
		  } ;
	    } ;

	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    class XptOverflow : public Exception {
	       public:
		  Stack* ptr ;
		  // Stack  copy ; /* this is incomplete type */

		  virtual const char * name() const { 
		     return "StackOverflow" ; } ;
      
		  static Exception * root(char* const f, UInt const l, 
					  char* const d, const Stack* p) {
		     static XptOverflow _root ;
		     _root.set(f,l,d) ;
		     _root.ptr = (Stack*)p ;
		     // _root.copy = *p ; /* this is incomplete type */
		     return &_root ;
		  } ;

		  virtual void describe_aux(ostream& ostr) const {
		     ostr << ":stack=" << (Ptr)ptr ;
		     if(!isNull(ptr)) ostr << *ptr ;
		  } ;
	    } ;

	    //--------------------------------------------------
	    // constructor
	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    StackT<Content>(char * const nm = ITK_DFLT_STACK_NAME,
			    UInt const sz = ITK_DFLT_STACK_SIZE,
			    UInt const ef = ITK_DFLT_EXPAND_FACTOR) {
	       init(nm,sz,ef) ;
	    } ;

	    //--------------------------------------------------
	    // top pointer
	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    UInt toppos() const { return edge ; } ;

	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    void rewind(UInt const newtop) { edge = newtop ; } ;

	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    void reset() { rewind(0) ; } ;
      
	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    Bool isEmpty() const { return toppos() == 0 ; } ;
      
	    //--------------------------------------------------
	    // pop/push
	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    Stack * push(const Content& val) {
	       if(edge >= size) expand() ;
	       table[edge] = val ;
	       edge++ ;
	       return this ;
	    } ;

	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    Content & pushTop() {
	       if(edge >= size) expand() ;
	       return table[edge++] ;
	    } ;

	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    Content & pop() {
	       if(edge <= 0) throw(ITK_XPT1(XptUnderflow,name,this)) ;

	       edge-- ;
	       return table[edge] ;
	    } ;

	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    Content& popN(const UInt c) {
	       if(edge < c) throw(ITK_XPT1(XptUnderflow,name,this)) ;

	       edge -= c ;
	       return table[edge] ;
	    } ;

	    //--------------------------------------------------
	    // remove element
	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    Int removeAll(const Content & val) {
	       Int c = 0 ;
	       for(UInt i = 0 ; i < edge ; i++) {
		  if(table[i] == val) {
		     removeNthBottom(i) ;
		     i-- ;
		     c++ ;
		  }
	       }
	       return c ;
	    } ;

	    //--------------------------------------------------
	    // remove Nth top/bottom
	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    void removeNthTop(UInt n) {
	       if(edge <= n) throw(ITK_XPT1(XptUnderflow,name,this)) ;

	       for(Int i = n ; i > 0 ; i--) 
		  table[edge-i-1] = table[edge-i] ;

	       edge-- ;
	    } ;

	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    void removeNthBottom(UInt n) {
	       if(edge <= n) throw(ITK_XPT1(XptOverflow,name,this)) ;

	       for(UInt i = n ; i < edge ; i++)
		  table[i] = table[i+1] ;

	       edge-- ;
	    } ;

	    //--------------------------------------------------
	    // access to top stack
	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    Content & top() const {
	       if(edge <= 0) throw(ITK_XPT1(XptUnderflow,name,this)) ;
	 
	       return table[edge-1] ;
	    } ;

	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    Content & topN(const UInt c) const {
	       if(edge <= c) throw(ITK_XPT1(XptUnderflow,name,this)) ;
	    
	       return table[edge-c-1] ;
	    } ;

	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    Content& bottomN(UInt c) const {
	       if(edge <= c) throw(ITK_XPT1(XptOverflow,name,this)) ;
	
	       return table[c] ;
	    } ;

	    //--------------------------------------------------
	    // push & get top pointer
	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    Content* pushGetTopPtr() {
	       if(edge >= size) expand() ;
	       Content *r = &(table[edge]) ;
	       edge++ ;
	       return r ;
	    } ;

	    //--------------------------------------------------
	    // describe
	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    virtual void describe(ostream& ostr, 
				  const Bool detailp = True) const {
	       ostr << "#Stack[" << name << "|" << (Ptr)this 
		    << ":" << edge << "/" << size << "]";
	 
	       if(detailp) {
		  ostr << " (expand factor = " 
		       << expandFactor << ")" << endl ;
		  ostr << " [Content]" ;
		  for(UInt i = 0 ; i < edge ; i++) {
		     ostr << endl << setw(8) << edge - i - 1 
			  << " : " << topN(i) ;
		  }
		  ostr << endl << "  === bottom ===  " << endl ;
	       }
	    } ;
      } ;
}


////////////////////////////////////////////////////////////////////////
#endif
