// -*- Mode: c++ -*-
//Header:
//File: SimpleSexp2.h
//Author: NODA, Itsuki
//Date: 2001/06/26
//

//ModifyHistory:
// 2001/06/26: Start to create this file
//EndModifyHistory:

#ifndef _itk_SimpleSexp2Token_h_
#define _itk_SimpleSexp2Token_h_
//////////////////////////////////////////////////////////////////////

/*--------------------------------------------------
 *  define Token Type
 */

#include "itk/SimpleSexp2Scanner.tab.h"

/*----------------------------------------
 *  enum Token Type
 */

#define Tkn(name) Tkn_##name

#define DefTokenType(name) Tkn(name) = SxTm_##name

   enum TokenType {
      DefTokenType(OpenBlock),
      DefTokenType(CloseBlock),
      DefTokenType(PairOp),
      DefTokenType(IntNumber),
      DefTokenType(FltNumber),
      DefTokenType(Symbol),
      DefTokenType(String),
      DefTokenType(Other),
      DefTokenType(Error),
      DefTokenType(Eof),
      Tkn_Max
   } ;

/*----------------------------------------
 *  Token Type string name
 */ 

#define CaseTokenTypeName(name) case Tkn(name) : return #name 

   inline const char * tokenTypeName(const TokenType & type) {
      switch(type) {
	 CaseTokenTypeName(OpenBlock) ;
	 CaseTokenTypeName(CloseBlock) ;
	 CaseTokenTypeName(PairOp) ;
	 CaseTokenTypeName(IntNumber) ;
	 CaseTokenTypeName(FltNumber) ;
	 CaseTokenTypeName(Symbol) ;
	 CaseTokenTypeName(String) ;
	 CaseTokenTypeName(Eof) ;
	 CaseTokenTypeName(Error) ;

	 default: return "UnKnown" ;
      }
   } ;

//////////////////////////////////////////////////////////////////////
#endif
