// -*- Mode:C++ -*-
//Header:
//File: SetT.h
//Author: NODA, Itsuki
//Date: 2001/11/30
//

//ModifyHistory:
// 2001/11/30: Start to create this file
//EndModifyHistory:

/*
 * Copyright (C) 2001 NODA, Itsuki, CARC, AIST, JAPAN
 */

#ifndef _itk_SetT_h_
#define _itk_SetT_h_
////////////////////////////////////////////////////////////////////////

#include <set>
#include "itk/btype.h"
#include "itk/Exception.h"
#include "itk/WithDescriber.h"

namespace Itk {

   //======================================================================
   // class SetT

   /*--------------------*/
   /**
    *
    */
   template <class Content> 
   class SetT : public WithDescriber, public set< Content > {
	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 virtual const char * className() const { return "Set" ; } ;
	 
	 //--------------------------------------------------
	 //	: SetT<Content> :
	 // local type def
      public:
	 typedef SetT<Content> Set ;

	 /*--------------------*/
	 /**
	  *
	  */
	 typedef Set::iterator Itr ;

	 /*--------------------*/
	 /**
	  *
	  */
	 typedef Set::const_iterator C_Itr ;

	 //typedef reverse_iterator RevItr ;
	 //typedef const_reverse_iterator C_RevItr ;

	 //--------------------------------------------------
	 //	: SetT<Content> :
	 // add/remove content
	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 void add(const Content & e) { insert(begin(),e) ; } ;

	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 Bool remove(const Content & e) { 
	    Itr pos = find(e) ;
	    if(pos != end()) { erase(pos) ; return True ; } 
	    else { return False ; } ;
	 } ;

	 //--------------------------------------------------
	 //	: SetT<Content> :
	 // describe
	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 virtual void 
	 describe(ostream& ostr, const Bool detailp = True) const {
	    ostr << "#" << className() << "[" << Ptr(this) << "]" ;
	    if(detailp) {
	       ostr << endl ;
	       ostr << "\t[contents]" << endl ;
	       for(C_Itr e = begin() ; e != end() ; e++) {
		  ostr << "\t\t" << *e << endl ;
	       }
	    }
	 } ;
   } ;
};

////////////////////////////////////////////////////////////////////////
#endif
