// -*- Mode:C++ -*-
//Header:
//File: RcylHeapT.h
//Author: NODA, Itsuki
//Date: 1999/09/06
//

//ModifyHistory:
// 1999/09/06: Start to create this file
// 1999/09/06: Split cc file
// 1999/11/08: separate into files for each class
//EndModifyHistory:

/*
 * Copyright (C) 2001 NODA, Itsuki, CARC, AIST, JAPAN
 * Copyright (C) 1999, 2000 Itsuki Noda, Electrotechnical Laboratory, Japan
 */

#ifndef _itk_RcylHeapT_h_
#define _itk_RcylHeapT_h_
////////////////////////////////////////////////////////////////////////
#include "itk/btype.h"
#include "itk/Exception.h"
#include "itk/WithDescriber.h"
#include "itk/StackT.h"
#include "itk/HeapT.h"

namespace Itk {
//======================================================================
// Recycle Heap
//

#ifndef ITK_DFLT_RCYLHEAP_NAME
#define ITK_DFLT_RCYLHEAP_NAME		"RcylHeap"
#endif
#ifndef ITK_DFLT_RCYLHEAP_SIZE
#define ITK_DFLT_RCYLHEAP_SIZE  ITK_DFLT_MEMARRAY_SIZE
#endif

   /*--------------------*/
   /**
    *
    */

   template <class Content>
      class RcylHeapT : public WithDescriber {
	 public:
      
	    //--------------------------------------------------
	    // local typedef

	    typedef RcylHeapT<Content> RcylHeap ;
	    typedef StackT<Content*> MyStack ;  /* Stack causes an error
						 * when using icc.
						 * why???? */
	    typedef HeapT<Content> Heap ;

	    //--------------------------------------------------
	    // member

	    char* name ;
	    MyStack stack ;
	    Heap heap ;
      
	    //--------------------------------------------------
	    // constructor
	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    RcylHeapT<Content>(char *nm = ITK_DFLT_RCYLHEAP_NAME,
			       UInt sz = ITK_DFLT_RCYLHEAP_SIZE,
			       UInt ef = ITK_DFLT_EXPAND_FACTOR) {
	       init(nm,sz,ef) ;
	    } ;

	    //--------------------------------------------------
	    // initialize
	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    void init(char *nm = ITK_DFLT_RCYLHEAP_NAME,
		      UInt sz = ITK_DFLT_RCYLHEAP_SIZE,
		      UInt ef = ITK_DFLT_EXPAND_FACTOR) {
	       name = nm ;
	       stack.init(name,sz,ef) ;
	       heap.init(name,sz,ef) ;
	       for(UInt i = 0 ; i < sz ; i++) {
		  put(heap.get(False)) ;
	       }
	    } ;

	    //--------------------------------------------------
	    // expand
	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    void expand() {
	       UInt oldsize = heap.size ;
	       heap.expand() ;
	       UInt newsize = heap.size ;
	       for(UInt i = oldsize ; i < newsize ; i++) 
		  put(heap.get()) ;
	    } ;

	    //--------------------------------------------------
	    // get new entity
	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    Content * getPtr() {
	       if(stack.isEmpty()) 
		  expand() ;
	       return stack.pop() ;
	    } ;

	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    Content & get() { return *getPtr() ; } ;

	    //--------------------------------------------------
	    // put used entity
	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    void putPtr(Content * const elm) {
	       stack.push(elm) ;
	    } ;

	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    void put(Content & elm) { putPtr(&elm) ; } ;

	    //--------------------------------------------------
	    // clear table
	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    void clear() {
	       heap.reset() ;
	       stack.reset() ;
	       for(UInt i = 0 ; i < heap.size ; i++)
		  put(heap.get()) ;
	    } ;

	    //--------------------------------------------------
	    // describe
	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    virtual void describe(ostream& ostr, 
				  const Bool detailp = True) const {
	       ostr << "#RcylHeap[" << name << "|<" << this
		    << ">:" << stack.toppos() << "/" << heap.size << "]" ;
	 
	       if(detailp) {
		  ostr << endl << "  stack=" << stack ;
		  ostr << endl << "   heap=" << heap ;
		  ostr << endl ;
	       }
	    } ;
      } ;      

} ;


////////////////////////////////////////////////////////////////////////
#endif
