// -*- Mode:C++ -*-
//Header:
//File: RandomOrder.h
//Author: NODA, Itsuki
//Date: 1999/05/18
//

//ModifyHistory:
// 1999/05/18: Start to create this file
// 1999/11/07: separate each util/class
//EndModifyHistory:

/*
 * Copyright (C) 2001 NODA, Itsuki, CARC, AIST, JAPAN
 * Copyright (C) 1999, 2000 Itsuki Noda, Electrotechnical Laboratory, Japan
 */

#ifndef _itk_RandomOrder_h_
#define _itk_RandomOrder_h_
////////////////////////////////////////////////////////////////////////

#include "itk/utility.h"
#include "itk/WithDescriber.h"

namespace Itk {

   /*--------------------*/
   /**
    *
    */

   class RandomOrder : public WithDescriber {
      public:
	 UInt* order ;
	 UInt  index ;
	 UInt  max ;

	 //--------------------------------------------------
	 // construcor
	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 RandomOrder() { order = ITK_NULLPTR ; index = 0 ; max = 0 ; } ;

	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 RandomOrder(UInt size, Bool shufflep = True) { 
	    init(size,shufflep) ;
	 } ;

	 //--------------------------------------------------
	 // init
	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 void init(UInt size, Bool shufflep = True) { 
	    if(alloc(size) && shufflep) shuffle() ;
	 } ;

	 //--------------------------------------------------
	 // destructor
	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 virtual ~RandomOrder() {
	    if(!isNull(order)) delete order ;
	 } ;

	 //--------------------------------------------------
	 // allocator
	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 Bool alloc(UInt size) {
	    order = new UInt[size] ;
	    if(!isNull(order)) {
	       max = size ;
	       sort() ;
	       return True ;
	    } else {
	       max = 0 ;
	       return False ;
	    }
	 } ;

	 //--------------------------------------------------
	 // sort
	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 void sort() {
	    for(UInt i = 0 ; i < max ; i++) order[i] = i ;
	 } ;

	 //--------------------------------------------------
	 // shuffle
	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 void shuffle() { shuffle(max) ; } ;
	 void shuffle(UInt m) {
	    for(UInt i = 0 ; i < m ; i++) {
	       UInt j = intRand(m) ;
	       Swap(order[i],order[j]) ;
	    }
	    index = 0 ;
	 } ;

	 //--------------------------------------------------
	 // pop
	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 UInt pop() { return(order[index++]) ; } ;

	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 UInt top() { return(order[index]) ; } ;

	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 UInt operator++ () { return pop() ; } ;

	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 UInt operator++ (int) { return pop() ; } ;

	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 UInt operator* () { return top() ; } ;

	 //--------------------------------------------------
	 // end check
	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 Bool isEnd() { return index >= max ; } ;

	 //--------------------------------------------------
	 // describe
	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 virtual void describe(ostream& ostr, Bool detailp = True) const {
	    ostr << "#RandomOrder[" << order 
		 << ":" << index << "/" << max << "]" ;
	    if(detailp) {
	       ostr << endl ;
	       ostr << "\t(" ;
	       for(UInt i = 0 ; i < max ; i++) {
		  if(i > 0) ostr << "," ;
		  ostr << order[i] ;
	       }
	       ostr << ")";
	       ostr << endl ;
	    }
	 } ;
      
   } ;
} ;

////////////////////////////////////////////////////////////////////////
#endif
