// -*- Mode:C++ -*-
//Header:
//File: NameTableT.h
//Author: NODA, Itsuki
//Date: 1999/09/06
//

//ModifyHistory:
// 1999/09/06: Start to create this file
// 1999/09/06: Split cc file
// 1999/11/08: separate into files for each class
//EndModifyHistory:

/*
 * Copyright (C) 2001 NODA, Itsuki, CARC, AIST, JAPAN
 * Copyright (C) 1999, 2000 Itsuki Noda, Electrotechnical Laboratory, Japan
 */

#ifndef _itk_NameTableT_h_
#define _itk_NameTableT_h_
////////////////////////////////////////////////////////////////////////
#include "itk/btype.h"
#include "itk/SString.h"
#include "itk/IndexTableT.h"

namespace Itk {
//======================================================================
// name table

#ifndef ITK_DFLT_NAMETABLE_NAME
#define ITK_DFLT_NAMETABLE_NAME	"NameTable"
#endif
#ifndef ITK_DFLT_NAMETABLE_SIZE
#define ITK_DFLT_NAMETABLE_SIZE	ITK_DFLT_INDEXTABLE_SIZE
#endif


   /*--------------------*/
   /**
    *
    */

   template <class Content>
      class NameTableT : public IndexTableT<SString, Content> {
	 public:
	    //--------------------------------------------------
	    // local typedef

	    typedef NameTableT<Content> NameTable ;
      
	    //--------------------------------------------------
	    // constructor
	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    NameTableT<Content>(char* nm = ITK_DFLT_NAMETABLE_NAME,
				UInt sz = ITK_DFLT_NAMETABLE_SIZE) {
	       init(nm,sz) ;
	    } ;

	    //--------------------------------------------------
	    // assign
	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    Entry* assign(const char * index) {
	       return IndexTable::assign(SString(strdup(index))) ;
	    } ;

	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    Entry* assign(const char * index, const Content & content) {
	       return IndexTable::assign(SString(strdup(index)),content) ;
	    } ;

	    //--------------------------------------------------
	    // find
	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    Content & find(const char * index) const {
	       return IndexTable::find(SString((char*)index)) ;
	    } ;

	    //--------------------------------------------------
	    // get
	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    Content & get(const char * index) { 
	       return IndexTable::get(SString((char*)index)) ;
	    } ;

	    //--------------------------------------------------
	    // remove
	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    Bool remove(const char * index) {
	       return IndexTable::remove(SString(index)) ;
	    } ;

      } ;

}


////////////////////////////////////////////////////////////////////////
#endif
