// -*- Mode:C++ -*-
//Header:
//File: MemPtrArrayT.h
//Author: NODA, Itsuki
//Date: 1999/09/06
//

//ModifyHistory:
// 1999/09/06: Start to create this file
// 1999/09/06: Split cc file
// 1999/11/08: separate into files for each class
//EndModifyHistory:

/*
 * Copyright (C) 2001 NODA, Itsuki, CARC, AIST, JAPAN
 * Copyright (C) 1999, 2000 Itsuki Noda, Electrotechnical Laboratory, Japan
 */

#ifndef _itk_MemPtrArrayT_h_
#define _itk_MemPtrArrayT_h_
////////////////////////////////////////////////////////////////////////
#include "itk/btype.h"
#include "itk/Exception.h"
#include "itk/MemArrayT.h"

namespace Itk {
//======================================================================
// PtrArray<Content>
//	Memory Pointer Array

#ifndef ITK_DFLT_MEMPTRARRAY_NAME
#define ITK_DFLT_MEMPTRARRAY_NAME  "MemPtrArray"
#endif
#ifndef ITK_DFLT_MEMPTRARRAY_SIZE
#define ITK_DFLT_MEMPTRARRAY_SIZE  ITK_DFLT_MEMARRAY_SIZE
#endif

//------------------------------------------------------------
// class template

   /*--------------------*/
   /**
    *
    */

   template <class Content>
      class MemPtrArrayT : public MemArrayT<Content *> {
	 public:

	    //--------------------------------------------------
	    // local typedef

	    typedef MemPtrArrayT<Content> MemPtrArray ;

	    //--------------------------------------------------
	    // constructor
	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    MemPtrArrayT<Content>(char *nm = ITK_DFLT_MEMPTRARRAY_NAME,
				  UInt sz = ITK_DFLT_MEMPTRARRAY_SIZE,
				  UInt ef = ITK_DFLT_EXPAND_FACTOR) {
	       init(nm,sz,ef) ;
	    } ;

	    //--------------------------------------------------
	    // initialize
	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    void init(char *nm = ITK_DFLT_MEMPTRARRAY_NAME,
		      UInt sz = ITK_DFLT_MEMPTRARRAY_SIZE,
		      UInt ef = ITK_DFLT_EXPAND_FACTOR) {
	       this->MemArray::init(nm,0,ef) ;
	       expand(sz) ;
	    } ;

	    //--------------------------------------------------
	    // expand
	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    void expand() {
	       if(size > 0) return expand(size * expandFactor) ;
	       else return expand(ITK_DFLT_MEMPTRARRAY_SIZE) ;
	    } ;

	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    void expand(UInt newsize) ;

	    //--------------------------------------------------
	    // describe
	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    virtual void describe(ostream& ostr, 
				  const Bool detailp = True) const {
	       this->MemArray::describe(ostr,False) ;

	       if(detailp) {
		  ostr << " (expand factor = " << expandFactor << ")" 
		       << endl ;
		  ostr << " [Content]" ;
		  for(UInt i = 0 ; i < edge ; i++) {
		     ostr << endl << setw(8) << i 
			  << " : <" << table[i] << ">"
			  << " " << *(table[i]) ;
		  }
		  ostr << endl << "  === bottom ===  " << endl ;
	       }
	    } ;

      } ;

//--------------------------------------------------
// expand

   /*--------------------*/
   /**
    *
    */

   template <class Content>
      void MemPtrArrayT<Content>::expand(UInt newsize) {
      UInt oldsize = size ;
      UInt sizedif = newsize - oldsize ;

      this->MemArray::expand(newsize) ;

      Content * newmem = new Content[sizedif] ;
      if(isNull(newmem)) 
	 throw(ITK_XPT(XptFailMemoryAlloc,"at expand MemPtrArray")) ;
	 
      for(UInt i = 0 ; i < sizedif ; i++) 
	 table[i+oldsize] = &(newmem[i]) ;
   }


}


////////////////////////////////////////////////////////////////////////
#endif
