// -*- Mode:C++ -*-
//Header:
//File: ListT.h
//Author: NODA, Itsuki
//Date: 2001/11/30
//

//ModifyHistory:
// 2001/11/30: Start to create this file
//EndModifyHistory:

/*
 * Copyright (C) 2001 NODA, Itsuki, CARC, AIST, JAPAN
 */

#ifndef _itk_ListT_h_
#define _itk_ListT_h_
////////////////////////////////////////////////////////////////////////

#include <list>
#include "itk/btype.h"
#include "itk/Exception.h"
#include "itk/WithDescriber.h"

namespace Itk {

   //======================================================================
   // class ListT
   /*--------------------*/
   /**
    *
    */

   template <class Content> 
   class ListT : public WithDescriber, public list< Content > {
      public:
	 virtual const char * className() const { return "List" ; } ;
	 
	 //--------------------------------------------------
	 //	: ListT<Content> :
	 // local type def
      public:
	 typedef ListT<Content> List ;

	 typedef List::iterator Itr ;
	 typedef List::const_iterator C_Itr ;
	 //typedef reverse_iterator RevItr ;
	 //typedef const_reverse_iterator C_RevItr ;

	 //--------------------------------------------------
	 //	: ListT<Content> :
	 // describe
	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 virtual void 
	 describe(ostream& ostr, const Bool detailp = True) const {
	    ostr << "#" << className() << "[" << Ptr(this) << "]" ;
	    if(detailp) {
	       ostr << endl ;
	       ostr << "\t[contents]" << endl ;
	       for(C_Itr e = begin() ; e != end() ; e++) {
		  ostr << "\t\t" << *e << endl ;
	       }
	    }
	 } ;
   } ;
};

////////////////////////////////////////////////////////////////////////
#endif
