// -*- Mode: c++ -*-
//Header:
//File: CondVar.h
//Author: NODA, Itsuki
//Date: 1999/05/18
//

//ModifyHistory:
// 1999/05/18: Start to create this file
// 1999/11/07: introduce Itk namespace
// 1999/11/07: Divide each class to separate file
//EndModifyHistory:

/*
 * Copyright (C) 2001 NODA, Itsuki, CARC, AIST, JAPAN
 * Copyright (C) 1999, 2000 Itsuki Noda, Electrotechnical Laboratory, Japan
 */

#ifndef _itk_CondVar_h_
#define _itk_CondVar_h_
//////////////////////////////////////////////////////////////////////

//======================================================================
// includes

extern "C" {
#ifdef THREADED
#include <pthread.h>
#endif
}


#include "itk/btype.h"
#include "itk/WithDescriber.h"
#include "itk/TimeVal.h"
#include "itk/Mutex.h"

namespace Itk {
   
//======================================================================
// Mutex

   /*--------------------*/
   /**
    *
    */

   class CondVar {
      public:
#ifdef THREADED
	 pthread_cond_t entity ;
#endif	 
	 
	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 CondVar() { init() ; } ;

	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 ~CondVar() { destroy() ; } ;

      private:
	 void init() {
#ifdef THREADED
	    pthread_cond_init(&entity,ITK_NULLPTR) ;
#endif	 
	 } ;

      private:
	 void destroy() {
#ifdef THREADED
	    pthread_cond_destroy(&entity) ;
#endif	 
	 } ;

	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 void signal() {
#ifdef THREADED
	    pthread_cond_signal(&entity) ;
#endif	 
	 } ;

	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 void broadcast() {
#ifdef THREADED
	    pthread_cond_broadcast(&entity) ;
#endif	 
	 } ;

	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 Int wait(Mutex& mutex) {
#ifdef THREADED
	    return pthread_cond_wait(&entity,&(mutex.entity)) ;
#else
	    return 0 ;
#endif	 
	 } ;

	 /*--------------------*/
	 /**
	  *
	  */
     public:
	 Bool waitUntil(Mutex& mutex, TimeVal& expire) {
#ifdef THREADED
	    struct timespec etime = expire.in_struct_timespec() ;
	    Int r = pthread_cond_timedwait(&entity,&(mutex.entity),&etime) ;
	    if(!r) return True ;
	    else return False ;
#else
	    return False ;
#endif	 
	 } ;

	 /*--------------------*/
	 /**
	  *
	  */
     public:
	 Bool waitFor(Mutex& mutex, TimeVal& interval) {
	    TimeVal expire ; 
	    expire.update() ;
	    expire += interval ;
	    return waitUntil(mutex, expire) ;
	 } ;

	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 Bool timedWait(Mutex& mutex, TimeVal& expire) {
	    return waitUntil(mutex,expire) ;
	 } ;

   } ;
};

//////////////////////////////////////////////////////////////////////
#endif
