/*
 * Header    :
 * File      : civilian.cxx
 * Auther    : Kosuke Shinoda
 * Since     : 2001/11/16
 * Time-stamp: "2002-04-28 01:25:05 kshinoda"
 * Comment   :
 * End       :
 */
/*
 * Copyright (C) 2001 SHINODA, Kosuke. Jaist,Japan & CARC, AIST, JAPAN
 * Copyright (C) 2001 NODA, Itsuki, CARC, AIST, JAPAN
 */
#include <stdio.h>
#include "../itk/itk.h"
#include "../librescue/librescue.hxx"
#include "CivilianController.hxx"
#include "Controller.hxx"

using namespace Itk;
using namespace Rescue;
using namespace RescueCivilian;

typedef std::map<Id, AutoPtr<Controller> > IdToController;

//------------------------------------------------------------
// connectOk(IdToController&, LongUDPSocket& Input&, Output&);
void connectOk(IdToController& idToController, 
	       const char* filename,
	       LongUDPSocket& socket, 
	       Input& input,
	       Output& output) {
  input.get();
  Id selfId = input.get();

  //return acknowledge to kernel
  output.clear();
  output.put(AK_ACKNOWLEDGE);
  Output::Cursor base = output.put(~(S32)0);
  output.put(selfId);
  output.setSize(base);
  output.put(HEADER_NULL);
  socket.send(output, socket.addressRecievedFrom(), -1);
  
  // set Controller list
  AutoPtr<Controller> controller = AutoPtr<Controller>(new CivilianController(selfId, socket.addressRecievedFrom(), filename, socket, input, output));
  //CivilianController* c = dynamic_cast<CivilianController*>(&*controller);
  //c->env()._controller() = c;
  idToController[selfId] = controller;
  printf("connect ok: id = %ld\n", (long)selfId);
};

//------------------------------------------------------------
// senseReceived(S32, IdToController&, LongUDPSocket&, Input&, Output&)
void senseReceived(Id id, S32 time,
		   IdToController& idToController,
		   LongUDPSocket& socket, 
		   Input& input, Output& output){
  Controller* controller = idToController[id].get();
  controller->sensed(time, socket, input, output);
};

void hearReceived(IdToController& idToController, 
		  LongUDPSocket& socket, 
		  Input& input, 
		  Output& output){
  Id id = input.get();
  CivilianController* controller = 
    dynamic_cast<CivilianController*>(idToController[id].get());
  Id speaker = input.get();
  std::string message;
  input.getString(message);
  controller->heard(socket, speaker, message.c_str(), input, output);
};

//------------------------------------------------------------
// action loop;
void agent_loop(IdToController& idToController,
	  LongUDPSocket& socket, Input& input, Output& output){
  static IdToController::iterator it = idToController.begin();
  while(socket.empty()){
    Controller* controller = it->second.get();
    if(controller->needToCycle()){
      Sexp* result = controller->cycle();
      controller->needToCycle2(result);
    }
    //----------------------------------------
    // chenge next controller;
    if(++it == idToController.end()){
      it = idToController.begin();
    }
  }
};

//------------------------------------------------------------
// 
int main(int argc, char** argv){
  const char* host = "localhost";
  Config config;
  const char* rulefile_name = "rule.txt";

  int number = INT_MAX;
  int count = 0;
  S32 current_time = 0;

  //----------------------------------------
  // Option
  //  -file FILENAME     : configuration filename
  //  -rulefile FILENAME : rulefile for agent
  for(int i = 1; i < argc; i++){
    if(argv[i][0] == '-') {
      if(strcmp(argv[i], "-file") == 0) {
	if(++i < argc) {
	  config.readConfigFile(argv[i]);
	} else {
	  fprintf(stderr, "error: '-file'\n");
	}
      } else if(strcmp(argv[i], "-rulefile") == 0) {
	if(++i < argc){
	  rulefile_name = argv[i];
	} else {
	  fprintf(stderr, "error: '-rulefile'\n");
	}
      } else {
	if(++i < argc) {
	  if(!config.setValue(argv[i-1]+1, argv[i]))
	    fprintf(stderr, "error: '%s'\n", argv[i]);
	} else {
	  fprintf(stderr, "error: '%s'\n", argv[i-1]);
	}
      }
    } else {
      switch(count++) {
      case 0:
	host = argv[i];
	break;
      case 1:
	number = atoi(argv[i]);
	break;
      default:
	fprintf(stderr, "error: '%s'\n", argv[i]);
	break;
      }
    }
  }

  //----------------------------------------
  // set LongUDPSocket
  LongUDPSocket socket("");
  Input input;
  Output output;
  output.setWait(config.send_udp_wait());
  Address to(host, config.port());
  IdToController idToController;

  S32 num_of_waitingmessage = 0;
  Bool first = True;
  // agent connection
  for(;;) {
    if(number-- > 0) {
      printf("connecting...\n");
      output.clear();
      output.put(AK_CONNECT);
      Output::Cursor base = output.put(~(S32)0);
      output.put((S32)number);    // temporaryId
      if(first){
	output.put((S32)0);         // version
	first = False;
      } else {
	output.put((S32)1);
      }
      output.put(1 << AGENTTYPE_CIVILIAN);
      output.setSize(base);
      output.put(HEADER_NULL);
      socket.send(output, to, -1);
      num_of_waitingmessage++;

    }
    if(!socket.empty() || num_of_waitingmessage > 0){
      socket.receive(input);
      num_of_waitingmessage--;

      for(;;){
	Header header = input.get();
	if(header == HEADER_NULL)
	  break;
	S32 size = input.get();
	Input::Cursor start = input.cursor();
	switch(header){
	case KA_CONNECT_ERROR:
	  {
	    std::string reason;
	    input.get(); // tmporaryId
	    input.getString(reason);
	    fprintf(stderr, "Connection failed: '%s'\n", reason.c_str());
	    number = 0;
	    break;
	  }
	case KA_CONNECT_OK:
	  connectOk(idToController, rulefile_name, socket, input, output);
	  break;    
	default:
	  fprintf(stderr, "Unknown header. 0x%lX\n", (long)header);
	  break;
	}
	input.setCursor(start);
	input.skip(size);
      }
    }
    if(number <= 0 && num_of_waitingmessage <= 0)
      break;
  }
    
  // loop
  for(;;) {
    // receive data from kernel
    socket.receive(input);
    //ITK_TIME("civilian cycle",{
    for(;;){
      Header header = input.get();
      if(header == HEADER_NULL)
	break;
      S32 size = input.get();
      Input::Cursor start = input.cursor();
      
      S32 time = 0;
      switch(header) {
      default:
	fprintf(stderr, "Unknown header2. 0x%lX\n", (long)header);
	break;
      case KA_SENSE:
	{
	  Id id = input.get();
	  time = input.get(); //current time
	  //----------------------------------------
	  // check point :: for next step 
	  if(time > current_time) {
	    printf("loop----------------------------------\n");
	    ITK_DBG(time);
	    current_time = time;//Controller will have new step
	    for(IdToController::iterator it = idToController.begin();
		it != idToController.end();it++){
	      Controller* controller = it->second.get();
	      controller->nextstep();
	    }
	  }
	  senseReceived(id, time, idToController, socket, input, output);
	  Controller* controller = idToController[id].get();
	  controller->cycle();
	  //agent_loop(idToController, socket, input, output);
	  break;
	}
      case KA_HEAR:
	hearReceived(idToController, socket, input, output);
	agent_loop(idToController, socket, input, output);      
	break;
      }
      input.setCursor(start);
      input.skip(size);
    }
    //  });
  }
  return 0;
};

